/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server.resources;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ResourceAttributes {
    private final ConcurrentMap<String, AttributeValues> attributes = new ConcurrentHashMap<String, AttributeValues>();

    public int getCount() {
        return this.attributes.size();
    }

    public String getTitle() {
        if (this.containsAttribute("title")) {
            return this.getAttributeValues("title").get(0);
        }
        return null;
    }

    public void setTitle(String title) {
        this.findAttributeValues("title").setOnly(title);
    }

    public void addResourceType(String type) {
        this.findAttributeValues("rt").add(type);
    }

    public void clearResourceType() {
        this.attributes.remove("rt");
    }

    public List<String> getResourceTypes() {
        return this.getAttributeValues("rt");
    }

    public void addInterfaceDescription(String description) {
        this.findAttributeValues("if").add(description);
    }

    public List<String> getInterfaceDescriptions() {
        return this.getAttributeValues("if");
    }

    public void setMaximumSizeEstimate(String size) {
        this.findAttributeValues("sz").setOnly(size);
    }

    public void setMaximumSizeEstimate(int size) {
        this.findAttributeValues("sz").setOnly(Integer.toString(size));
    }

    public String getMaximumSizeEstimate() {
        return this.findAttributeValues("sz").getFirst();
    }

    public void addContentType(int type) {
        this.findAttributeValues("ct").add(Integer.toString(type));
    }

    public List<String> getContentTypes() {
        return this.getAttributeValues("ct");
    }

    public void clearContentType() {
        this.attributes.remove("ct");
    }

    public void setObservable() {
        this.findAttributeValues("obs").setOnly("");
    }

    public boolean hasObservable() {
        return !this.getAttributeValues("obs").isEmpty();
    }

    public void setAttribute(String attr, String value) {
        this.findAttributeValues(attr).setOnly(value);
    }

    public void addAttribute(String attr) {
        this.addAttribute(attr, "");
    }

    public void addAttribute(String attr, String value) {
        this.findAttributeValues(attr).add(value);
    }

    public void clearAttribute(String attr) {
        this.attributes.remove(attr);
    }

    public boolean containsAttribute(String attr) {
        return this.attributes.containsKey(attr);
    }

    public Set<String> getAttributeKeySet() {
        return this.attributes.keySet();
    }

    public List<String> getAttributeValues(String attr) {
        AttributeValues list = (AttributeValues)this.attributes.get(attr);
        if (list != null) {
            return list.getAll();
        }
        return Collections.emptyList();
    }

    private AttributeValues findAttributeValues(String attr) {
        AttributeValues prev;
        AttributeValues list = (AttributeValues)this.attributes.get(attr);
        if (list == null && (prev = this.attributes.putIfAbsent(attr, list = new AttributeValues())) != null) {
            return prev;
        }
        return list;
    }

    private static final class AttributeValues {
        private final List<String> list = Collections.synchronizedList(new LinkedList());

        private AttributeValues() {
        }

        private List<String> getAll() {
            return this.list;
        }

        private void add(String value) {
            this.list.add(value);
        }

        private synchronized String getFirst() {
            if (this.list.isEmpty()) {
                return "";
            }
            return this.list.get(0);
        }

        private synchronized void setOnly(String value) {
            this.list.clear();
            if (value != null) {
                this.list.add(value);
            }
        }
    }
}

