/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.monitor.internal.metrics;

import com.google.gson.Gson;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.io.monitor.internal.metrics.OpenhabCoreMeterBinder;
import org.openhab.core.thing.ThingRegistry;
import org.openhab.core.thing.ThingStatus;
import org.openhab.core.thing.ThingStatusInfo;
import org.openhab.core.thing.events.ThingStatusInfoEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ThingStateMetric
implements OpenhabCoreMeterBinder,
EventSubscriber {
    private final Logger logger = LoggerFactory.getLogger(ThingStateMetric.class);
    public static final String METRIC_NAME = "openhab.thing.state";
    private static final String THING_TAG_NAME = "thing";
    private final ThingRegistry thingRegistry;
    private final Meter.Id commonMeterId;
    private final Map<Meter.Id, AtomicInteger> registeredMeters = new HashMap<Meter.Id, AtomicInteger>();
    private @Nullable MeterRegistry meterRegistry;
    private @Nullable ServiceRegistration<?> eventSubscriberRegistration;
    private final BundleContext bundleContext;
    private final Gson gson = new Gson();

    public ThingStateMetric(BundleContext bundleContext, ThingRegistry thingRegistry, Collection<Tag> tags) {
        this.bundleContext = bundleContext;
        this.thingRegistry = thingRegistry;
        this.commonMeterId = new Meter.Id(METRIC_NAME, Tags.of(tags), "state", "openHAB thing state", Meter.Type.GAUGE);
    }

    @Override
    public void bindTo(@NonNullByDefault(value={}) MeterRegistry meterRegistry) {
        this.unbind();
        this.logger.debug("ThingStateMetric is being bound...");
        this.meterRegistry = meterRegistry;
        this.thingRegistry.getAll().forEach(thing -> this.createOrUpdateMetricForBundleState(thing.getUID().getAsString(), thing.getStatus().ordinal()));
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, null);
    }

    private void createOrUpdateMetricForBundleState(String thingUid, int thingStatus) {
        Meter.Id uniqueId = this.commonMeterId.withTag(Tag.of(THING_TAG_NAME, thingUid));
        AtomicInteger thingStateHolder = this.registeredMeters.get(uniqueId);
        if (thingStateHolder == null) {
            thingStateHolder = new AtomicInteger();
            Gauge.builder(uniqueId.getName(), thingStateHolder, AtomicInteger::get).baseUnit(uniqueId.getBaseUnit()).description(uniqueId.getDescription()).tags(uniqueId.getTags()).register(this.meterRegistry);
            this.registeredMeters.put(uniqueId, thingStateHolder);
        }
        thingStateHolder.set(thingStatus);
    }

    @Override
    public void unbind() {
        MeterRegistry meterRegistry = this.meterRegistry;
        if (meterRegistry == null) {
            return;
        }
        ServiceRegistration<?> eventSubscriberRegistration = this.eventSubscriberRegistration;
        if (eventSubscriberRegistration != null) {
            eventSubscriberRegistration.unregister();
            this.eventSubscriberRegistration = null;
        }
        this.registeredMeters.keySet().forEach(meterRegistry::remove);
        this.registeredMeters.clear();
        this.meterRegistry = null;
    }

    public Set<String> getSubscribedEventTypes() {
        return Set.of(ThingStatusInfoEvent.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public void receive(Event event) {
        Event event2 = event;
        if (event2 instanceof ThingStatusInfoEvent) {
            void thingEvent;
            ThingStatusInfoEvent thingStatusInfoEvent = (ThingStatusInfoEvent)event2;
            ThingStatusInfoEvent cfr_ignored_0 = (ThingStatusInfoEvent)event2;
            this.logger.trace("Received ThingStatusInfo(Changed)Event...");
            String thingUid = thingEvent.getThingUID().getAsString();
            ThingStatus status = ((ThingStatusInfo)this.gson.fromJson(event.getPayload(), ThingStatusInfo.class)).getStatus();
            this.createOrUpdateMetricForBundleState(thingUid, status.ordinal());
        } else {
            this.logger.trace("Received unsubscribed for event type {}", (Object)event.getClass().getSimpleName());
        }
    }
}

