/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.filters;

import ca.odell.glazedlists.matchers.Matcher;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.criteria.Value;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.actions.screens.filters.FilterCriterion;
import tr.view.filters.FilterComboAbstract;
import tr.view.filters.MultiChoiceDialog;
import tr.view.filters.ValueAll;
import tr.view.filters.ValueMultiple;
import tr.view.filters.ValueMultipleEdit;

public class FilterCriterionPriority
extends FilterCriterion
implements PropertyChangeListener {
    public static final byte INDEX = 5;
    private static final Logger LOG = Logger.getLogger("tr.view.actions");

    public FilterCriterionPriority() {
        this.initialise();
    }

    protected void initialise() {
        this.combo = new PriorityCombo();
        this.combo.addValueChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        Value value = (Value)this.combo.getSelectedItem();
        if (value == null) {
            this.fireMatchAll();
        } else if (value instanceof ValueAll) {
            this.fireMatchAll();
        } else if (value instanceof ValueMultiple) {
            ValueMultiple multiple = (ValueMultiple)value;
            this.fireChanged(new ValueMatcher(multiple.getChosen(), this.excludeNulls));
        } else {
            this.fireChanged(new ValueMatcher(value, this.excludeNulls));
        }
    }

    public String getLabel() {
        return NbBundle.getMessage(this.getClass(), (String)"filter-priority");
    }

    public byte getIndex() {
        return 5;
    }

    protected Value getValue(String id) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        Manager manager = data.getPriorityCriterion().values;
        for (Value value : manager.list()) {
            try {
                if (value.getID() != Integer.parseInt(id)) continue;
                return value;
            }
            catch (Exception ex) {
            }
        }
        return null;
    }

    public class PriorityCombo
    extends FilterComboAbstract {
        private final ActionListener listener;
        private Object lastSelectedItem;

        public PriorityCombo() {
            super((ComboBoxModel)new PriorityComboBoxModel());
            this.listener = !Utilities.isMac() ? new WindowsActionListener() : new RealActionListener();
            this.addActionListener(this.listener);
        }

        public void stopChangeEvents() {
            this.removeActionListener(this.listener);
        }

        public void startChangeEvents() {
            this.addActionListener(this.listener);
            this.lastSelectedItem = this.getSelectedItem();
        }

        private final class WindowsActionListener
        implements ActionListener {
            private WindowsActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                Object object = PriorityCombo.this.getSelectedItem();
                if (object instanceof ValueMultipleEdit) {
                    PriorityComboBoxModel model = (PriorityComboBoxModel)PriorityCombo.this.getModel();
                    ValueMultiple m = model.multiple;
                    Data data = (Data)DataLookup.instance().lookup(Data.class);
                    Vector all = data == null ? new Vector() : data.getPriorityCriterion().values.list();
                    MultiChoiceDialog d = new MultiChoiceDialog((Component)((Object)PriorityCombo.this), all, m.getChosen(), false);
                    d.setTitle(NbBundle.getMessage(this.getClass(), (String)"filter-priority"));
                    d.setLocationRelativeTo((Component)((Object)PriorityCombo.this));
                    d.setVisible(true);
                    if (d.isOkay()) {
                        m.setChosen(d.getChosen());
                        PriorityCombo.this.setSelectedItem(m);
                        PriorityCombo.this.lastSelectedItem = m;
                    } else {
                        PriorityCombo.this.setSelectedItem(PriorityCombo.this.lastSelectedItem);
                    }
                } else {
                    PriorityCombo.this.lastSelectedItem = object;
                }
                PriorityCombo.this.fireValueChange();
            }
        }

        private final class RealActionListener
        implements ActionListener {
            private RealActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                Object object = PriorityCombo.this.getSelectedItem();
                if (object instanceof ValueMultiple) {
                    ValueMultiple m = (ValueMultiple)object;
                    Data data = (Data)DataLookup.instance().lookup(Data.class);
                    Vector all = data == null ? new Vector() : data.getPriorityCriterion().values.list();
                    MultiChoiceDialog d = new MultiChoiceDialog((Component)((Object)PriorityCombo.this), all, m.getChosen(), false);
                    d.setTitle(NbBundle.getMessage(this.getClass(), (String)"filter-priority"));
                    d.setLocationRelativeTo((Component)((Object)PriorityCombo.this));
                    d.setVisible(true);
                    if (d.isOkay()) {
                        m.setChosen(d.getChosen());
                    }
                }
                PriorityCombo.this.fireValueChange();
            }
        }
    }

    private class PriorityComboBoxModel
    extends DefaultComboBoxModel
    implements Observer {
        private final ValueAll all = new ValueAll();
        private final ValueMultiple multiple = new ValueMultiple();
        private final ValueMultipleEdit multipleEdit = new ValueMultipleEdit();
        private Manager<Value> valueManager;
        private List<Value> values;
        private Lookup.Result result;

        public PriorityComboBoxModel() {
            this.initialise();
        }

        private void initialise() {
            Data data;
            if (this.valueManager != null) {
                this.valueManager.removeObserver((Observer)this);
            }
            if ((data = (Data)DataLookup.instance().lookup(Data.class)) == null) {
                this.valueManager = null;
                this.values = new Vector<Value>();
            } else {
                this.valueManager = data.getPriorityCriterion().values;
                this.valueManager.addObserver((Observer)this);
                this.values = this.valueManager.list();
            }
            this.values.add(0, (Value)this.all);
            this.values.add(1, (Value)this.multiple);
            if (!Utilities.isMac()) {
                this.values.add(2, (Value)this.multipleEdit);
            }
            if (this.result == null) {
                this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
                this.result.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        PriorityComboBoxModel.this.update(null, null);
                    }
                });
            }
        }

        public Object getElementAt(int index) {
            return this.values.get(index);
        }

        public int getSize() {
            return this.values.size();
        }

        public void update(Observable o, Object arg) {
            this.initialise();
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueMatcher
    implements Matcher<Action> {
        private final List<Value> values;
        private final boolean excludeNulls;

        public ValueMatcher(Value value, boolean excludeNulls) {
            this.values = new Vector<Value>();
            this.values.add(value);
            this.excludeNulls = excludeNulls;
        }

        public ValueMatcher(List<Value> values, boolean excludeNulls) {
            this.values = values;
            this.excludeNulls = excludeNulls;
        }

        public boolean matches(Action action) {
            if (action.getPriority() == null) {
                return !this.excludeNulls;
            }
            for (Value value : this.values) {
                if (!value.equals((Object)action.getPriority())) continue;
                return true;
            }
            return false;
        }
    }
}

