/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.batik.util.DoublyLinkedList;
import org.apache.batik.util.HaltingThread;

public class RunnableQueue
implements Runnable {
    public static final RunnableQueueState RUNNING = new RunnableQueueState("Running");
    public static final RunnableQueueState SUSPENDING = new RunnableQueueState("Suspending");
    public static final RunnableQueueState SUSPENDED = new RunnableQueueState("Suspended");
    protected RunnableQueueState state;
    protected Object stateLock = new Object();
    protected boolean wasResumed;
    protected DoublyLinkedList list = new DoublyLinkedList();
    protected int preemptCount = 0;
    protected RunHandler runHandler;
    protected HaltingThread runnableQueueThread;
    private static int threadCount;

    public static RunnableQueue createRunnableQueue() {
        RunnableQueue runnableQueue;
        RunnableQueue runnableQueue2 = runnableQueue = new RunnableQueue();
        synchronized (runnableQueue2) {
            HaltingThread haltingThread = new HaltingThread(runnableQueue, "RunnableQueue-" + threadCount++);
            haltingThread.setDaemon(true);
            haltingThread.start();
            while (runnableQueue.getThread() == null) {
                try {
                    runnableQueue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return runnableQueue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        RunnableQueue runnableQueue;
        RunnableQueue runnableQueue2 = this;
        synchronized (runnableQueue2) {
            this.runnableQueueThread = (HaltingThread)Thread.currentThread();
            this.notify();
        }
        try {
            try {
                while (!HaltingThread.hasBeenHalted()) {
                    Runnable runnable;
                    Link link;
                    Object object = this.stateLock;
                    synchronized (object) {
                        if (this.state == RUNNING) {
                            if (this.wasResumed) {
                                this.wasResumed = false;
                                this.executionResumed();
                            }
                        } else {
                            while (true) {
                                if (this.state == RUNNING) {
                                    this.wasResumed = false;
                                    this.executionResumed();
                                    break;
                                }
                                this.state = SUSPENDED;
                                this.stateLock.notifyAll();
                                this.executionSuspended();
                                try {
                                    this.stateLock.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    DoublyLinkedList doublyLinkedList = this.list;
                    synchronized (doublyLinkedList) {
                        if (this.state == SUSPENDING) {
                            continue;
                        }
                        link = (Link)this.list.pop();
                        if (this.preemptCount != 0) {
                            --this.preemptCount;
                        }
                        if (link == null) {
                            try {
                                this.list.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                        runnable = link.runnable;
                    }
                    this.runnableStart(runnable);
                    try {
                        runnable.run();
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    link.unlock();
                    this.runnableInvoked(runnable);
                }
            }
            catch (InterruptedException interruptedException) {
                Object var9_12 = null;
                RunnableQueue runnableQueue3 = this;
                synchronized (runnableQueue3) {
                    this.runnableQueueThread = null;
                    return;
                }
            }
            Object var9_11 = null;
            runnableQueue = this;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            RunnableQueue runnableQueue4 = this;
            synchronized (runnableQueue4) {
                this.runnableQueueThread = null;
                throw throwable;
            }
        }
        synchronized (runnableQueue) {
            this.runnableQueueThread = null;
            return;
        }
    }

    public HaltingThread getThread() {
        return this.runnableQueueThread;
    }

    public void invokeLater(Runnable runnable) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.push(new Link(runnable));
            this.list.notify();
        }
    }

    public void invokeAndWait(Runnable runnable) throws InterruptedException {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        if (this.runnableQueueThread == Thread.currentThread()) {
            throw new IllegalStateException("Cannot be called from the RunnableQueue thread");
        }
        LockableLink lockableLink = new LockableLink(runnable);
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.push(lockableLink);
            this.list.notify();
        }
        lockableLink.lock();
    }

    public void preemptLater(Runnable runnable) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.add(this.preemptCount, new Link(runnable));
            ++this.preemptCount;
            this.list.notify();
        }
    }

    public void preemptAndWait(Runnable runnable) throws InterruptedException {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        if (this.runnableQueueThread == Thread.currentThread()) {
            throw new IllegalStateException("Cannot be called from the RunnableQueue thread");
        }
        LockableLink lockableLink = new LockableLink(runnable);
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.add(this.preemptCount, lockableLink);
            ++this.preemptCount;
            this.list.notify();
        }
        lockableLink.lock();
    }

    public RunnableQueueState getQueueState() {
        Object object = this.stateLock;
        synchronized (object) {
            RunnableQueueState runnableQueueState = this.state;
            return runnableQueueState;
        }
    }

    public void suspendExecution(boolean bl) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.wasResumed = false;
            if (this.state == SUSPENDED) {
                this.stateLock.notifyAll();
                return;
            }
            if (this.state == RUNNING) {
                this.state = SUSPENDING;
                DoublyLinkedList doublyLinkedList = this.list;
                synchronized (doublyLinkedList) {
                    this.list.notify();
                }
            }
            if (bl) {
                while (this.state == SUSPENDING) {
                    try {
                        this.stateLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void resumeExecution() {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.wasResumed = true;
            if (this.state != RUNNING) {
                this.state = RUNNING;
                this.stateLock.notifyAll();
            }
        }
    }

    public Object getIteratorLock() {
        return this.list;
    }

    public Iterator iterator() {
        return new Iterator(){
            Link head;
            Link link;
            {
                this.head = (Link)RunnableQueue.this.list.getHead();
            }

            public boolean hasNext() {
                if (this.head == null) {
                    return false;
                }
                if (this.link == null) {
                    return true;
                }
                return this.link != this.head;
            }

            public Object next() {
                if (this.head == null || this.head == this.link) {
                    throw new NoSuchElementException();
                }
                if (this.link == null) {
                    this.link = (Link)this.head.getNext();
                    return this.head.runnable;
                }
                Runnable runnable = this.link.runnable;
                this.link = (Link)this.link.getNext();
                return runnable;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public synchronized void setRunHandler(RunHandler runHandler) {
        this.runHandler = runHandler;
    }

    public synchronized RunHandler getRunHandler() {
        return this.runHandler;
    }

    protected synchronized void executionSuspended() {
        if (this.runHandler != null) {
            this.runHandler.executionSuspended(this);
        }
    }

    protected synchronized void executionResumed() {
        if (this.runHandler != null) {
            this.runHandler.executionResumed(this);
        }
    }

    protected synchronized void runnableStart(Runnable runnable) {
        if (this.runHandler != null) {
            this.runHandler.runnableStart(this, runnable);
        }
    }

    protected synchronized void runnableInvoked(Runnable runnable) {
        if (this.runHandler != null) {
            this.runHandler.runnableInvoked(this, runnable);
        }
    }

    protected static class LockableLink
    extends Link {
        protected boolean locked;

        public LockableLink(Runnable runnable) {
            super(runnable);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public synchronized void lock() throws InterruptedException {
            this.locked = true;
            this.notify();
            this.wait();
        }

        public synchronized void unlock() throws InterruptedException {
            while (!this.locked) {
                this.wait();
            }
            this.notify();
        }
    }

    protected static class Link
    extends DoublyLinkedList.Node {
        public Runnable runnable;

        public Link(Runnable runnable) {
            this.runnable = runnable;
        }

        public void unlock() throws InterruptedException {
        }
    }

    public static class RunHandlerAdapter
    implements RunHandler {
        public void runnableStart(RunnableQueue runnableQueue, Runnable runnable) {
        }

        public void runnableInvoked(RunnableQueue runnableQueue, Runnable runnable) {
        }

        public void executionSuspended(RunnableQueue runnableQueue) {
        }

        public void executionResumed(RunnableQueue runnableQueue) {
        }
    }

    public static interface RunHandler {
        public void runnableStart(RunnableQueue var1, Runnable var2);

        public void runnableInvoked(RunnableQueue var1, Runnable var2);

        public void executionSuspended(RunnableQueue var1);

        public void executionResumed(RunnableQueue var1);
    }

    public static class RunnableQueueState {
        final String value;

        private RunnableQueueState(String string) {
            this.value = string.intern();
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "[RunnableQueueState: " + this.value + "]";
        }
    }
}

