/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;

public class JRHyperlinkHelper {
    public static final String HYPERLINK_TYPE_NONE = "None";
    public static final String HYPERLINK_TYPE_REFERENCE = "Reference";
    public static final String HYPERLINK_TYPE_LOCAL_ANCHOR = "LocalAnchor";
    public static final String HYPERLINK_TYPE_LOCAL_PAGE = "LocalPage";
    public static final String HYPERLINK_TYPE_REMOTE_ANCHOR = "RemoteAnchor";
    public static final String HYPERLINK_TYPE_REMOTE_PAGE = "RemotePage";
    private static final Map builtinTypes = JRHyperlinkHelper.createBuiltinTypes();

    private static Map createBuiltinTypes() {
        HashMap<String, Byte> types = new HashMap<String, Byte>();
        types.put(HYPERLINK_TYPE_NONE, new Byte(1));
        types.put(HYPERLINK_TYPE_REFERENCE, new Byte(2));
        types.put(HYPERLINK_TYPE_LOCAL_ANCHOR, new Byte(3));
        types.put(HYPERLINK_TYPE_LOCAL_PAGE, new Byte(4));
        types.put(HYPERLINK_TYPE_REMOTE_ANCHOR, new Byte(5));
        types.put(HYPERLINK_TYPE_REMOTE_PAGE, new Byte(6));
        return types;
    }

    public static byte getHyperlinkType(JRHyperlink hyperlink) {
        return JRHyperlinkHelper.getHyperlinkType(hyperlink.getLinkType());
    }

    public static byte getHyperlinkType(String linkType) {
        Byte builtinType;
        int type = linkType == null ? 1 : ((builtinType = (Byte)builtinTypes.get(linkType)) == null ? 7 : (int)builtinType.byteValue());
        return (byte)type;
    }

    public static String getLinkType(byte hyperlinkType) {
        String type;
        switch (hyperlinkType) {
            case 0: 
            case 1: {
                type = null;
                break;
            }
            case 2: {
                type = HYPERLINK_TYPE_REFERENCE;
                break;
            }
            case 3: {
                type = HYPERLINK_TYPE_LOCAL_ANCHOR;
                break;
            }
            case 4: {
                type = HYPERLINK_TYPE_LOCAL_PAGE;
                break;
            }
            case 5: {
                type = HYPERLINK_TYPE_REMOTE_ANCHOR;
                break;
            }
            case 6: {
                type = HYPERLINK_TYPE_REMOTE_PAGE;
                break;
            }
            case 7: {
                throw new JRRuntimeException("Custom hyperlink types cannot be specified using the byte constant");
            }
            default: {
                throw new JRRuntimeException("Unknown hyperlink type " + hyperlinkType);
            }
        }
        return type;
    }

    public static boolean isEmpty(JRHyperlink hyperlink) {
        return hyperlink == null || hyperlink.getHyperlinkType() == 1 && hyperlink.getHyperlinkTooltipExpression() == null;
    }
}

