/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.api.client.util.Key;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.firebase.auth.OidcProviderConfig;
import com.google.firebase.auth.internal.ListProviderConfigsResponse;
import java.util.List;

public final class ListOidcProviderConfigsResponse
implements ListProviderConfigsResponse<OidcProviderConfig> {
    @Key(value="oauthIdpConfigs")
    private List<OidcProviderConfig> providerConfigs;
    @Key(value="nextPageToken")
    private String pageToken;

    @VisibleForTesting
    public ListOidcProviderConfigsResponse(List<OidcProviderConfig> providerConfigs, String pageToken) {
        this.providerConfigs = providerConfigs;
        this.pageToken = pageToken;
    }

    public ListOidcProviderConfigsResponse() {
    }

    @Override
    public List<OidcProviderConfig> getProviderConfigs() {
        return this.providerConfigs == null ? ImmutableList.of() : this.providerConfigs;
    }

    @Override
    public boolean hasProviderConfigs() {
        return this.providerConfigs != null && !this.providerConfigs.isEmpty();
    }

    @Override
    public String getPageToken() {
        return Strings.nullToEmpty((String)this.pageToken);
    }
}

