/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.StringTokenizer;
import jcifs.Config;
import jcifs.netbios.Lmhosts;
import jcifs.netbios.Name;
import jcifs.netbios.NameQueryRequest;
import jcifs.netbios.NameQueryResponse;
import jcifs.netbios.NameServicePacket;
import jcifs.netbios.NbtAddress;
import jcifs.netbios.NodeStatusRequest;
import jcifs.netbios.NodeStatusResponse;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;

class NameServiceClient
implements Runnable {
    static final int DEFAULT_SO_TIMEOUT = 5000;
    static final int DEFAULT_RCV_BUF_SIZE = 576;
    static final int DEFAULT_SND_BUF_SIZE = 576;
    static final int NAME_SERVICE_UDP_PORT = 137;
    static final int DEFAULT_RETRY_COUNT = 2;
    static final int DEFAULT_RETRY_TIMEOUT = 3000;
    static final int RESOLVER_LMHOSTS = 1;
    static final int RESOLVER_BCAST = 2;
    static final int RESOLVER_WINS = 3;
    private static final int SND_BUF_SIZE = Config.getInt("jcifs.netbios.snd_buf_size", 576);
    private static final int RCV_BUF_SIZE = Config.getInt("jcifs.netbios.rcv_buf_size", 576);
    private static final int SO_TIMEOUT = Config.getInt("jcifs.netbios.soTimeout", 5000);
    private static final int RETRY_COUNT = Config.getInt("jcifs.netbios.retryCount", 2);
    private static final int RETRY_TIMEOUT = Config.getInt("jcifs.netbios.retryTimeout", 3000);
    private static final int LPORT = Config.getInt("jcifs.netbios.lport", 0);
    private static final InetAddress LADDR = Config.getInetAddress("jcifs.netbios.laddr", null);
    private static final String RO = Config.getProperty("jcifs.resolveOrder");
    private static LogStream log = LogStream.getInstance();
    private final Object LOCK = new Object();
    private int lport;
    private int closeTimeout;
    private byte[] snd_buf;
    private byte[] rcv_buf;
    private DatagramSocket socket;
    private DatagramPacket in;
    private DatagramPacket out;
    private HashMap responseTable = new HashMap();
    private Thread thread;
    private int nextNameTrnId = 0;
    private int[] resolveOrder;
    InetAddress laddr;
    InetAddress baddr;

    NameServiceClient() {
        this(LPORT, LADDR);
    }

    NameServiceClient(int lport, InetAddress laddr) {
        this.lport = lport;
        this.laddr = laddr;
        try {
            this.baddr = Config.getInetAddress("jcifs.netbios.baddr", InetAddress.getByName("255.255.255.255"));
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        this.snd_buf = new byte[SND_BUF_SIZE];
        this.rcv_buf = new byte[RCV_BUF_SIZE];
        this.out = new DatagramPacket(this.snd_buf, SND_BUF_SIZE, this.baddr, 137);
        this.in = new DatagramPacket(this.rcv_buf, RCV_BUF_SIZE);
        if (RO == null || RO.length() == 0) {
            if (NbtAddress.getWINSAddress() == null) {
                this.resolveOrder = new int[2];
                this.resolveOrder[0] = 1;
                this.resolveOrder[1] = 2;
            } else {
                this.resolveOrder = new int[3];
                this.resolveOrder[0] = 1;
                this.resolveOrder[1] = 3;
                this.resolveOrder[2] = 2;
            }
        } else {
            int[] tmp = new int[3];
            StringTokenizer st = new StringTokenizer(RO, ",");
            int i = 0;
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.equalsIgnoreCase("LMHOSTS")) {
                    tmp[i++] = 1;
                    continue;
                }
                if (s.equalsIgnoreCase("WINS")) {
                    if (NbtAddress.getWINSAddress() == null) {
                        if (LogStream.level <= 1) continue;
                        log.println("NetBIOS resolveOrder specifies WINS however the jcifs.netbios.wins property has not been set");
                        continue;
                    }
                    tmp[i++] = 3;
                    continue;
                }
                if (s.equalsIgnoreCase("BCAST")) {
                    tmp[i++] = 2;
                    continue;
                }
                if (s.equalsIgnoreCase("DNS")) continue;
                if (LogStream.level <= 1) continue;
                log.println("unknown resolver method: " + s);
            }
            this.resolveOrder = new int[i];
            System.arraycopy(tmp, 0, this.resolveOrder, 0, i);
        }
    }

    int getNextNameTrnId() {
        if ((++this.nextNameTrnId & 0xFFFF) == 0) {
            this.nextNameTrnId = 1;
        }
        return this.nextNameTrnId;
    }

    void ensureOpen(int timeout) throws IOException {
        this.closeTimeout = 0;
        if (SO_TIMEOUT != 0) {
            this.closeTimeout = Math.max(SO_TIMEOUT, timeout);
        }
        if (this.socket == null) {
            this.socket = new DatagramSocket(this.lport, this.laddr);
            this.thread = new Thread((Runnable)this, "JCIFS-NameServiceClient");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryClose() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            this.thread = null;
            this.responseTable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.thread == Thread.currentThread()) {
                int nameTrnId;
                NameServicePacket response;
                this.in.setLength(RCV_BUF_SIZE);
                this.socket.setSoTimeout(this.closeTimeout);
                this.socket.receive(this.in);
                if (LogStream.level > 3) {
                    log.println("NetBIOS: new data read from socket");
                }
                if ((response = (NameServicePacket)this.responseTable.get(new Integer(nameTrnId = NameServicePacket.readNameTrnId(this.rcv_buf, 0)))) == null || response.received) continue;
                NameServicePacket nameServicePacket = response;
                synchronized (nameServicePacket) {
                    response.readWireFormat(this.rcv_buf, 0);
                    response.received = true;
                    if (LogStream.level > 3) {
                        log.println(response);
                        Hexdump.hexdump(log, this.rcv_buf, 0, this.in.getLength());
                    }
                    response.notify();
                }
            }
            return;
        }
        catch (SocketTimeoutException ste) {
            return;
        }
        catch (Exception ex) {
            if (LogStream.level <= 2) return;
            ex.printStackTrace(log);
            return;
        }
        finally {
            this.tryClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void send(NameServicePacket request, NameServicePacket response, int timeout) throws IOException {
        nid = null;
        max = NbtAddress.NBNS.length;
        if (max == 0) {
            max = 1;
        }
        var6_6 = response;
        synchronized (var6_6) {
            while (max-- > 0) {
                block19: {
                    block18: {
                        try {
                            var7_7 = this.LOCK;
                            synchronized (var7_7) {
                                request.nameTrnId = this.getNextNameTrnId();
                                nid = new Integer(request.nameTrnId);
                                this.out.setAddress(request.addr);
                                this.out.setLength(request.writeWireFormat(this.snd_buf, 0));
                                response.received = false;
                                this.responseTable.put(nid, response);
                                this.ensureOpen(timeout + 1000);
                                this.socket.send(this.out);
                                if (LogStream.level > 3) {
                                    NameServiceClient.log.println(request);
                                    Hexdump.hexdump(NameServiceClient.log, this.snd_buf, 0, this.out.getLength());
                                }
                            }
                            start = System.currentTimeMillis();
lbl25:
                            // 2 sources

                            while (timeout > 0) {
                                response.wait(timeout);
                                if (response.received && request.questionType == response.recordType) {
                                    this.responseTable.remove(nid);
                                    break block18;
                                }
                                ** GOTO lbl-1000
                            }
                            break block19;
                        }
                        catch (InterruptedException ie) {
                            try {
                                throw new IOException(ie.getMessage());
                            }
                            catch (Throwable var9_11) {
                                this.responseTable.remove(nid);
                                throw var9_11;
                            }
                        }
                    }
                    return;
lbl-1000:
                    // 1 sources

                    {
                        response.received = false;
                        timeout = (int)((long)timeout - (System.currentTimeMillis() - start));
                        ** GOTO lbl25
                    }
                }
                this.responseTable.remove(nid);
                var7_7 = this.LOCK;
                synchronized (var7_7) {
                    if (!NbtAddress.isWINS(request.addr)) {
                        return;
                    }
                    if (request.addr == NbtAddress.getWINSAddress()) {
                        NbtAddress.switchWINS();
                    }
                    request.addr = NbtAddress.getWINSAddress();
                }
            }
            return;
        }
    }

    NbtAddress[] getAllByName(Name name, InetAddress addr) throws UnknownHostException {
        int n;
        NameQueryRequest request = new NameQueryRequest(name);
        NameQueryResponse response = new NameQueryResponse();
        request.addr = addr != null ? addr : NbtAddress.getWINSAddress();
        boolean bl = request.isBroadcast = request.addr == null;
        if (request.isBroadcast) {
            request.addr = this.baddr;
            n = RETRY_COUNT;
        } else {
            request.isBroadcast = false;
            n = 1;
        }
        do {
            try {
                this.send(request, response, RETRY_TIMEOUT);
            }
            catch (IOException ioe) {
                if (LogStream.level > 1) {
                    ioe.printStackTrace(log);
                }
                throw new UnknownHostException(name.name);
            }
            if (!response.received || response.resultCode != 0) continue;
            return response.addrEntry;
        } while (--n > 0 && request.isBroadcast);
        throw new UnknownHostException(name.name);
    }

    NbtAddress getByName(Name name, InetAddress addr) throws UnknownHostException {
        NameQueryRequest request = new NameQueryRequest(name);
        NameQueryResponse response = new NameQueryResponse();
        if (addr != null) {
            request.addr = addr;
            request.isBroadcast = addr.getAddress()[3] == -1;
            int n = RETRY_COUNT;
            do {
                try {
                    this.send(request, response, RETRY_TIMEOUT);
                }
                catch (IOException ioe) {
                    if (LogStream.level > 1) {
                        ioe.printStackTrace(log);
                    }
                    throw new UnknownHostException(name.name);
                }
                if (!response.received || response.resultCode != 0) continue;
                int last = response.addrEntry.length - 1;
                response.addrEntry[last].hostName.srcHashCode = addr.hashCode();
                return response.addrEntry[last];
            } while (--n > 0 && request.isBroadcast);
            throw new UnknownHostException(name.name);
        }
        for (int i = 0; i < this.resolveOrder.length; ++i) {
            try {
                block3 : switch (this.resolveOrder[i]) {
                    case 1: {
                        NbtAddress ans = Lmhosts.getByName(name);
                        if (ans == null) break;
                        ans.hostName.srcHashCode = 0;
                        return ans;
                    }
                    case 2: 
                    case 3: {
                        if (this.resolveOrder[i] == 3 && name.name != "\u0001\u0002__MSBROWSE__\u0002" && name.hexCode != 29) {
                            request.addr = NbtAddress.getWINSAddress();
                            request.isBroadcast = false;
                        } else {
                            request.addr = this.baddr;
                            request.isBroadcast = true;
                        }
                        int n = RETRY_COUNT;
                        while (n-- > 0) {
                            try {
                                this.send(request, response, RETRY_TIMEOUT);
                            }
                            catch (IOException ioe) {
                                if (LogStream.level > 1) {
                                    ioe.printStackTrace(log);
                                }
                                throw new UnknownHostException(name.name);
                            }
                            if (response.received && response.resultCode == 0) {
                                response.addrEntry[0].hostName.srcHashCode = request.addr.hashCode();
                                return response.addrEntry[0];
                            }
                            if (this.resolveOrder[i] != 3) continue;
                            break block3;
                        }
                        break;
                    }
                }
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        throw new UnknownHostException(name.name);
    }

    NbtAddress[] getNodeStatus(NbtAddress addr) throws UnknownHostException {
        NodeStatusResponse response = new NodeStatusResponse(addr);
        NodeStatusRequest request = new NodeStatusRequest(new Name("*\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", 0, null));
        request.addr = addr.getInetAddress();
        int n = RETRY_COUNT;
        while (n-- > 0) {
            try {
                this.send(request, response, RETRY_TIMEOUT);
            }
            catch (IOException ioe) {
                if (LogStream.level > 1) {
                    ioe.printStackTrace(log);
                }
                throw new UnknownHostException(addr.toString());
            }
            if (!response.received || response.resultCode != 0) continue;
            int srcHashCode = request.addr.hashCode();
            for (int i = 0; i < response.addressArray.length; ++i) {
                response.addressArray[i].hostName.srcHashCode = srcHashCode;
            }
            return response.addressArray;
        }
        throw new UnknownHostException(addr.hostName.name);
    }
}

