/*
 * Decompiled with CFR 0.152.
 */
package tr.swing.editorpane;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.util.WindowUtils;
import org.openide.util.NbBundle;
import tr.swing.editorpane.URLDialogPanel;

final class URLDialog
extends JDialog {
    private int option;
    private JButton okButton;
    private JButton cancelButton;
    private URLDialogPanel urlPanel;
    private Component component;

    public URLDialog(Frame frame, Component component, String title) {
        super(frame, title, true);
        this.component = component;
        this.construct();
    }

    private void construct() {
        this.setDefaultCloseOperation(2);
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                URLDialog.this.cancel();
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = this.getRootPane();
        rootPane.registerKeyboardAction(cancelListener, stroke, 2);
        this.urlPanel = new URLDialogPanel();
        this.cancelButton = new JButton(NbBundle.getMessage(URLDialog.class, (String)"cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                URLDialog.this.cancel();
            }
        });
        this.okButton = new JButton(NbBundle.getMessage(URLDialog.class, (String)"ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                URLDialog.this.ok();
            }
        });
        JPanel buttons = new JPanel(new FlowLayout(2, 2, 2));
        buttons.setPreferredSize(new Dimension(0, 36));
        buttons.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 36));
        buttons.add(new JLabel("   "));
        buttons.add(this.cancelButton);
        buttons.add(this.okButton);
        this.add((Component)this.urlPanel, "Center");
        this.add((Component)buttons, "South");
        this.setLocationRelativeTo(this.component);
        this.pack();
        this.setLocation(WindowUtils.getPointForCentering((Window)this));
        this.urlPanel.initView();
    }

    private void ok() {
        this.option = 0;
        this.setVisible(false);
        this.dispose();
    }

    private void cancel() {
        this.option = 2;
        this.setVisible(false);
        this.dispose();
    }

    public String getURL() {
        return this.urlPanel == null ? "" : this.urlPanel.getURL();
    }

    public String getLinkText() {
        return this.urlPanel == null ? "" : this.urlPanel.getLinkText();
    }

    public int showDialog() {
        this.option = 2;
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
        return this.option;
    }
}

