/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.runtime.BasicLock;
import sun.jvm.hotspot.utilities.Assert;

public class MonitorInfo {
    private OopHandle owner;
    private BasicLock lock;
    private OopHandle ownerKlass;
    private boolean eliminated;
    private boolean ownerIsScalarReplaced;

    public MonitorInfo(OopHandle owner, BasicLock lock, boolean eliminated, boolean ownerIsScalarReplaced) {
        if (!ownerIsScalarReplaced) {
            this.owner = owner;
            this.ownerKlass = null;
        } else {
            Assert.that(eliminated, "monitor should be eliminated for scalar replaced object");
            this.owner = null;
            this.ownerKlass = owner;
        }
        this.eliminated = eliminated;
        this.ownerIsScalarReplaced = ownerIsScalarReplaced;
    }

    public OopHandle owner() {
        Assert.that(!this.ownerIsScalarReplaced, "should not be called for scalar replaced object");
        return this.owner;
    }

    public OopHandle ownerKlass() {
        Assert.that(this.ownerIsScalarReplaced, "should not be called for not scalar replaced object");
        return this.ownerKlass;
    }

    public BasicLock lock() {
        return this.lock;
    }

    public boolean eliminated() {
        return this.eliminated;
    }

    public boolean ownerIsScalarReplaced() {
        return this.ownerIsScalarReplaced;
    }
}

