/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.copyfiles;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.copyfiles.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryCopyFiles
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    public boolean copy_empty_folders;
    public boolean arg_from_previous;
    public boolean overwrite_files;
    public boolean include_subfolders;
    public boolean add_result_filesname;
    public boolean remove_source_files;
    public boolean destination_is_a_file;
    public boolean create_destination_folder;
    public String[] source_filefolder;
    public String[] destination_filefolder;
    public String[] wildcard;
    HashSet<String> list_files_remove = new HashSet();
    HashSet<String> list_add_result = new HashSet();
    int NbrFail = 0;

    public JobEntryCopyFiles(String n) {
        super(n, "");
        this.copy_empty_folders = true;
        this.arg_from_previous = false;
        this.source_filefolder = null;
        this.remove_source_files = false;
        this.destination_filefolder = null;
        this.wildcard = null;
        this.overwrite_files = false;
        this.include_subfolders = false;
        this.add_result_filesname = false;
        this.destination_is_a_file = false;
        this.create_destination_folder = false;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.COPY_FILES);
    }

    public JobEntryCopyFiles() {
        this("");
    }

    public JobEntryCopyFiles(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryCopyFiles je = (JobEntryCopyFiles)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"copy_empty_folders", (boolean)this.copy_empty_folders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.arg_from_previous));
        retval.append("      ").append(XMLHandler.addTagValue((String)"overwrite_files", (boolean)this.overwrite_files));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.include_subfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remove_source_files", (boolean)this.remove_source_files));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_result_filesname", (boolean)this.add_result_filesname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destination_is_a_file", (boolean)this.destination_is_a_file));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_destination_folder", (boolean)this.create_destination_folder));
        retval.append("      <fields>").append(Const.CR);
        if (this.source_filefolder != null) {
            for (int i = 0; i < this.source_filefolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"source_filefolder", (String)this.source_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"destination_filefolder", (String)this.destination_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.copy_empty_folders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"copy_empty_folders"));
            this.arg_from_previous = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.overwrite_files = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"overwrite_files"));
            this.include_subfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.remove_source_files = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"remove_source_files"));
            this.add_result_filesname = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_result_filesname"));
            this.destination_is_a_file = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"destination_is_a_file"));
            this.create_destination_folder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"create_destination_folder"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.source_filefolder = new String[nrFields];
            this.destination_filefolder = new String[nrFields];
            this.wildcard = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.source_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"source_filefolder");
                this.destination_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"destination_filefolder");
                this.wildcard[i] = XMLHandler.getTagValue((Node)fnode, (String)"wildcard");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobCopyFiles.Error.Exception.UnableLoadXML"), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.copy_empty_folders = rep.getJobEntryAttributeBoolean(id_jobentry, "copy_empty_folders");
            this.arg_from_previous = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.overwrite_files = rep.getJobEntryAttributeBoolean(id_jobentry, "overwrite_files");
            this.include_subfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            this.remove_source_files = rep.getJobEntryAttributeBoolean(id_jobentry, "remove_source_files");
            this.add_result_filesname = rep.getJobEntryAttributeBoolean(id_jobentry, "add_result_filesname");
            this.destination_is_a_file = rep.getJobEntryAttributeBoolean(id_jobentry, "destination_is_a_file");
            this.create_destination_folder = rep.getJobEntryAttributeBoolean(id_jobentry, "create_destination_folder");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "source_filefolder");
            this.source_filefolder = new String[argnr];
            this.destination_filefolder = new String[argnr];
            this.wildcard = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.source_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "source_filefolder");
                this.destination_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "destination_filefolder");
                this.wildcard[a] = rep.getJobEntryAttributeString(id_jobentry, a, "wildcard");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobCopyFiles.Error.Exception.UnableLoadRep") + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "copy_empty_folders", this.copy_empty_folders);
            rep.saveJobEntryAttribute(id_job, this.getID(), "arg_from_previous", this.arg_from_previous);
            rep.saveJobEntryAttribute(id_job, this.getID(), "overwrite_files", this.overwrite_files);
            rep.saveJobEntryAttribute(id_job, this.getID(), "include_subfolders", this.include_subfolders);
            rep.saveJobEntryAttribute(id_job, this.getID(), "remove_source_files", this.remove_source_files);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_result_filesname", this.add_result_filesname);
            rep.saveJobEntryAttribute(id_job, this.getID(), "destination_is_a_file", this.destination_is_a_file);
            rep.saveJobEntryAttribute(id_job, this.getID(), "create_destination_folder", this.create_destination_folder);
            if (this.source_filefolder != null) {
                for (int i = 0; i < this.source_filefolder.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "source_filefolder", this.source_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "destination_filefolder", this.destination_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "wildcard", this.wildcard[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobCopyFiles.Error.Exception.UnableSaveRep") + id_job, (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) throws KettleException {
        LogWriter log = LogWriter.getInstance();
        Result result = previousResult;
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        int NbrFail = 0;
        NbrFail = 0;
        if (log.isBasic()) {
            log.logBasic(this.toString(), Messages.getString("JobCopyFiles.Log.Starting"), new Object[0]);
        }
        String[] vsourcefilefolder = this.source_filefolder;
        String[] vdestinationfilefolder = this.destination_filefolder;
        String[] vwildcard = this.wildcard;
        result.setResult(false);
        result.setNrErrors(1L);
        if (this.arg_from_previous && log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobCopyFiles.Log.ArgFromPrevious.Found", (rows != null ? rows.size() : 0) + ""), new Object[0]);
        }
        if (this.arg_from_previous && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !parentJob.isStopped(); ++iteration) {
                resultRow = (RowMetaAndData)rows.get(iteration);
                String vsourcefilefolder_previous = resultRow.getString(0, null);
                String vdestinationfilefolder_previous = resultRow.getString(1, null);
                String vwildcard_previous = resultRow.getString(2, null);
                if (!Const.isEmpty((String)vsourcefilefolder_previous) && !Const.isEmpty((String)vdestinationfilefolder_previous)) {
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobCopyFiles.Log.ProcessingRow", vsourcefilefolder_previous, vdestinationfilefolder_previous, vwildcard_previous), new Object[0]);
                    }
                    if (this.ProcessFileFolder(vsourcefilefolder_previous, vdestinationfilefolder_previous, vwildcard_previous, parentJob, result)) continue;
                    ++NbrFail;
                    continue;
                }
                if (!log.isDetailed()) continue;
                log.logDetailed(this.toString(), Messages.getString("JobCopyFiles.Log.IgnoringRow", vsourcefilefolder[iteration], vdestinationfilefolder[iteration], vwildcard[iteration]), new Object[0]);
            }
        } else if (vsourcefilefolder != null && vdestinationfilefolder != null) {
            for (int i = 0; i < vsourcefilefolder.length && !parentJob.isStopped(); ++i) {
                if (!Const.isEmpty((String)vsourcefilefolder[i]) && !Const.isEmpty((String)vdestinationfilefolder[i])) {
                    if (log.isBasic()) {
                        log.logBasic(this.toString(), Messages.getString("JobCopyFiles.Log.ProcessingRow", vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i]), new Object[0]);
                    }
                    if (this.ProcessFileFolder(vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i], parentJob, result)) continue;
                    ++NbrFail;
                    continue;
                }
                if (!log.isDetailed()) continue;
                log.logDetailed(this.toString(), Messages.getString("JobCopyFiles.Log.IgnoringRow", vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i]), new Object[0]);
            }
        }
        if (NbrFail == 0) {
            result.setResult(true);
            result.setNrErrors(0L);
        } else {
            result.setNrErrors((long)NbrFail);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean ProcessFileFolder(String sourcefilefoldername, String destinationfilefoldername, String wildcard, Job parentJob, Result result) {
        boolean entrystatus;
        block36: {
            IOException ex222;
            String realSourceFilefoldername;
            FileObject destinationfilefolder;
            FileObject sourcefilefolder;
            LogWriter log;
            block34: {
                block33: {
                    log = LogWriter.getInstance();
                    entrystatus = false;
                    sourcefilefolder = null;
                    destinationfilefolder = null;
                    this.list_files_remove.clear();
                    this.list_add_result.clear();
                    realSourceFilefoldername = this.environmentSubstitute(sourcefilefoldername);
                    String realDestinationFilefoldername = this.environmentSubstitute(destinationfilefoldername);
                    String realWildcard = this.environmentSubstitute(wildcard);
                    System.gc();
                    sourcefilefolder = KettleVFS.getFileObject((String)realSourceFilefoldername);
                    destinationfilefolder = KettleVFS.getFileObject((String)realDestinationFilefoldername);
                    if (sourcefilefolder.exists()) {
                        if (this.CreateDestinationFolder(destinationfilefolder)) {
                            if (sourcefilefolder.getType().equals(FileType.FOLDER) && this.destination_is_a_file) {
                                log.logError(Messages.getString("JobCopyFiles.Log.Forbidden"), Messages.getString("JobCopyFiles.Log.CanNotCopyFolderToFile", realSourceFilefoldername, realDestinationFilefoldername), new Object[0]);
                                ++this.NbrFail;
                            } else {
                                if (destinationfilefolder.getType().equals(FileType.FOLDER) && sourcefilefolder.getType().equals(FileType.FILE)) {
                                    destinationfilefolder.copyFrom(sourcefilefolder.getParent(), (FileSelector)new TextOneFileSelector(sourcefilefolder.getParent().toString(), sourcefilefolder.getName().getBaseName(), destinationfilefolder.toString()));
                                    if (log.isDetailed()) {
                                        log.logDetailed(Messages.getString("JobCopyFiles.Log.FileCopiedInfos"), Messages.getString("JobCopyFiles.Log.FileCopied", sourcefilefolder.getName().toString(), destinationfilefolder.getName().toString()), new Object[0]);
                                    }
                                } else if (sourcefilefolder.getType().equals(FileType.FILE) && this.destination_is_a_file) {
                                    destinationfilefolder.copyFrom(sourcefilefolder, (FileSelector)new TextOneToOneFileSelector(destinationfilefolder));
                                } else {
                                    if (log.isDetailed()) {
                                        log.logDetailed("", "  ", new Object[0]);
                                        log.logDetailed(this.toString(), Messages.getString("JobCopyFiles.Log.FetchFolder", sourcefilefolder.toString()), new Object[0]);
                                    }
                                    destinationfilefolder.copyFrom(sourcefilefolder, (FileSelector)new TextFileSelector(sourcefilefolder.toString(), destinationfilefolder.toString(), realWildcard, parentJob));
                                }
                                if (this.remove_source_files && !this.list_files_remove.isEmpty()) {
                                    Iterator<String> iter = this.list_files_remove.iterator();
                                    while (iter.hasNext() && !parentJob.isStopped()) {
                                        String fileremoventry = iter.next();
                                        if (KettleVFS.getFileObject((String)fileremoventry).getType() != FileType.FILE) continue;
                                        boolean deletefile = KettleVFS.getFileObject((String)fileremoventry).delete();
                                        log.logBasic("", " ------ ", new Object[0]);
                                        if (!deletefile) {
                                            log.logError("      " + Messages.getString("JobCopyFiles.Log.Error"), Messages.getString("JobCopyFiles.Error.Exception.CanRemoveFileFolder", fileremoventry), new Object[0]);
                                            continue;
                                        }
                                        if (!log.isDetailed()) continue;
                                        log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FileFolderRemovedInfos"), Messages.getString("JobCopyFiles.Log.FileFolderRemoved", fileremoventry), new Object[0]);
                                    }
                                }
                                if (this.add_result_filesname && !this.list_add_result.isEmpty()) {
                                    for (String fileaddentry : this.list_add_result) {
                                        if (KettleVFS.getFileObject((String)fileaddentry).getType() != FileType.FILE) continue;
                                        ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)fileaddentry), parentJob.getJobname(), this.toString());
                                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                        if (!log.isDetailed()) continue;
                                        log.logDetailed("", " ------ ", new Object[0]);
                                        log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.ResultFilesName"), Messages.getString("JobCopyFiles.Log.FileAddedToResultFilesName", fileaddentry), new Object[0]);
                                    }
                                }
                            }
                            entrystatus = true;
                        } else {
                            log.logError(this.toString(), Messages.getString("JobCopyFiles.Error.DestinationFolderNotFound", realDestinationFilefoldername), new Object[0]);
                        }
                        break block33;
                    }
                    log.logError(this.toString(), Messages.getString("JobCopyFiles.Error.SourceFileNotExists", realSourceFilefoldername), new Object[0]);
                }
                Object var17_18 = null;
                if (sourcefilefolder == null) break block34;
                try {
                    sourcefilefolder.close();
                }
                catch (IOException ex222) {
                    // empty catch block
                }
            }
            if (destinationfilefolder != null) {
                try {
                    destinationfilefolder.close();
                }
                catch (IOException ex222) {}
            }
            break block36;
            {
                catch (IOException e) {
                    IOException ex222;
                    log.logError("Error", Messages.getString("JobCopyFiles.Error.Exception.CopyProcess", realSourceFilefoldername.toString(), destinationfilefolder.toString(), e.getMessage()), new Object[0]);
                    Object var17_19 = null;
                    if (sourcefilefolder != null) {
                        try {
                            sourcefilefolder.close();
                        }
                        catch (IOException ex222) {
                            // empty catch block
                        }
                    }
                    if (destinationfilefolder != null) {
                        try {
                            destinationfilefolder.close();
                        }
                        catch (IOException ex222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException ex222;
                Object var17_20 = null;
                if (sourcefilefolder != null) {
                    try {
                        sourcefilefolder.close();
                    }
                    catch (IOException ex222) {
                        // empty catch block
                    }
                }
                if (destinationfilefolder != null) {
                    try {
                        destinationfilefolder.close();
                    }
                    catch (IOException ex222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return entrystatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean CreateDestinationFolder(FileObject filefolder) {
        FileObject folder;
        LogWriter log;
        block13: {
            log = LogWriter.getInstance();
            folder = null;
            folder = this.destination_is_a_file ? filefolder.getParent() : filefolder;
            if (folder.exists()) break block13;
            if (this.create_destination_folder) {
                if (log.isDetailed()) {
                    log.logDetailed("Folder", "Folder  " + folder.getName() + " does not exist !", new Object[0]);
                }
                folder.createFolder();
                if (log.isDetailed()) {
                    log.logDetailed("Folder", "Folder parent was created.", new Object[0]);
                }
                break block13;
            }
            log.logError("Folder", "Folder  " + folder.getName() + " does not exist !", new Object[0]);
            boolean bl = false;
            Object var6_7 = null;
            if (folder == null) return bl;
            try {
                folder.close();
                return bl;
            }
            catch (Exception ex) {
                // empty catch block
            }
            return bl;
        }
        boolean bl = true;
        Object var6_8 = null;
        if (folder == null) return bl;
        try {
            folder.close();
            return bl;
        }
        catch (Exception ex) {
            // empty catch block
        }
        return bl;
        catch (Exception e) {
            try {
                log.logError(this.toString(), "Couldn't created parent folder " + folder.getName(), new Object[0]);
                Object var6_9 = null;
                if (folder == null) return false;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (folder == null) throw throwable;
                try {
                    folder.close();
                    throw throwable;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                folder.close();
                return false;
            }
            catch (Exception ex) {}
            return false;
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setCopyEmptyFolders(boolean copy_empty_foldersin) {
        this.copy_empty_folders = copy_empty_foldersin;
    }

    public void setoverwrite_files(boolean overwrite_filesin) {
        this.overwrite_files = overwrite_filesin;
    }

    public void setIncludeSubfolders(boolean include_subfoldersin) {
        this.include_subfolders = include_subfoldersin;
    }

    public void setAddresultfilesname(boolean add_result_filesnamein) {
        this.add_result_filesname = add_result_filesnamein;
    }

    public void setArgFromPrevious(boolean argfrompreviousin) {
        this.arg_from_previous = argfrompreviousin;
    }

    public void setRemoveSourceFiles(boolean remove_source_filesin) {
        this.remove_source_files = remove_source_filesin;
    }

    public void setDestinationIsAFile(boolean destination_is_a_file) {
        this.destination_is_a_file = destination_is_a_file;
    }

    public void setCreateDestinationFolder(boolean create_destination_folder) {
        this.create_destination_folder = create_destination_folder;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.source_filefolder.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    static /* synthetic */ boolean access$000(JobEntryCopyFiles x0, String x1, String x2) {
        return x0.GetFileWildcard(x1, x2);
    }

    private class TextOneFileSelector
    implements FileSelector {
        LogWriter log = LogWriter.getInstance();
        String filename = null;
        String foldername = null;
        String destfolder = null;

        public TextOneFileSelector(String sourcefolderin, String sourcefilenamein, String destfolderin) {
            if (!Const.isEmpty((String)sourcefilenamein)) {
                this.filename = sourcefilenamein;
            }
            if (!Const.isEmpty((String)sourcefolderin)) {
                this.foldername = sourcefolderin;
            }
            if (!Const.isEmpty((String)destfolderin)) {
                this.destfolder = destfolderin;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean resultat = false;
            String fil_name = null;
            try {
                if (info.getFile().getType() == FileType.FILE) {
                    if (info.getFile().getName().getBaseName().equals(this.filename) && info.getFile().getParent().toString().equals(this.foldername)) {
                        fil_name = this.destfolder + Const.FILE_SEPARATOR + this.filename;
                        if (KettleVFS.getFileObject((String)fil_name).exists()) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FileExistsInfos"), Messages.getString("JobCopyFiles.Log.FileExists", fil_name), new Object[0]);
                            }
                            if (JobEntryCopyFiles.this.overwrite_files) {
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FileOverwriteInfos"), Messages.getString("JobCopyFiles.Log.FileOverwrite", info.getFile().toString(), fil_name), new Object[0]);
                                }
                                resultat = true;
                            }
                        } else {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FileCopiedInfos"), Messages.getString("JobCopyFiles.Log.FileCopied", info.getFile().toString(), fil_name), new Object[0]);
                            }
                            resultat = true;
                        }
                    }
                    if (resultat && JobEntryCopyFiles.this.remove_source_files) {
                        JobEntryCopyFiles.this.list_files_remove.add(info.getFile().toString());
                    }
                    if (resultat && JobEntryCopyFiles.this.add_result_filesname) {
                        JobEntryCopyFiles.this.list_add_result.add(KettleVFS.getFileObject(fil_name).toString());
                    }
                }
            }
            catch (Exception e) {
                this.log.logError(Messages.getString("JobCopyFiles.Error.Exception.CopyProcessError"), Messages.getString("JobCopyFiles.Error.Exception.CopyProcess", info.getFile().toString(), fil_name, e.getMessage()), new Object[0]);
                resultat = false;
            }
            return resultat;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }

    private class TextFileSelector
    implements FileSelector {
        LogWriter log = LogWriter.getInstance();
        String file_wildcard = null;
        String source_folder = null;
        String destination_folder = null;
        Job parentjob;

        public TextFileSelector(String sourcefolderin, String destinationfolderin, String filewildcard, Job parentJob) {
            if (!Const.isEmpty((String)sourcefolderin)) {
                this.source_folder = sourcefolderin;
            }
            if (!Const.isEmpty((String)destinationfolderin)) {
                this.destination_folder = destinationfolderin;
            }
            if (!Const.isEmpty((String)filewildcard)) {
                this.file_wildcard = filewildcard;
            }
            this.parentjob = parentJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public boolean includeFile(FileSelectInfo info) {
            block44: {
                returncode = false;
                file_name = null;
                try {
                    block43: {
                        if (info.getFile().toString().equals(this.source_folder) || this.parentjob.isStopped()) break block43;
                        short_filename_from_basefolder = info.getFile().getName().toString().substring(this.source_folder.length(), info.getFile().getName().toString().length());
                        short_filename = info.getFile().getName().getBaseName();
                        file_name = KettleVFS.getFileObject((String)(this.destination_folder + Const.FILE_SEPARATOR + short_filename_from_basefolder));
                        if (!info.getFile().getParent().equals(info.getBaseFolder())) {
                            if (JobEntryCopyFiles.this.include_subfolders) {
                                if (info.getFile().getType() == FileType.FOLDER) {
                                    if (JobEntryCopyFiles.this.include_subfolders && JobEntryCopyFiles.this.copy_empty_folders && Const.isEmpty((String)this.file_wildcard)) {
                                        if (!file_name.exists()) {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed("", " ------ ", new Object[0]);
                                                this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FolderCopiedInfos"), Messages.getString("JobCopyFiles.Log.FolderCopied", info.getFile().toString(), file_name.toString()), new Object[0]);
                                            }
                                            returncode = true;
                                        } else {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed("", " ------ ", new Object[0]);
                                                this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FolderExistsInfos"), Messages.getString("JobCopyFiles.Log.FolderExists", file_name.toString()), new Object[0]);
                                            }
                                            if (JobEntryCopyFiles.this.overwrite_files) {
                                                if (this.log.isDetailed()) {
                                                    this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FolderOverwriteInfos"), Messages.getString("JobCopyFiles.Log.FolderOverwrite", info.getFile().toString(), file_name.toString()), new Object[0]);
                                                }
                                                returncode = true;
                                            }
                                        }
                                    }
                                } else if (JobEntryCopyFiles.access$000(JobEntryCopyFiles.this, short_filename, this.file_wildcard)) {
                                    if (!file_name.exists()) {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("", " ------ ", new Object[0]);
                                            this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FileCopiedInfos"), Messages.getString("JobCopyFiles.Log.FileCopied", info.getFile().toString(), file_name.toString()), new Object[0]);
                                        }
                                        returncode = true;
                                    } else {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("", " ------ ", new Object[0]);
                                            this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FileExistsInfos"), Messages.getString("JobCopyFiles.Log.FileExists", file_name.toString()), new Object[0]);
                                        }
                                        if (JobEntryCopyFiles.this.overwrite_files) {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed("       " + Messages.getString("JobCopyFiles.Log.FileExistsInfos"), Messages.getString("JobCopyFiles.Log.FileExists", info.getFile().toString(), file_name.toString()), new Object[0]);
                                            }
                                            returncode = true;
                                            ** GOTO lbl74
                                        }
                                    }
                                }
                            }
                            break block43;
                        }
                        if (info.getFile().getType() == FileType.FOLDER) {
                            if (JobEntryCopyFiles.this.include_subfolders && JobEntryCopyFiles.this.copy_empty_folders && Const.isEmpty((String)this.file_wildcard)) {
                                if (!file_name.exists()) {
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed("", " ------ ", new Object[0]);
                                        this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FolderCopiedInfos"), Messages.getString("JobCopyFiles.Log.FolderCopied", info.getFile().toString(), file_name.toString()), new Object[0]);
                                    }
                                    returncode = true;
                                } else {
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed("", " ------ ", new Object[0]);
                                        this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FolderExistsInfos"), Messages.getString("JobCopyFiles.Log.FolderExists", file_name.toString()), new Object[0]);
                                    }
                                    if (JobEntryCopyFiles.this.overwrite_files) {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FolderOverwriteInfos"), Messages.getString("JobCopyFiles.Log.FolderOverwrite", info.getFile().toString(), file_name.toString()), new Object[0]);
                                        }
                                        returncode = true;
                                    }
                                }
                            }
                            break block43;
                        }
                        if (!JobEntryCopyFiles.access$000(JobEntryCopyFiles.this, short_filename, this.file_wildcard)) break block43;
                        if (!file_name.exists()) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("", " ------ ", new Object[0]);
                                this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FileCopiedInfos"), Messages.getString("JobCopyFiles.Log.FileCopied", info.getFile().toString(), file_name.toString()), new Object[0]);
                            }
                            returncode = true;
                            break block43;
                        }
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("", " ------ ", new Object[0]);
                            this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FileExistsInfos"), Messages.getString("JobCopyFiles.Log.FileExists", file_name.toString()), new Object[0]);
                        }
                        if (!JobEntryCopyFiles.this.overwrite_files) break block43;
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FileExistsInfos"), Messages.getString("JobCopyFiles.Log.FileExists", info.getFile().toString(), file_name.toString()), new Object[0]);
                        }
                        returncode = true;
                    }
                    var7_7 = null;
                    ** if (file_name == null) goto lbl-1000
                }
                catch (Throwable var6_13) {
                    var7_9 = null;
                    if (file_name != null) {
                        try {
                            file_name.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    throw var6_13;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        file_name.close();
                    }
                    catch (IOException ex) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block44;
                    catch (Exception e) {
                        this.log.logError(Messages.getString("JobCopyFiles.Error.Exception.CopyProcessError"), Messages.getString("JobCopyFiles.Error.Exception.CopyProcess", info.getFile().toString(), file_name.toString(), e.getMessage()), new Object[0]);
                        returncode = false;
                        var7_8 = null;
                        if (file_name != null) {
                            try {
                                file_name.close();
                            }
                            catch (IOException ex) {}
                        }
                    }
                }
            }
            if (returncode && JobEntryCopyFiles.this.remove_source_files) {
                JobEntryCopyFiles.this.list_files_remove.add(info.getFile().toString());
            }
            if (returncode && JobEntryCopyFiles.this.add_result_filesname) {
                JobEntryCopyFiles.this.list_add_result.add(file_name.toString());
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }

    private class TextOneToOneFileSelector
    implements FileSelector {
        LogWriter log = LogWriter.getInstance();
        FileObject destfile = null;

        public TextOneToOneFileSelector(FileObject destinationfile) {
            if (destinationfile != null) {
                this.destfile = destinationfile;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean resultat = false;
            String fil_name = null;
            try {
                if (this.destfile.exists()) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FileExistsInfos"), Messages.getString("JobCopyFiles.Log.FileExists", this.destfile.toString()), new Object[0]);
                    }
                    if (JobEntryCopyFiles.this.overwrite_files) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FileOverwriteInfos"), Messages.getString("JobCopyFiles.Log.FileOverwrite", this.destfile.toString()), new Object[0]);
                        }
                        resultat = true;
                    }
                } else {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("      " + Messages.getString("JobCopyFiles.Log.FileCopiedInfos"), Messages.getString("JobCopyFiles.Log.FileCopied", info.getFile().toString(), this.destfile.toString()), new Object[0]);
                    }
                    resultat = true;
                }
                if (resultat && JobEntryCopyFiles.this.remove_source_files) {
                    JobEntryCopyFiles.this.list_files_remove.add(info.getFile().toString());
                }
                if (resultat && JobEntryCopyFiles.this.add_result_filesname) {
                    JobEntryCopyFiles.this.list_add_result.add(this.destfile.toString());
                }
            }
            catch (Exception e) {
                this.log.logError(this.toString(), Messages.getString("JobCopyFiles.Error.Exception.CopyProcess", info.getFile().toString(), fil_name, e.getMessage()), new Object[0]);
            }
            return resultat;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return false;
        }
    }
}

