/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.www.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WebResult {
    public static final String XML_TAG = "webresult";
    public static final String STRING_OK = "OK";
    public static final String STRING_ERROR = "ERROR";
    public static final WebResult OK = new WebResult("OK");
    private String result;
    private String message;

    public WebResult(String result) {
        this.result = result;
    }

    public WebResult(String result, String message) {
        this.result = result;
        this.message = message;
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<webresult>").append(Const.CR);
        xml.append("  ").append(XMLHandler.addTagValue((String)"result", (String)this.result));
        xml.append("  ").append(XMLHandler.addTagValue((String)"message", (String)this.message));
        xml.append("</webresult>").append(Const.CR);
        return xml.toString();
    }

    public String toString() {
        return this.getXML();
    }

    public WebResult(Node webResultNode) {
        this.result = XMLHandler.getTagValue((Node)webResultNode, (String)"result");
        this.message = XMLHandler.getTagValue((Node)webResultNode, (String)"message");
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static WebResult fromXMLString(String xml) throws KettleXMLException {
        try {
            Document doc = XMLHandler.loadXMLString((String)xml);
            Node node = XMLHandler.getSubNode((Node)doc, (String)XML_TAG);
            return new WebResult(node);
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("WebResult.Error.UnableCreateResult"), (Throwable)e);
        }
    }
}

