/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.verifier;

import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.gradle.api.internal.artifacts.verification.verifier.AbstractVerificationFailure;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.security.internal.PGPUtils;
import org.gradle.security.internal.PublicKeyResultBuilder;
import org.gradle.security.internal.PublicKeyService;

public class SignatureVerificationFailure
extends AbstractVerificationFailure {
    private final Map<String, SignatureError> errors;
    private final PublicKeyService keyService;
    private final File signatureFile;

    public SignatureVerificationFailure(File affectedFile, File signatureFile, Map<String, SignatureError> errors, PublicKeyService keyService) {
        super(affectedFile);
        this.errors = errors;
        this.keyService = keyService;
        this.signatureFile = signatureFile;
    }

    @Override
    public File getSignatureFile() {
        return this.signatureFile;
    }

    public Map<String, SignatureError> getErrors() {
        return this.errors;
    }

    @Override
    public void explainTo(TreeFormatter formatter) {
        if (this.errors.size() == 1) {
            Map.Entry<String, SignatureError> entry2 = this.errors.entrySet().iterator().next();
            formatter.append((CharSequence)this.toMessage(entry2.getKey(), entry2.getValue()));
            return;
        }
        formatter.append((CharSequence)"Multiple signature verification errors found");
        formatter.startChildren();
        this.errors.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> formatter.node(this.toMessage((String)entry.getKey(), (SignatureError)entry.getValue())));
        formatter.endChildren();
    }

    private String toMessage(String key, SignatureError value) {
        StringBuilder sb = new StringBuilder();
        this.appendError(key, value, sb);
        return sb.toString();
    }

    private void appendError(String keyId, SignatureError error, StringBuilder sb) {
        sb.append("Artifact was signed with key '").append(keyId).append("' ");
        PGPPublicKey publicKey = error.publicKey;
        switch (error.kind) {
            case PASSED_NOT_TRUSTED: {
                this.appendKeyDetails(sb, publicKey);
                sb.append("and passed verification but the key isn't in your trusted keys list.");
                break;
            }
            case FAILED: {
                this.appendKeyDetails(sb, publicKey);
                sb.append("but signature didn't match");
                break;
            }
            case MISSING_KEY: {
                sb.append("but it wasn't found in any key server so it couldn't be verified");
            }
        }
    }

    public void appendKeyDetails(final StringBuilder sb, final PGPPublicKey key) {
        this.keyService.findByFingerprint(key.getFingerprint(), new PublicKeyResultBuilder(){

            public void keyRing(PGPPublicKeyRing keyring) {
                TreeSet userIds = new TreeSet();
                SignatureVerificationFailure.this.collectUserIds(userIds, key);
                keyring.getPublicKeys().forEachRemaining(userkey -> SignatureVerificationFailure.this.collectUserIds(userIds, userkey));
                if (!userIds.isEmpty()) {
                    sb.append("(");
                }
                sb.append(String.join((CharSequence)", ", userIds));
                if (!userIds.isEmpty()) {
                    sb.append(") ");
                }
            }

            public void publicKey(PGPPublicKey publicKey) {
            }
        });
    }

    private void collectUserIds(Set<String> userIds, PGPPublicKey userkey) {
        userIds.addAll(PGPUtils.getUserIDs((PGPPublicKey)userkey));
    }

    public static class SignatureError {
        private final PGPPublicKey publicKey;
        private final FailureKind kind;

        public SignatureError(@Nullable PGPPublicKey key, FailureKind kind) {
            this.publicKey = key;
            this.kind = kind;
        }

        public FailureKind getKind() {
            return this.kind;
        }

        public PGPPublicKey getPublicKey() {
            return this.publicKey;
        }
    }

    public static enum FailureKind {
        PASSED_NOT_TRUSTED,
        FAILED,
        IGNORED_KEY,
        MISSING_KEY;

    }
}

