/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.xml;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.cybergarage.xml.Attribute;
import org.cybergarage.xml.AttributeList;
import org.cybergarage.xml.NodeList;
import org.cybergarage.xml.XML;

public class Node {
    private Node parentNode = null;
    private String name = new String();
    private String value = new String();
    private AttributeList attrList = new AttributeList();
    private NodeList nodeList = new NodeList();
    private Object userData = null;

    public Node() {
        this.setUserData(null);
        this.setParentNode(null);
    }

    public Node(String name) {
        this();
        this.setName(name);
    }

    public Node(String ns, String name) {
        this();
        this.setName(ns, name);
    }

    public Node(Node otherNode) {
        this();
        this.set(otherNode);
    }

    public void setParentNode(Node node) {
        this.parentNode = node;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public Node getRootNode() {
        Node rootNode = null;
        Node parentNode = this.getParentNode();
        while (parentNode != null) {
            rootNode = parentNode;
            parentNode = rootNode.getParentNode();
        }
        return rootNode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setName(String ns, String name) {
        this.name = ns + ":" + name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isName(String value) {
        return this.name.equals(value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(int value) {
        this.setValue(Integer.toString(value));
    }

    public void addValue(String value) {
        if (this.value == null) {
            this.value = value;
            return;
        }
        if (value != null) {
            this.value = this.value + value;
        }
    }

    public String getValue() {
        return this.value;
    }

    public int getNAttributes() {
        return this.attrList.size();
    }

    public Attribute getAttribute(int index) {
        return this.attrList.getAttribute(index);
    }

    public Attribute getAttribute(String name) {
        return this.attrList.getAttribute(name);
    }

    public void addAttribute(Attribute attr) {
        this.attrList.add(attr);
    }

    public void insertAttributeAt(Attribute attr, int index) {
        this.attrList.insertElementAt(attr, index);
    }

    public void addAttribute(String name, String value) {
        Attribute attr = new Attribute(name, value);
        this.addAttribute(attr);
    }

    public boolean removeAttribute(Attribute attr) {
        return this.attrList.remove(attr);
    }

    public boolean removeAttribute(String name) {
        return this.removeAttribute(this.getAttribute(name));
    }

    public void removeAllAttributes() {
        this.attrList.clear();
    }

    public boolean hasAttributes() {
        return 0 < this.getNAttributes();
    }

    public void setAttribute(String name, String value) {
        Attribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setValue(value);
            return;
        }
        attr = new Attribute(name, value);
        this.addAttribute(attr);
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, Integer.toString(value));
    }

    public String getAttributeValue(String name) {
        Attribute attr = this.getAttribute(name);
        if (attr != null) {
            return attr.getValue();
        }
        return "";
    }

    public int getAttributeIntegerValue(String name) {
        String val = this.getAttributeValue(name);
        try {
            return Integer.parseInt(val);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setNameSpace(String ns, String value) {
        this.setAttribute("xmlns:" + ns, value);
    }

    public boolean set(Node otherNode) {
        if (otherNode == null) {
            return false;
        }
        this.setName(otherNode.getName());
        this.setValue(otherNode.getValue());
        this.removeAllAttributes();
        int nOtherAttributes = otherNode.getNAttributes();
        for (int n = 0; n < nOtherAttributes; ++n) {
            Attribute otherAttr = otherNode.getAttribute(n);
            Attribute thisAttr = new Attribute(otherAttr);
            this.addAttribute(thisAttr);
        }
        this.removeAllNodes();
        int nOtherChildNodes = otherNode.getNNodes();
        for (int n = 0; n < nOtherChildNodes; ++n) {
            Node otherChildNode = otherNode.getNode(n);
            Node thisChildNode = new Node();
            thisChildNode.set(otherChildNode);
            this.addNode(thisChildNode);
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node otherNode = (Node)o;
        String thisNodeString = this.toString();
        String otherNodeString = otherNode.toString();
        return thisNodeString.equals(otherNodeString);
    }

    public int getNNodes() {
        return this.nodeList.size();
    }

    public Node getNode(int index) {
        return this.nodeList.getNode(index);
    }

    public Node getNode(String name) {
        return this.nodeList.getNode(name);
    }

    public Node getNodeEndsWith(String name) {
        return this.nodeList.getEndsWith(name);
    }

    public void addNode(Node node) {
        node.setParentNode(this);
        this.nodeList.add(node);
    }

    public void insertNode(Node node, int index) {
        node.setParentNode(this);
        this.nodeList.insertElementAt(node, index);
    }

    public int getIndex(String name) {
        int index = -1;
        Iterator i = this.nodeList.iterator();
        while (i.hasNext()) {
            ++index;
            Node n = (Node)i.next();
            if (!n.getName().equals(name)) continue;
            return index;
        }
        return index;
    }

    public boolean removeNode(Node node) {
        node.setParentNode(null);
        return this.nodeList.remove(node);
    }

    public boolean removeNode(String name) {
        return this.nodeList.remove(this.getNode(name));
    }

    public void removeAllNodes() {
        this.nodeList.clear();
    }

    public boolean hasNodes() {
        return 0 < this.getNNodes();
    }

    public boolean hasNode(String name) {
        Node node = this.getNode(name);
        return node != null;
    }

    public void setNode(String name) {
        if (this.hasNode(name)) {
            return;
        }
        Node node = new Node(name);
        this.addNode(node);
    }

    public void setNode(String name, String value) {
        Node node = this.getNode(name);
        if (node == null) {
            node = new Node(name);
            this.addNode(node);
        }
        node.setValue(value);
    }

    public String getNodeValue(String name) {
        Node node = this.getNode(name);
        if (node != null) {
            return node.getValue();
        }
        return "";
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public Object getUserData() {
        return this.userData;
    }

    public String getIndentLevelString(int nIndentLevel) {
        return this.getIndentLevelString(nIndentLevel, "   ");
    }

    public String getIndentLevelString(int nIndentLevel, String space) {
        StringBuffer indentString = new StringBuffer(nIndentLevel * space.length());
        for (int n = 0; n < nIndentLevel; ++n) {
            indentString.append(space);
        }
        return indentString.toString();
    }

    public void outputAttributes(PrintWriter ps) {
        int nAttributes = this.getNAttributes();
        for (int n = 0; n < nAttributes; ++n) {
            Attribute attr = this.getAttribute(n);
            ps.print(" " + attr.getName() + "=\"" + XML.escapeXMLChars(attr.getValue()) + "\"");
        }
    }

    public void output(PrintWriter ps, int indentLevel, boolean hasChildNode) {
        String indentString = this.getIndentLevelString(indentLevel);
        String name = this.getName();
        String value = this.getValue();
        if (!this.hasNodes() || !hasChildNode) {
            ps.print(indentString + "<" + name);
            this.outputAttributes(ps);
            if (value == null || value.length() == 0) {
                ps.println("></" + name + ">");
            } else {
                ps.println(">" + XML.escapeXMLChars(value) + "</" + name + ">");
            }
            return;
        }
        ps.print(indentString + "<" + name);
        this.outputAttributes(ps);
        ps.println(">");
        int nChildNodes = this.getNNodes();
        for (int n = 0; n < nChildNodes; ++n) {
            Node cnode = this.getNode(n);
            cnode.output(ps, indentLevel + 1, true);
        }
        ps.println(indentString + "</" + name + ">");
    }

    public String toString(String enc, boolean hasChildNode) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        PrintWriter pr = new PrintWriter(byteOut);
        this.output(pr, 0, hasChildNode);
        pr.flush();
        try {
            if (enc != null && 0 < enc.length()) {
                return byteOut.toString(enc);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byteOut.toString();
    }

    public String toString() {
        return this.toString("utf-8", true);
    }

    public String toXMLString(boolean hasChildNode) {
        String xmlStr = this.toString();
        xmlStr = xmlStr.replaceAll("<", "&lt;");
        xmlStr = xmlStr.replaceAll(">", "&gt;");
        xmlStr = xmlStr.replaceAll("&", "&amp;");
        xmlStr = xmlStr.replaceAll("\"", "&quot;");
        xmlStr = xmlStr.replaceAll("'", "&apos;");
        return xmlStr;
    }

    public String toXMLString() {
        return this.toXMLString(true);
    }

    public void print(boolean hasChildNode) {
        PrintWriter pr = new PrintWriter(System.out);
        this.output(pr, 0, hasChildNode);
        pr.flush();
    }

    public void print() {
        this.print(true);
    }
}

