/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.query.sqm.sql.internal.SqmParameterInterpretation;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.TrimSpecification;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class TrimFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final Dialect dialect;
    private final SqlAstNodeRenderingMode argumentRenderingMode;

    public TrimFunction(Dialect dialect, TypeConfiguration typeConfiguration) {
        this(dialect, typeConfiguration, SqlAstNodeRenderingMode.DEFAULT);
    }

    public TrimFunction(Dialect dialect, TypeConfiguration typeConfiguration, SqlAstNodeRenderingMode argumentRenderingMode) {
        super("trim", new ArgumentTypesValidator(StandardArgumentsValidators.exactly(3), FunctionParameterType.TRIM_SPEC, FunctionParameterType.STRING, FunctionParameterType.STRING), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.TRIM_SPEC, FunctionParameterType.STRING, FunctionParameterType.STRING));
        this.dialect = dialect;
        this.argumentRenderingMode = argumentRenderingMode;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        TrimSpec specification = ((TrimSpecification)sqlAstArguments.get(0)).getSpecification();
        SqlAstNode trimCharacter = sqlAstArguments.get(1);
        boolean isWhitespace = TrimFunction.isWhitespace(trimCharacter);
        Expression sourceExpr = (Expression)sqlAstArguments.get(2);
        String trim = this.dialect.trimPattern(specification, isWhitespace);
        List<SqlAstNode> args = isWhitespace ? List.of(sourceExpr) : List.of(sourceExpr, trimCharacter);
        new PatternRenderer(trim, this.argumentRenderingMode).render(sqlAppender, args, walker);
    }

    private static boolean isWhitespace(SqlAstNode trimCharacter) {
        if (trimCharacter instanceof Literal) {
            Literal literal = (Literal)trimCharacter;
            char literalValue = ((Character)literal.getLiteralValue()).charValue();
            return literalValue == ' ';
        }
        if (trimCharacter instanceof SqmParameterInterpretation) {
            SqmParameterInterpretation parameterInterpretation = (SqmParameterInterpretation)trimCharacter;
            JdbcType jdbcType = parameterInterpretation.getExpressionType().getSingleJdbcMapping().getJdbcType();
            if (!SqlTypes.isCharacterType(jdbcType.getJdbcTypeCode())) {
                throw new FunctionArgumentException(String.format("Expected parameter used as trim character to be character typed, instead was [%s]", jdbcType.getFriendlyName()));
            }
            return false;
        }
        throw new IllegalArgumentException("Trim character must be a literal string or parameter");
    }

    @Override
    public String getArgumentListSignature() {
        return "([[{leading|trailing|both} ][STRING arg0 ]from] STRING arg1)";
    }
}

