/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.entities;

import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.models.cache.infinispan.authorization.entities.InResourceServer;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;

public class CachedPermissionTicket
extends AbstractRevisioned
implements InResourceServer {
    private final String requester;
    private String owner;
    private String resourceServerId;
    private String resourceId;
    private String scopeId;
    private boolean granted;
    private Long createdTimestamp;
    private Long grantedTimestamp;
    private String policy;

    public CachedPermissionTicket(Long revision, PermissionTicket permissionTicket) {
        super(revision, permissionTicket.getId());
        this.owner = permissionTicket.getOwner();
        this.requester = permissionTicket.getRequester();
        this.resourceServerId = permissionTicket.getResourceServer().getId();
        this.resourceId = permissionTicket.getResource().getId();
        if (permissionTicket.getScope() != null) {
            this.scopeId = permissionTicket.getScope().getId();
        }
        this.granted = permissionTicket.isGranted();
        this.createdTimestamp = permissionTicket.getCreatedTimestamp();
        this.grantedTimestamp = permissionTicket.getGrantedTimestamp();
        Policy policy = permissionTicket.getPolicy();
        if (policy != null) {
            this.policy = policy.getId();
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public String getRequester() {
        return this.requester;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public boolean isGranted() {
        return this.granted;
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public Long getGrantedTimestamp() {
        return this.grantedTimestamp;
    }

    @Override
    public String getResourceServerId() {
        return this.resourceServerId;
    }

    public String getPolicy() {
        return this.policy;
    }
}

