/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AdminClientRegisterContext;
import org.keycloak.services.clientpolicy.context.AdminClientUpdateContext;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.context.DynamicClientRegisterContext;
import org.keycloak.services.clientpolicy.context.DynamicClientUpdateContext;
import org.keycloak.services.clientpolicy.context.PreAuthorizationRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.SecureRedirectUrisEnforcerExecutorFactory;

public class SecureRedirectUrisEnforcerExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(SecureRedirectUrisEnforcerExecutor.class);
    private final KeycloakSession session;
    private Configuration configuration;
    public static final String ERR_GENERAL = "Invalid Redirect Uri: invalid uri";
    public static final String ERR_LOOPBACK = "Invalid Redirect Uri: invalid loopback address";
    public static final String ERR_PRIVATESCHEME = "Invalid Redirect Uri: invalid private use scheme";
    public static final String ERR_NORMALURI = "Invalid Redirect Uri: invalid uri";

    public SecureRedirectUrisEnforcerExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "secure-redirect-uris-enforcer";
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: {
                if (!(context instanceof AdminClientRegisterContext) && !(context instanceof DynamicClientRegisterContext)) {
                    throw SecureRedirectUrisEnforcerExecutor.invalidRedirectUri("Invalid Redirect Uri: invalid uri");
                }
                this.verifyRedirectUris((ClientCRUDContext)context);
                return;
            }
            case UPDATE: {
                if (!(context instanceof AdminClientUpdateContext) && !(context instanceof DynamicClientUpdateContext)) {
                    throw SecureRedirectUrisEnforcerExecutor.invalidRedirectUri("Invalid Redirect Uri: invalid uri");
                }
                this.verifyRedirectUris((ClientCRUDContext)context);
                return;
            }
            case PRE_AUTHORIZATION_REQUEST: {
                String redirectUriParam = (String)((PreAuthorizationRequestContext)context).getRequestParameters().getFirst((Object)"redirect_uri");
                String clientId = ((PreAuthorizationRequestContext)context).getClientId();
                ClientModel client = this.session.getContext().getRealm().getClientByClientId(clientId);
                if (client == null) {
                    throw SecureRedirectUrisEnforcerExecutor.invalidRedirectUri("Invalid parameter: clientId");
                }
                if (SecureRedirectUrisEnforcerExecutor.isAuthFlowWithRedirectEnabled(client)) {
                    this.verifyRedirectUri(redirectUriParam, true);
                }
                return;
            }
        }
    }

    private void verifyRedirectUris(ClientCRUDContext context) throws ClientPolicyException {
        ClientRepresentation client = context.getProposedClientRepresentation();
        if (SecureRedirectUrisEnforcerExecutor.isAuthFlowWithRedirectEnabled(client)) {
            List redirectUris = client.getRedirectUris();
            if (redirectUris == null || redirectUris.isEmpty()) {
                throw SecureRedirectUrisEnforcerExecutor.invalidRedirectUri("Invalid Redirect Uri: invalid uri");
            }
            this.verifyRedirectUris(client.getRootUrl(), redirectUris);
            this.verifyPostLogoutRedirectUriUpdate(client);
        }
    }

    private static boolean isAuthFlowWithRedirectEnabled(ClientModel client) {
        return client.isStandardFlowEnabled() || client.isImplicitFlowEnabled();
    }

    private static boolean isAuthFlowWithRedirectEnabled(ClientRepresentation client) {
        return client.isStandardFlowEnabled() == null || client.isStandardFlowEnabled() == Boolean.TRUE || client.isImplicitFlowEnabled() == Boolean.TRUE;
    }

    private void verifyPostLogoutRedirectUriUpdate(ClientRepresentation client) throws ClientPolicyException {
        List<String> postLogoutRedirectUris = OIDCAdvancedConfigWrapper.fromClientRepresentation(client).getPostLogoutRedirectUris();
        if (postLogoutRedirectUris == null || postLogoutRedirectUris.isEmpty()) {
            return;
        }
        logger.tracef("Verifying post-logout redirect uris. Target client: %s, Effective post-logout uris: %s", (Object)client.getClientId(), postLogoutRedirectUris);
        this.verifyRedirectUris(client.getRootUrl(), postLogoutRedirectUris);
    }

    void verifyRedirectUris(String rootUri, List<String> redirectUris) throws ClientPolicyException {
        if (this.configuration.isAllowOpenRedirect()) {
            return;
        }
        for (String uri : RedirectUtils.resolveValidRedirects(this.session, rootUri, new HashSet<String>(redirectUris))) {
            this.verifyRedirectUri(uri, false);
        }
    }

    void verifyRedirectUri(String redirectUri, boolean isRedirectUriParam) throws ClientPolicyException {
        UriValidation validation;
        try {
            validation = new UriValidation(redirectUri, isRedirectUriParam, this.configuration);
        }
        catch (URISyntaxException e) {
            logger.debugv("URISyntaxException - input = {0}, errMessage = {1], errReason = {2}, redirectUri = {3}", new Object[]{e.getInput(), e.getMessage(), e.getReason(), redirectUri});
            throw SecureRedirectUrisEnforcerExecutor.invalidRedirectUri("Invalid Redirect Uri: invalid uri");
        }
        validation.validate();
    }

    private static ClientPolicyException invalidRedirectUri(String errorDetail) {
        return new ClientPolicyException("invalid_request", errorDetail);
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="allow-private-use-uri-scheme")
        protected boolean allowPrivateUseUriScheme;
        @JsonProperty(value="allow-ipv4-loopback-address")
        protected boolean allowIPv4LoopbackAddress;
        @JsonProperty(value="allow-ipv6-loopback-address")
        protected boolean allowIPv6LoopbackAddress;
        @JsonProperty(value="allow-http-scheme")
        protected boolean allowHttpScheme;
        @JsonProperty(value="allow-wildcard-context-path")
        protected boolean allowWildcardContextPath;
        @JsonProperty(value="allow-permitted-domains")
        protected List<String> allowPermittedDomains = Collections.emptyList();
        @JsonProperty(value="oauth-2-1-compliant")
        protected boolean oauth2_1complient;
        @JsonProperty(value="allow-open-redirect")
        protected boolean allowOpenRedirect;

        public boolean isAllowPrivateUseUriScheme() {
            return this.allowPrivateUseUriScheme;
        }

        public void setAllowPrivateUseUriScheme(boolean allowPrivateUseUriScheme) {
            this.allowPrivateUseUriScheme = allowPrivateUseUriScheme;
        }

        public boolean isAllowIPv4LoopbackAddress() {
            return this.allowIPv4LoopbackAddress;
        }

        public void setAllowIPv4LoopbackAddress(boolean allowIPv4LoopbackAddress) {
            this.allowIPv4LoopbackAddress = allowIPv4LoopbackAddress;
        }

        public boolean isAllowIPv6LoopbackAddress() {
            return this.allowIPv6LoopbackAddress;
        }

        public void setAllowIPv6LoopbackAddress(boolean allowIPv6LoopbackAddress) {
            this.allowIPv6LoopbackAddress = allowIPv6LoopbackAddress;
        }

        public boolean isAllowHttpScheme() {
            return this.allowHttpScheme;
        }

        public void setAllowHttpScheme(boolean allowHttpScheme) {
            this.allowHttpScheme = allowHttpScheme;
        }

        public boolean isAllowWildcardContextPath() {
            return this.allowWildcardContextPath;
        }

        public void setAllowWildcardContextPath(boolean allowWildcardContextPath) {
            this.allowWildcardContextPath = allowWildcardContextPath;
        }

        public List<String> getAllowPermittedDomains() {
            return this.allowPermittedDomains;
        }

        public void setAllowPermittedDomains(List<String> permittedDomains) {
            this.allowPermittedDomains = permittedDomains;
        }

        public boolean isOAuth2_1Compliant() {
            return this.oauth2_1complient;
        }

        public void setOAuth2_1Compliant(boolean oauth21complient) {
            this.oauth2_1complient = oauth21complient;
        }

        public boolean isAllowOpenRedirect() {
            return this.allowOpenRedirect;
        }

        public void setAllowOpenRedirect(boolean allowOpenRedirect) {
            this.allowOpenRedirect = allowOpenRedirect;
        }
    }

    public static class UriValidation {
        public final URI uri;
        public final boolean isRedirectUriParameter;
        public final Configuration config;

        public UriValidation(String uriString, boolean isRedirectUriParameter, Configuration config) throws URISyntaxException {
            this.uri = new URI(uriString);
            this.isRedirectUriParameter = isRedirectUriParameter;
            this.config = config;
        }

        public void validate() throws ClientPolicyException {
            switch (this.identifyUriType()) {
                case IPV4_LOOPBACK_ADDRESS: {
                    if (this.config.isAllowIPv4LoopbackAddress() && this.isValidIPv4LoopbackAddress()) break;
                    throw SecureRedirectUrisEnforcerExecutor.invalidRedirectUri(SecureRedirectUrisEnforcerExecutor.ERR_LOOPBACK);
                }
                case IPV6_LOOPBACK_ADDRESS: {
                    if (this.config.isAllowIPv6LoopbackAddress() && this.isValidIPv6LoopbackAddress()) break;
                    throw SecureRedirectUrisEnforcerExecutor.invalidRedirectUri(SecureRedirectUrisEnforcerExecutor.ERR_LOOPBACK);
                }
                case PRIVATE_USE_URI_SCHEME: {
                    if (this.config.isAllowPrivateUseUriScheme() && this.isValidPrivateUseUriScheme()) break;
                    throw SecureRedirectUrisEnforcerExecutor.invalidRedirectUri(SecureRedirectUrisEnforcerExecutor.ERR_PRIVATESCHEME);
                }
                case NORMAL_URI: {
                    if (this.isValidNormalUri()) break;
                    throw SecureRedirectUrisEnforcerExecutor.invalidRedirectUri("Invalid Redirect Uri: invalid uri");
                }
                default: {
                    logger.debugv("Invalid URI Type - input = {0}", (Object)this.uri.toString());
                    throw SecureRedirectUrisEnforcerExecutor.invalidRedirectUri("Invalid Redirect Uri: invalid uri");
                }
            }
        }

        SecureRedirectUrisEnforcerExecutorFactory.UriType identifyUriType() {
            if (this.isIPv4LoopbackAddress()) {
                return SecureRedirectUrisEnforcerExecutorFactory.UriType.IPV4_LOOPBACK_ADDRESS;
            }
            if (this.isIPv6LoopbackAddress()) {
                return SecureRedirectUrisEnforcerExecutorFactory.UriType.IPV6_LOOPBACK_ADDRESS;
            }
            if (this.isPrivateUseScheme()) {
                return SecureRedirectUrisEnforcerExecutorFactory.UriType.PRIVATE_USE_URI_SCHEME;
            }
            if (this.isNormalUri()) {
                return SecureRedirectUrisEnforcerExecutorFactory.UriType.NORMAL_URI;
            }
            return SecureRedirectUrisEnforcerExecutorFactory.UriType.INVALID_URI;
        }

        boolean isIPv4LoopbackAddress() {
            return this.isLoopbackAddressRedirectUri(i -> i instanceof Inet4Address);
        }

        boolean isIPv6LoopbackAddress() {
            return this.isLoopbackAddressRedirectUri(i -> i instanceof Inet6Address);
        }

        boolean isLoopbackAddressRedirectUri(Predicate<InetAddress> p) {
            InetAddress addr;
            if (this.uri.getHost() == null) {
                return false;
            }
            try {
                addr = InetAddress.getByName(this.uri.getHost());
            }
            catch (UnknownHostException e) {
                return false;
            }
            if (!addr.isLoopbackAddress()) {
                return false;
            }
            return p.test(addr);
        }

        boolean isPrivateUseScheme() {
            return this.uri.isAbsolute() && !this.isHttp() && !this.isHttps();
        }

        boolean isNormalUri() {
            return this.isHttp() || this.isHttps();
        }

        boolean isValidIPv4LoopbackAddress() {
            return this.isValidLoopbackAddress(i -> true);
        }

        boolean isValidIPv6LoopbackAddress() {
            return this.isValidLoopbackAddress(i -> {
                if (!"[::1]".equals(i.getHost())) {
                    logger.debugv("Invalid IPv6LoopbackAddress: unacceptable form - OAuth 2.1 compliant - input = {0}", (Object)this.uri.toString());
                    return false;
                }
                return true;
            });
        }

        boolean isValidLoopbackAddress(Predicate<URI> p) {
            if (!this.config.isAllowHttpScheme() && this.isHttp()) {
                logger.debugv("Invalid LoopbackAddress: HTTP not allowed - input = {0}", (Object)this.uri.toString());
                return false;
            }
            if (this.config.isAllowWildcardContextPath()) {
                if (this.isIncludeInvalidWildcard()) {
                    logger.debugv("Invalid LoopbackAddress: invalid Wildcard - input = {0}", (Object)this.uri.toString());
                    return false;
                }
            } else if (this.isIncludeWildcard()) {
                logger.debugv("Invalid LoopbackAddress: Wildcard not allowed - input = {0}", (Object)this.uri.toString());
                return false;
            }
            if (this.config.isOAuth2_1Compliant()) {
                if (this.isIncludeUriFragment()) {
                    logger.debugv("Invalid LoopbackAddress: URI fragment not allowed - OAuth 2.1 compliant - input = {0}", (Object)this.uri.toString());
                    return false;
                }
                if (this.isIncludeWildcard()) {
                    logger.debugv("Invalid LoopbackAddress: Wildcard not allowed - OAuth 2.1 compliant - input = {0}", (Object)this.uri.toString());
                    return false;
                }
                if ("localhost".equalsIgnoreCase(this.uri.getHost())) {
                    logger.debugv("Invalid LoopbackAddress: localhost not allowed - OAuth 2.1 compliant - input = {0}", (Object)this.uri.toString());
                    return false;
                }
                if (this.isRedirectUriParameter) {
                    if (this.uri.getPort() < 0 || this.uri.getPort() > 65535) {
                        logger.debugv("Invalid LoopbackAddress: invalid port number - OAuth 2.1 compliant - redirect_uri parameter - input = {0}", (Object)this.uri.toString());
                        return false;
                    }
                } else if (this.uri.getPort() > -1) {
                    logger.debugv("Invalid LoopbackAddress: port number not allowed - OAuth 2.1 compliant - input = {0}", (Object)this.uri.toString());
                    return false;
                }
                if (!p.test(this.uri)) {
                    return false;
                }
            }
            return true;
        }

        boolean isValidPrivateUseUriScheme() {
            if (this.config.isAllowWildcardContextPath()) {
                if (this.isIncludeInvalidWildcard()) {
                    logger.debugv("Invalid PrivateUseUriScheme: invalid Wildcard - input = {0}", (Object)this.uri.toString());
                    return false;
                }
            } else if (this.isIncludeWildcard()) {
                logger.debugv("Invalid PrivateUseUriScheme: Wildcard not allowed - input = {0}", (Object)this.uri.toString());
                return false;
            }
            if (this.config.isOAuth2_1Compliant()) {
                if (this.isIncludeUriFragment()) {
                    logger.debugv("Invalid PrivateUseUriScheme: URI fragment not allowed - OAuth 2.1 compliant - input = {0}", (Object)this.uri.toString());
                    return false;
                }
                if (this.isIncludeWildcard()) {
                    logger.debugv("Invalid PrivateUseUriScheme: Wildcard not allowed - OAuth 2.1 compliant - input = {0}", (Object)this.uri.toString());
                    return false;
                }
                if (this.uri.getScheme() == null || !this.uri.getScheme().contains(".")) {
                    logger.debugv("Invalid PrivateUseUriScheme: a single word scheme name is not allowed - OAuth 2.1 compliant - input = {0}", (Object)this.uri.toString());
                    return false;
                }
            }
            return true;
        }

        boolean isValidNormalUri() {
            if (!this.config.isAllowHttpScheme() && this.isHttp()) {
                logger.debugv("Invalid NormalUri: HTTP not allowed - input = {0}", (Object)this.uri.toString());
                return false;
            }
            if (this.config.isAllowWildcardContextPath()) {
                if (this.isIncludeInvalidWildcard()) {
                    logger.debugv("Invalid NormalUri: invalid Wildcard - input = {0}", (Object)this.uri.toString());
                    return false;
                }
            } else if (this.isIncludeWildcard()) {
                logger.debugv("Invalid NormalUri: Wildcard not allowed - input = {0}", (Object)this.uri.toString());
                return false;
            }
            if (this.config.getAllowPermittedDomains() != null && !this.config.getAllowPermittedDomains().isEmpty() && !this.matchDomains(this.config.getAllowPermittedDomains())) {
                logger.debugv("Invalid NormalUri: no permitted domain matched - input = {0}", (Object)this.uri.toString());
                return false;
            }
            if (this.config.isOAuth2_1Compliant()) {
                if (!this.isHttps()) {
                    logger.debugv("Invalid NormalUri: HTTP not allowed - OAuth 2.1 compliant - input = {0}", (Object)this.uri.toString());
                    return false;
                }
                if (this.isIncludeUriFragment()) {
                    logger.debugv("Invalid NormalUri: URI fragment not allowed - OAuth 2.1 compliant - input = {0}", (Object)this.uri.toString());
                    return false;
                }
                if (this.isIncludeWildcard()) {
                    logger.debugv("Invalid NormalUri: Wildcard not allowed - OAuth 2.1 compliant - input = {0}", (Object)this.uri.toString());
                    return false;
                }
            }
            return true;
        }

        boolean matchDomain(String domainPattern) {
            return this.uri.getHost() != null && this.uri.getHost().matches(domainPattern);
        }

        boolean matchDomains(List<String> permittedDomains) {
            return permittedDomains.stream().anyMatch(this::matchDomain);
        }

        boolean isHttp() {
            return "http".equals(this.uri.getScheme());
        }

        boolean isHttps() {
            return "https".equals(this.uri.getScheme());
        }

        boolean isWildcardContextPath() {
            return this.uri.getPath() != null && (this.uri.getPath().startsWith("/*") || this.uri.getPath().startsWith("*"));
        }

        boolean isIncludeUriFragment() {
            return this.uri.toString().contains("#");
        }

        boolean isIncludeWildcard() {
            return this.uri.toString().contains("*");
        }

        boolean isIncludeInvalidWildcard() {
            if (!this.isWildcardContextPath()) {
                return false;
            }
            return this.uri.toString().length() - this.uri.toString().replace("*", "").length() != 1;
        }
    }
}

