/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.ErrorCode;
import com.google.firebase.auth.AuthErrorCode;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseToken;
import com.google.firebase.auth.FirebaseTokenVerifier;
import com.google.firebase.auth.FirebaseUserManager;
import com.google.firebase.auth.UserRecord;

class RevocationCheckDecorator
implements FirebaseTokenVerifier {
    private final FirebaseTokenVerifier tokenVerifier;
    private final FirebaseUserManager userManager;
    private final AuthErrorCode errorCode;
    private final String shortName;

    private RevocationCheckDecorator(FirebaseTokenVerifier tokenVerifier, FirebaseUserManager userManager, AuthErrorCode errorCode, String shortName) {
        this.tokenVerifier = (FirebaseTokenVerifier)Preconditions.checkNotNull((Object)tokenVerifier);
        this.userManager = (FirebaseUserManager)Preconditions.checkNotNull((Object)userManager);
        this.errorCode = (AuthErrorCode)((Object)Preconditions.checkNotNull((Object)((Object)errorCode)));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)shortName) ? 1 : 0) != 0);
        this.shortName = shortName;
    }

    @Override
    public FirebaseToken verifyToken(String token) throws FirebaseAuthException {
        FirebaseToken firebaseToken = this.tokenVerifier.verifyToken(token);
        this.validateDisabledOrRevoked(firebaseToken);
        return firebaseToken;
    }

    private void validateDisabledOrRevoked(FirebaseToken firebaseToken) throws FirebaseAuthException {
        UserRecord user = this.userManager.getUserById(firebaseToken.getUid());
        if (user.isDisabled()) {
            throw new FirebaseAuthException(ErrorCode.INVALID_ARGUMENT, "The user record is disabled.", null, null, AuthErrorCode.USER_DISABLED);
        }
        long issuedAtInSeconds = (Long)firebaseToken.getClaims().get("iat");
        if (user.getTokensValidAfterTimestamp() > issuedAtInSeconds * 1000L) {
            throw new FirebaseAuthException(ErrorCode.INVALID_ARGUMENT, "Firebase " + this.shortName + " is revoked.", null, null, this.errorCode);
        }
    }

    static RevocationCheckDecorator decorateIdTokenVerifier(FirebaseTokenVerifier tokenVerifier, FirebaseUserManager userManager) {
        return new RevocationCheckDecorator(tokenVerifier, userManager, AuthErrorCode.REVOKED_ID_TOKEN, "id token");
    }

    static RevocationCheckDecorator decorateSessionCookieVerifier(FirebaseTokenVerifier tokenVerifier, FirebaseUserManager userManager) {
        return new RevocationCheckDecorator(tokenVerifier, userManager, AuthErrorCode.REVOKED_SESSION_COOKIE, "session cookie");
    }
}

