/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.postgresql.shaded.com.ongres.scram.common.AbstractScramMessage;
import org.postgresql.shaded.com.ongres.scram.common.ScramAttributeValue;
import org.postgresql.shaded.com.ongres.scram.common.ScramAttributes;
import org.postgresql.shaded.com.ongres.scram.common.ScramStringFormatting;
import org.postgresql.shaded.com.ongres.scram.common.StringWritableCsv;
import org.postgresql.shaded.com.ongres.scram.common.exception.ScramParseException;
import org.postgresql.shaded.com.ongres.scram.common.exception.ServerErrorValue;
import org.postgresql.shaded.com.ongres.scram.common.util.Preconditions;

public final class ServerFinalMessage
extends AbstractScramMessage {
    private final byte @Nullable [] verifier;
    @Nullable
    private final String serverError;

    public ServerFinalMessage(byte @NotNull [] verifier) {
        this.verifier = Preconditions.checkNotNull(verifier, "verifier");
        this.serverError = null;
    }

    public ServerFinalMessage(@NotNull String serverError) {
        this.serverError = ServerFinalMessage.validateServerErrorType(serverError);
        this.verifier = null;
    }

    public boolean isError() {
        return null != this.serverError;
    }

    public byte @Nullable [] getVerifier() {
        return this.verifier != null ? (byte[])Preconditions.checkNotNull(this.verifier, "verifier").clone() : null;
    }

    @Nullable
    public String getServerError() {
        return this.serverError;
    }

    @NotNull
    public static ServerFinalMessage parseFrom(@NotNull String serverFinalMessage) throws ScramParseException {
        Preconditions.checkNotEmpty(serverFinalMessage, "serverFinalMessage");
        @NotNull String @NotNull [] attributeValues = StringWritableCsv.parseFrom(serverFinalMessage, 1, 0);
        if (attributeValues.length != 1) {
            throw new ScramParseException("Invalid server-final-message");
        }
        ScramAttributeValue attributeValue = ScramAttributeValue.parse(attributeValues[0]);
        if (ScramAttributes.SERVER_SIGNATURE.getChar() == attributeValue.getChar()) {
            byte[] verifier = ScramStringFormatting.base64Decode(attributeValue.getValue());
            return new ServerFinalMessage(verifier);
        }
        if (ScramAttributes.ERROR.getChar() == attributeValue.getChar()) {
            return new ServerFinalMessage(attributeValue.getValue());
        }
        throw new ScramParseException("Invalid server-final-message: it must contain either a verifier or an error attribute");
    }

    @Override
    StringBuilder writeTo(StringBuilder sb) {
        return StringWritableCsv.writeTo(sb, this.isError() ? new ScramAttributeValue(ScramAttributes.ERROR, Preconditions.castNonNull(this.serverError)) : new ScramAttributeValue(ScramAttributes.SERVER_SIGNATURE, ScramStringFormatting.base64Encode(Preconditions.castNonNull(this.verifier))));
    }

    private static String validateServerErrorType(@NotNull String serverError) {
        Preconditions.checkNotNull(serverError, "serverError");
        if (ServerErrorValue.getErrorMessage(serverError) == null) {
            throw new IllegalArgumentException("Invalid server-error-value '" + serverError + "'");
        }
        return serverError;
    }
}

