/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BufferUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class EnforaProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("GPRMC,").number("(dd)(dd)(dd).?d*,").expression("([AV]),").number("(dd)(dd.d+),").expression("([NS]),").number("(ddd)(dd.d+),").expression("([EW]),").number("(d+.d+)?,").number("(d+.d+)?,").number("(dd)(dd)(dd),").any().compile();
    public static final int IMEI_LENGTH = 15;

    public EnforaProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        int index = -1;
        for (int i = buf.readerIndex(); i < buf.writerIndex() - 15; ++i) {
            index = i;
            for (int j = i; j < i + 15; ++j) {
                if (Character.isDigit((char)buf.getByte(j))) continue;
                index = -1;
                break;
            }
            if (index > 0) break;
        }
        if (index == -1) {
            return null;
        }
        String imei = buf.toString(index, 15, StandardCharsets.US_ASCII);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        int start = BufferUtil.indexOf("GPRMC", buf);
        if (start == -1) {
            return null;
        }
        String sentence = buf.toString(start, buf.readableBytes() - start, StandardCharsets.US_ASCII);
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setTime(dateBuilder.getDate());
        return position;
    }
}

