/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.awt.IconWithArrow;
import org.openide.util.ImageUtilities;
import org.openide.util.Parameters;

class DropDownButton
extends JButton {
    private boolean mouseInButton = false;
    private boolean mouseInArrowArea = false;
    private boolean popupClosingInProgress = false;
    private Map<String, Icon> regIcons = new HashMap<String, Icon>(5);
    private Map<String, Icon> arrowIcons = new HashMap<String, Icon>(5);
    private static final String ICON_NORMAL = "normal";
    private static final String ICON_PRESSED = "pressed";
    private static final String ICON_ROLLOVER = "rollover";
    private static final String ICON_ROLLOVER_SELECTED = "rolloverSelected";
    private static final String ICON_SELECTED = "selected";
    private static final String ICON_DISABLED = "disabled";
    private static final String ICON_DISABLED_SELECTED = "disabledSelected";
    private static final String ICON_ROLLOVER_LINE = "rolloverLine";
    private static final String ICON_ROLLOVER_SELECTED_LINE = "rolloverSelectedLine";
    private PopupMenuListener menuListener;

    public DropDownButton(Icon icon, JPopupMenu jPopupMenu) {
        Parameters.notNull((CharSequence)"icon", (Object)icon);
        this.putClientProperty("dropDownMenu", jPopupMenu);
        this.setIcon(icon);
        this.setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)icon));
        this.resetIcons();
        this.addPropertyChangeListener("dropDownMenu", propertyChangeEvent -> this.resetIcons());
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (null != DropDownButton.this.getPopupMenu()) {
                    DropDownButton.this.mouseInArrowArea = DropDownButton.this.isInArrowArea(mouseEvent.getPoint());
                    DropDownButton.this.updateRollover(DropDownButton.this._getRolloverIcon(), DropDownButton.this._getRolloverSelectedIcon());
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){
            private boolean popupMenuOperation = false;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (DropDownButton.this.popupClosingInProgress) {
                    return;
                }
                this.popupMenuOperation = false;
                JPopupMenu jPopupMenu = DropDownButton.this.getPopupMenu();
                if (jPopupMenu != null && DropDownButton.this.getModel() instanceof Model) {
                    Model model = (Model)DropDownButton.this.getModel();
                    if (!model._isPressed()) {
                        if (DropDownButton.this.isInArrowArea(mouseEvent.getPoint()) && jPopupMenu.getComponentCount() > 0 && model.isEnabled()) {
                            model._press();
                            jPopupMenu.addPopupMenuListener(DropDownButton.this.getMenuListener());
                            jPopupMenu.show(DropDownButton.this, 0, DropDownButton.this.getHeight());
                            this.popupMenuOperation = true;
                        }
                    } else {
                        model._release();
                        jPopupMenu.removePopupMenuListener(DropDownButton.this.getMenuListener());
                        this.popupMenuOperation = true;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (this.popupMenuOperation) {
                    this.popupMenuOperation = false;
                    mouseEvent.consume();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                DropDownButton.this.mouseInButton = true;
                if (DropDownButton.this.hasPopupMenu()) {
                    DropDownButton.this.mouseInArrowArea = DropDownButton.this.isInArrowArea(mouseEvent.getPoint());
                    DropDownButton.this.updateRollover(DropDownButton.this._getRolloverIcon(), DropDownButton.this._getRolloverSelectedIcon());
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                DropDownButton.this.mouseInButton = false;
                DropDownButton.this.mouseInArrowArea = false;
                if (DropDownButton.this.hasPopupMenu()) {
                    DropDownButton.this.updateRollover(DropDownButton.this._getRolloverIcon(), DropDownButton.this._getRolloverSelectedIcon());
                }
            }
        });
        this.setModel(new Model());
    }

    private PopupMenuListener getMenuListener() {
        if (null == this.menuListener) {
            this.menuListener = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    JPopupMenu jPopupMenu;
                    if (DropDownButton.this.getModel() instanceof Model) {
                        ((Model)DropDownButton.this.getModel())._release();
                    }
                    if (null != (jPopupMenu = DropDownButton.this.getPopupMenu())) {
                        jPopupMenu.removePopupMenuListener(this);
                    }
                    DropDownButton.this.popupClosingInProgress = true;
                    SwingUtilities.invokeLater(() -> DropDownButton.this.popupClosingInProgress = false);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            };
        }
        return this.menuListener;
    }

    private void updateRollover(Icon icon, Icon icon2) {
        super.setRolloverIcon(icon);
        super.setRolloverSelectedIcon(icon2);
    }

    private void resetIcons() {
        Icon icon = this.regIcons.get(ICON_NORMAL);
        if (null != icon) {
            this.setIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_PRESSED))) {
            this.setPressedIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_ROLLOVER))) {
            this.setRolloverIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_ROLLOVER_SELECTED))) {
            this.setRolloverSelectedIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_SELECTED))) {
            this.setSelectedIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_DISABLED))) {
            this.setDisabledIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_DISABLED_SELECTED))) {
            this.setDisabledSelectedIcon(icon);
        }
    }

    private Icon _getRolloverIcon() {
        Icon icon = null;
        icon = this.arrowIcons.get(this.mouseInArrowArea ? ICON_ROLLOVER : ICON_ROLLOVER_LINE);
        if (null == icon) {
            Icon icon2 = this.regIcons.get(ICON_ROLLOVER);
            if (null == icon2) {
                icon2 = this.regIcons.get(ICON_NORMAL);
            }
            icon = new IconWithArrow(icon2, !this.mouseInArrowArea, false);
            this.arrowIcons.put(this.mouseInArrowArea ? ICON_ROLLOVER : ICON_ROLLOVER_LINE, icon);
        }
        return icon;
    }

    private Icon _getRolloverSelectedIcon() {
        Icon icon = null;
        icon = this.arrowIcons.get(this.mouseInArrowArea ? ICON_ROLLOVER_SELECTED : ICON_ROLLOVER_SELECTED_LINE);
        if (null == icon) {
            Icon icon2 = this.regIcons.get(ICON_ROLLOVER_SELECTED);
            if (null == icon2) {
                icon2 = this.regIcons.get(ICON_ROLLOVER);
            }
            if (null == icon2) {
                icon2 = this.regIcons.get(ICON_NORMAL);
            }
            icon = new IconWithArrow(icon2, !this.mouseInArrowArea, false);
            this.arrowIcons.put(this.mouseInArrowArea ? ICON_ROLLOVER_SELECTED : ICON_ROLLOVER_SELECTED_LINE, icon);
        }
        return icon;
    }

    JPopupMenu getPopupMenu() {
        Object object = this.getClientProperty("dropDownMenu");
        if (object instanceof JPopupMenu) {
            return (JPopupMenu)object;
        }
        return null;
    }

    boolean hasPopupMenu() {
        return null != this.getPopupMenu();
    }

    private boolean isInArrowArea(Point point) {
        if (this.getActionListeners().length == 0) {
            return true;
        }
        return point.getLocation().x >= this.getWidth() - IconWithArrow.getArrowAreaWidth() - this.getInsets().right;
    }

    @Override
    public void setIcon(Icon icon) {
        assert (null != icon);
        Icon icon2 = this.updateIcons(icon, ICON_NORMAL);
        this.arrowIcons.remove(ICON_ROLLOVER_LINE);
        this.arrowIcons.remove(ICON_ROLLOVER_SELECTED_LINE);
        this.arrowIcons.remove(ICON_ROLLOVER);
        this.arrowIcons.remove(ICON_ROLLOVER_SELECTED);
        super.setIcon(this.hasPopupMenu() ? icon2 : icon);
        this.updateRollover(this._getRolloverIcon(), this._getRolloverSelectedIcon());
    }

    private Icon updateIcons(Icon icon, String string) {
        IconWithArrow iconWithArrow = null;
        if (null == icon) {
            this.regIcons.remove(string);
            this.arrowIcons.remove(string);
        } else {
            this.regIcons.put(string, icon);
            iconWithArrow = new IconWithArrow(icon, false, string.equals(ICON_DISABLED) || string.equals(ICON_DISABLED_SELECTED));
            this.arrowIcons.put(string, iconWithArrow);
        }
        return iconWithArrow;
    }

    @Override
    public void setPressedIcon(Icon icon) {
        Icon icon2 = this.updateIcons(icon, ICON_PRESSED);
        super.setPressedIcon(this.hasPopupMenu() ? icon2 : icon);
    }

    @Override
    public void setSelectedIcon(Icon icon) {
        Icon icon2 = this.updateIcons(icon, ICON_SELECTED);
        super.setSelectedIcon(this.hasPopupMenu() ? icon2 : icon);
    }

    @Override
    public void setRolloverIcon(Icon icon) {
        Icon icon2 = this.updateIcons(icon, ICON_ROLLOVER);
        this.arrowIcons.remove(ICON_ROLLOVER_LINE);
        this.arrowIcons.remove(ICON_ROLLOVER_SELECTED_LINE);
        super.setRolloverIcon(this.hasPopupMenu() ? icon2 : icon);
    }

    @Override
    public void setRolloverSelectedIcon(Icon icon) {
        Icon icon2 = this.updateIcons(icon, ICON_ROLLOVER_SELECTED);
        this.arrowIcons.remove(ICON_ROLLOVER_SELECTED_LINE);
        super.setRolloverSelectedIcon(this.hasPopupMenu() ? icon2 : icon);
    }

    @Override
    public void setDisabledIcon(Icon icon) {
        Icon icon2 = this.updateIcons(icon, ICON_DISABLED);
        super.setDisabledIcon(this.hasPopupMenu() ? icon2 : icon);
    }

    @Override
    public void setDisabledSelectedIcon(Icon icon) {
        Icon icon2 = this.updateIcons(icon, ICON_DISABLED_SELECTED);
        super.setDisabledSelectedIcon(this.hasPopupMenu() ? icon2 : icon);
    }

    @Override
    public void setText(String string) {
        Logger.getLogger(DropDownButton.class.getName()).log(Level.FINER, "DropDownButton cannot display text.");
    }

    @Override
    public String getText() {
        return null;
    }

    private class Model
    extends DefaultButtonModel {
        private boolean _pressed = false;

        private Model() {
        }

        @Override
        public void setPressed(boolean bl) {
            if (this._pressed || bl && DropDownButton.this.mouseInArrowArea) {
                return;
            }
            super.setPressed(bl);
        }

        public void _press() {
            if (this._pressed && this.isPressed() || !this.isEnabled()) {
                return;
            }
            this.stateMask |= 5;
            this.fireStateChanged();
            this._pressed = true;
        }

        public void _release() {
            this._pressed = false;
            this.setArmed(false);
            this.setPressed(false);
            this.setRollover(false);
            this.setSelected(false);
        }

        public boolean _isPressed() {
            return this._pressed;
        }

        @Override
        protected void fireStateChanged() {
            if (this._pressed) {
                return;
            }
            super.fireStateChanged();
        }

        @Override
        public void setArmed(boolean bl) {
            if (this._pressed) {
                return;
            }
            super.setArmed(bl);
        }

        @Override
        public void setEnabled(boolean bl) {
            if (this._pressed) {
                return;
            }
            super.setEnabled(bl);
        }

        @Override
        public void setSelected(boolean bl) {
            if (this._pressed) {
                return;
            }
            super.setSelected(bl);
        }

        @Override
        public void setRollover(boolean bl) {
            if (this._pressed) {
                return;
            }
            super.setRollover(bl);
        }
    }
}

