"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const zigbee_herdsman_1 = require("zigbee-herdsman");
const m = __importStar(require("../lib/modernExtend"));
const reporting = __importStar(require("../lib/reporting"));
const manufacturerCode = 0x4703;
exports.definitions = [
    {
        zigbeeModel: ["AUX-1-ZB-S"],
        model: "AUX-1-ZB-S",
        vendor: "ONOKOM",
        description: "AIR AUX-1-MB-B (Adapter for household and semi-industrial AUX systems)",
        ota: true,
        extend: [
            m.enumLookup({
                name: "ac_connected",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4734, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    disconnected: 0,
                    invalid_data_recieved: 1,
                    connected_with_issues: 2,
                    connected: 3,
                },
                description: "AC connected",
                access: "STATE",
            }),
            m.onOff({
                powerOnBehavior: false,
                description: "On/off state",
            }),
            m.numeric({
                name: "current_temperature",
                cluster: "hvacThermostat",
                attribute: "localTemp",
                scale: 100,
                unit: "°C",
                description: "Current temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "target_temperature",
                cluster: "hvacThermostat",
                attribute: "occupiedCoolingSetpoint",
                valueMin: 16,
                valueMax: 32,
                valueStep: 0.5,
                scale: 100,
                unit: "°C",
                description: "Target temperature",
            }),
            m.enumLookup({
                name: "system_mode",
                cluster: "hvacThermostat",
                attribute: "systemMode",
                lookup: {
                    off: 0,
                    auto: 1,
                    cool: 3,
                    heat: 4,
                    fan_only: 7,
                    dry: 8,
                },
                description: "Active mode",
            }),
            m.enumLookup({
                name: "mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4703, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    heat: 1,
                    cool: 2,
                    auto: 3,
                    dry: 4,
                    fan_only: 5,
                },
                description: "Modes",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "outdoor_air_temperature",
                cluster: "hvacThermostat",
                attribute: "outdoorTemp",
                scale: 100,
                unit: "°C",
                description: "Outdoor air temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "zb_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: "fanMode",
                valueMin: 1,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed modes: Auto(5), Low(1), Medium(2), Maximum(3)",
            }),
            m.numeric({
                name: "vertical_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 1,
                valueStep: 1,
                description: "Vertical vanes: Stopped(0), Swing(1)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "horizontal_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 6,
                valueStep: 1,
                description: "Horizontal vanes: Stopped(0), Swing(1), Lowest postion(2), Highest position(6)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 3,
                valueStep: 1,
                description: "Fan speed: Auto(0), First(1) - Maximum(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "smart_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 5,
                valueStep: 1,
                description: "Smart fan speed: Auto (0), Quiet mode (1), First (2) ... Maximum (4), Turbo(5)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "vanes_swing",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4702, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 3,
                valueStep: 1,
                description: "Vanes swing: Stopped(0), Horizontal and vertical swing(1), Horizontal swing(2), Vertical swing(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.enumLookup({
                name: "status_led",
                cluster: "genOnOff",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    normal_mode: 0,
                    disabled_if_no_errors: 1,
                    disabled_untill_reboot: 2,
                    always_disabled: 3,
                    green_untill_reboot: 8,
                    red_untill_reboot: 9,
                },
                description: "Status LED",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "quiet_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4710, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Quiet mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "turbo_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4711, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Turbo mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "sleep_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4728, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Sleep mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "ionization",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4720, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Ionization",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "self_cleaning",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4721, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Self cleaning",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "mold_protection",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4722, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Mold protection",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "indoor_heat_exchanger_temperature",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4740, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                unit: "°C",
                description: "Indoor heat exchanger temperature",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "screen_light",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4731, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Screen light",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "current_fan_rpm",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4724, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                description: "Current fan RPM",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "current_compressor_power",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4721, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                description: "Current compressor power",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "compressor_power_limit",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4720, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                description: "Compressor power limit",
                zigbeeCommandOptions: { manufacturerCode },
            }),
        ],
        fromZigbee: [],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["hvacThermostat", "hvacFanCtrl", "genOnOff"]);
            await reporting.thermostatTemperature(endpoint);
            await reporting.onOff(endpoint);
        },
    },
    {
        zigbeeModel: ["DK-1-ZB-S"],
        model: "DK-1-ZB-S",
        vendor: "ONOKOM",
        description: "AIR DK-1-MB-B (Adapter for household Daikin systems)",
        ota: true,
        extend: [
            m.enumLookup({
                name: "ac_connected",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4734, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    disconnected: 0,
                    invalid_data_recieved: 1,
                    connected_with_issues: 2,
                    connected: 3,
                },
                description: "AC connected",
                access: "STATE",
            }),
            m.onOff({
                powerOnBehavior: false,
                description: "On/off state",
            }),
            m.numeric({
                name: "current_temperature",
                cluster: "hvacThermostat",
                attribute: "localTemp",
                scale: 100,
                unit: "°C",
                description: "Current temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "target_temperature",
                cluster: "hvacThermostat",
                attribute: "occupiedCoolingSetpoint",
                valueMin: 16,
                valueMax: 32,
                valueStep: 0.5,
                scale: 100,
                unit: "°C",
                description: "Target temperature",
            }),
            m.enumLookup({
                name: "system_mode",
                cluster: "hvacThermostat",
                attribute: "systemMode",
                lookup: {
                    off: 0,
                    auto: 1,
                    cool: 3,
                    heat: 4,
                    fan_only: 7,
                    dry: 8,
                },
                description: "Active mode",
            }),
            m.enumLookup({
                name: "mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4703, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    heat: 1,
                    cool: 2,
                    auto: 3,
                    dry: 4,
                    fan_only: 5,
                },
                description: "Modes",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "outdoor_air_temperature",
                cluster: "hvacThermostat",
                attribute: "outdoorTemp",
                scale: 100,
                unit: "°C",
                description: "Outdoor air temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "zb_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: "fanMode",
                valueMin: 1,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed modes: Auto(5), Low(1), Medium(2), Maximum(3)",
            }),
            m.numeric({
                name: "vertical_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 1,
                valueStep: 1,
                description: "Vertical vanes: Stopped(0), Swing(1)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "horizontal_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 1,
                valueStep: 1,
                description: "Horizontal vanes: Stopped(0), Swing(1)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed: Auto(0), First(1) - Maximum(5)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "smart_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 7,
                valueStep: 1,
                description: "Smart fan speed: Auto (0), Quiet mode (1), First (2) ... Maximum (6), Turbo(7)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "vanes_swing",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4702, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 3,
                valueStep: 1,
                description: "Vanes swing: Stopped(0), Horizontal and vertical swing(1), Horizontal swing(2), Vertical swing(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.enumLookup({
                name: "status_led",
                cluster: "genOnOff",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    normal_mode: 0,
                    disabled_if_no_errors: 1,
                    disabled_untill_reboot: 2,
                    always_disabled: 3,
                    green_untill_reboot: 8,
                    red_untill_reboot: 9,
                },
                description: "Status LED",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "quiet_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4710, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Quiet mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "eco_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4727, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Eco mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "turbo_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4711, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Turbo mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "screen_light",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4731, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Screen light",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "screen_low_bright",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4733, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Screen low bright",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "target_fan_rpm",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4723, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                description: "Target fan rpm",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "current_fan_rpm",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4724, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                description: "Current fan RPM",
                zigbeeCommandOptions: { manufacturerCode },
            }),
        ],
        fromZigbee: [],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["hvacThermostat", "hvacFanCtrl", "genOnOff"]);
            await reporting.thermostatTemperature(endpoint);
            await reporting.onOff(endpoint);
        },
    },
    {
        zigbeeModel: ["GR-1-ZB-S"],
        model: "GR-1-ZB-S",
        vendor: "ONOKOM",
        description: "AIR GR-1-MB-B (Adapter for household GREE systems)",
        ota: true,
        extend: [
            m.enumLookup({
                name: "ac_connected",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4734, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    disconnected: 0,
                    invalid_data_recieved: 1,
                    connected_with_issues: 2,
                    connected: 3,
                },
                description: "AC connected",
                access: "STATE",
            }),
            m.onOff({
                powerOnBehavior: false,
                description: "On/off state",
            }),
            m.numeric({
                name: "current_temperature",
                cluster: "hvacThermostat",
                attribute: "localTemp",
                scale: 100,
                unit: "°C",
                description: "Current temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "target_temperature",
                cluster: "hvacThermostat",
                attribute: "occupiedCoolingSetpoint",
                valueMin: 16,
                valueMax: 30,
                valueStep: 1,
                scale: 100,
                unit: "°C",
                description: "Target temperature",
            }),
            m.enumLookup({
                name: "system_mode",
                cluster: "hvacThermostat",
                attribute: "systemMode",
                lookup: {
                    off: 0,
                    auto: 1,
                    cool: 3,
                    heat: 4,
                    fan_only: 7,
                    dry: 8,
                },
                description: "Active mode",
            }),
            m.enumLookup({
                name: "mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4703, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    heat: 1,
                    cool: 2,
                    auto: 3,
                    dry: 4,
                    fan_only: 5,
                },
                description: "Modes",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "outdoor_air_temperature",
                cluster: "hvacThermostat",
                attribute: "outdoorTemp",
                scale: 100,
                unit: "°C",
                description: "Outdoor air temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "zb_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: "fanMode",
                valueMin: 1,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed modes: Auto(5), Low(1), Medium(2), Maximum(3)",
            }),
            m.numeric({
                name: "vertical_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 6,
                valueStep: 1,
                description: "Vertical vanes: Stopped(0), Swing(1), Leftmost position(2), Rightmost position(6)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "horizontal_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 6,
                valueStep: 1,
                description: "Horizontal vanes: Stopped(0), Swing(1), Lowest postion(2), Highest position(6)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed: Auto(0), First(1) - Maximum(5)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "smart_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 7,
                valueStep: 1,
                description: "Smart fan speed: Auto (0), Quiet mode (1), First (2) ... Maximum (6), Turbo(7)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "vanes_swing",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4702, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 3,
                valueStep: 1,
                description: "Vanes swing: Stopped(0), Horizontal and vertical swing(1), Horizontal swing(2), Vertical swing(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.enumLookup({
                name: "status_led",
                cluster: "genOnOff",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    normal_mode: 0,
                    disabled_if_no_errors: 1,
                    disabled_untill_reboot: 2,
                    always_disabled: 3,
                    green_untill_reboot: 8,
                    red_untill_reboot: 9,
                },
                description: "Status LED",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "quiet_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4710, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Quiet mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "eco_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4727, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Eco mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "turbo_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4711, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Turbo mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "sleep_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4728, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Sleep mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "ionization",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4720, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Ionization",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "screen_light",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4731, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Screen light",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "disable_screen_when_power_off",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4732, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Disable screen when power off",
                zigbeeCommandOptions: { manufacturerCode },
            }),
        ],
        fromZigbee: [],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["hvacThermostat", "hvacFanCtrl", "genOnOff"]);
            await reporting.thermostatTemperature(endpoint);
            await reporting.onOff(endpoint);
        },
    },
    {
        zigbeeModel: ["GR-3-ZB-S"],
        model: "GR-3-ZB-S",
        vendor: "ONOKOM",
        description: "AIR GR-3-MB-B (Adapter for control of semi-industrial and multi-split systems GREE)",
        ota: true,
        extend: [
            m.enumLookup({
                name: "ac_connected",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4734, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    disconnected: 0,
                    invalid_data_recieved: 1,
                    connected_with_issues: 2,
                    connected: 3,
                },
                description: "AC connected",
                access: "STATE",
            }),
            m.onOff({
                powerOnBehavior: false,
                description: "On/off state",
            }),
            m.numeric({
                name: "current_temperature",
                cluster: "hvacThermostat",
                attribute: "localTemp",
                scale: 100,
                unit: "°C",
                description: "Current temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "target_temperature",
                cluster: "hvacThermostat",
                attribute: "occupiedCoolingSetpoint",
                valueMin: 16,
                valueMax: 30,
                valueStep: 1,
                scale: 100,
                unit: "°C",
                description: "Target temperature",
            }),
            m.enumLookup({
                name: "system_mode",
                cluster: "hvacThermostat",
                attribute: "systemMode",
                lookup: {
                    off: 0,
                    auto: 1,
                    cool: 3,
                    heat: 4,
                    fan_only: 7,
                    dry: 8,
                },
                description: "Active mode",
            }),
            m.enumLookup({
                name: "mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4703, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    heat: 1,
                    cool: 2,
                    auto: 3,
                    dry: 4,
                    fan_only: 5,
                },
                description: "Modes",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "outdoor_air_temperature",
                cluster: "hvacThermostat",
                attribute: "outdoorTemp",
                scale: 100,
                unit: "°C",
                description: "Outdoor air temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "zb_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: "fanMode",
                valueMin: 1,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed modes: Auto(5), Low(1), Medium(2), Maximum(3)",
            }),
            m.numeric({
                name: "vertical_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 6,
                valueStep: 1,
                description: "Vertical vanes: Stopped(0), Swing(1), Leftmost position(2), Rightmost position(6)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "horizontal_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 6,
                valueStep: 1,
                description: "Horizontal vanes: Stopped(0), Swing(1), Lowest postion(2), Highest position(6)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed: Auto(0), First(1) - Maximum(5)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "smart_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 7,
                valueStep: 1,
                description: "Smart fan speed: Auto (0), Quiet mode (1), First (2) ... Maximum (6), Turbo(7)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "vanes_swing",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4702, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 3,
                valueStep: 1,
                description: "Vanes swing: Stopped(0), Horizontal and vertical swing(1), Horizontal swing(2), Vertical swing(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.enumLookup({
                name: "status_led",
                cluster: "genOnOff",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    normal_mode: 0,
                    disabled_if_no_errors: 1,
                    disabled_untill_reboot: 2,
                    always_disabled: 3,
                    green_untill_reboot: 8,
                    red_untill_reboot: 9,
                },
                description: "Status LED",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "quiet_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4710, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Quiet mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "eco_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4727, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Eco mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "turbo_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4711, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Turbo mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "sleep_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4728, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Sleep mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "ionization",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4720, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Ionization",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "self_cleaning",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4721, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Self cleaning",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "indoor_heat_exchanger_temperature",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4740, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                unit: "°C",
                description: "Indoor heat exchanger temperature",
                zigbeeCommandOptions: { manufacturerCode },
            }),
        ],
        fromZigbee: [],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["hvacThermostat", "hvacFanCtrl", "genOnOff"]);
            await reporting.thermostatTemperature(endpoint);
            await reporting.onOff(endpoint);
        },
    },
    {
        zigbeeModel: ["HR-1-ZB-S"],
        model: "HR-1-ZB-S",
        vendor: "ONOKOM",
        description: "AIR HR-1-MB-B (Adapter for household and semi-industrial Haier systems)",
        ota: true,
        extend: [
            m.enumLookup({
                name: "ac_connected",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4734, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    disconnected: 0,
                    invalid_data_recieved: 1,
                    connected_with_issues: 2,
                    connected: 3,
                },
                description: "AC connected",
                access: "STATE",
            }),
            m.onOff({
                powerOnBehavior: false,
                description: "On/off state",
            }),
            m.numeric({
                name: "current_temperature",
                cluster: "hvacThermostat",
                attribute: "localTemp",
                scale: 100,
                unit: "°C",
                description: "Current temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "target_temperature",
                cluster: "hvacThermostat",
                attribute: "occupiedCoolingSetpoint",
                valueMin: 16,
                valueMax: 32,
                valueStep: 1,
                scale: 100,
                unit: "°C",
                description: "Target temperature",
            }),
            m.enumLookup({
                name: "system_mode",
                cluster: "hvacThermostat",
                attribute: "systemMode",
                lookup: {
                    off: 0,
                    auto: 1,
                    cool: 3,
                    heat: 4,
                    fan_only: 7,
                    dry: 8,
                },
                description: "Active mode",
            }),
            m.enumLookup({
                name: "mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4703, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    heat: 1,
                    cool: 2,
                    auto: 3,
                    dry: 4,
                    fan_only: 5,
                },
                description: "Modes",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "outdoor_air_temperature",
                cluster: "hvacThermostat",
                attribute: "outdoorTemp",
                scale: 100,
                unit: "°C",
                description: "Outdoor air temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "zb_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: "fanMode",
                valueMin: 1,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed modes: Auto(5), Low(1), Medium(2), Maximum(3)",
            }),
            m.numeric({
                name: "vertical_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 6,
                valueStep: 1,
                description: "Vertical vanes: Stopped(0), Swing(1), Leftmost position(2), Rightmost position(6)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "horizontal_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 8,
                valueStep: 1,
                description: "Horizontal vanes: Stopped(0), Swing(1), Lowest postion(2), Highest position(8)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 3,
                valueStep: 1,
                description: "Fan speed: Auto(0), First(1) - Maximum(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "smart_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 5,
                valueStep: 1,
                description: "Smart fan speed: Auto (0), Quiet mode (1), First (2) ... Maximum (4), Turbo(5)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "vanes_swing",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4702, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 3,
                valueStep: 1,
                description: "Vanes swing: Stopped(0), Horizontal and vertical swing(1), Horizontal swing(2), Vertical swing(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.enumLookup({
                name: "status_led",
                cluster: "genOnOff",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    normal_mode: 0,
                    disabled_if_no_errors: 1,
                    disabled_untill_reboot: 2,
                    always_disabled: 3,
                    green_untill_reboot: 8,
                    red_untill_reboot: 9,
                },
                description: "Status LED",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "quiet_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4710, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Quiet mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "turbo_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4711, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Turbo mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "sleep_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4728, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Sleep mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "ionization",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4720, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Ionization",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "self_cleaning",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4721, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Self cleaning",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "screen_light",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4731, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Screen light",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "beeper",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4730, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Beeper",
                zigbeeCommandOptions: { manufacturerCode },
            }),
        ],
        fromZigbee: [],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["hvacThermostat", "hvacFanCtrl", "genOnOff"]);
            await reporting.thermostatTemperature(endpoint);
            await reporting.onOff(endpoint);
        },
    },
    {
        zigbeeModel: ["HS-3-ZB-S"],
        model: "HS-3-ZB-S",
        vendor: "ONOKOM",
        description: "AIR HS-3-MB-B (Adapter for household Hisesnse systems)",
        ota: true,
        extend: [
            m.enumLookup({
                name: "ac_connected",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4734, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    disconnected: 0,
                    invalid_data_recieved: 1,
                    connected_with_issues: 2,
                    connected: 3,
                },
                description: "AC connected",
                access: "STATE",
            }),
            m.onOff({
                powerOnBehavior: false,
                description: "On/off state",
            }),
            m.numeric({
                name: "current_temperature",
                cluster: "hvacThermostat",
                attribute: "localTemp",
                scale: 100,
                unit: "°C",
                description: "Current temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "target_temperature",
                cluster: "hvacThermostat",
                attribute: "occupiedCoolingSetpoint",
                valueMin: 16,
                valueMax: 32,
                valueStep: 1,
                scale: 100,
                unit: "°C",
                description: "Target temperature",
            }),
            m.enumLookup({
                name: "system_mode",
                cluster: "hvacThermostat",
                attribute: "systemMode",
                lookup: {
                    off: 0,
                    auto: 1,
                    cool: 3,
                    heat: 4,
                    fan_only: 7,
                    dry: 8,
                },
                description: "Active mode",
            }),
            m.enumLookup({
                name: "mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4703, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    heat: 1,
                    cool: 2,
                    auto: 3,
                    dry: 4,
                    fan_only: 5,
                },
                description: "Modes",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "outdoor_air_temperature",
                cluster: "hvacThermostat",
                attribute: "outdoorTemp",
                scale: 100,
                unit: "°C",
                description: "Outdoor air temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "zb_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: "fanMode",
                valueMin: 1,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed modes: Auto(5), Low(1), Medium(2), Maximum(3)",
            }),
            m.numeric({
                name: "vertical_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 4,
                valueStep: 1,
                description: "Vertical vanes: Stopped(0), Swing(1), Leftmost position(2), Rightmost position(4)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "horizontal_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 7,
                valueStep: 1,
                description: "Horizontal vanes: Stopped(0), Swing(1), Lowest postion(2), Highest position(7)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed: Auto(0), First(1) - Maximum(5)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "smart_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 7,
                valueStep: 1,
                description: "Smart fan speed: Auto (0), Quiet mode (1), First (2) ... Maximum (6), Turbo(7)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "vanes_swing",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4702, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 3,
                valueStep: 1,
                description: "Vanes swing: Stopped(0), Horizontal and vertical swing(1), Horizontal swing(2), Vertical swing(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.enumLookup({
                name: "status_led",
                cluster: "genOnOff",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    normal_mode: 0,
                    disabled_if_no_errors: 1,
                    disabled_untill_reboot: 2,
                    always_disabled: 3,
                    green_untill_reboot: 8,
                    red_untill_reboot: 9,
                },
                description: "Status LED",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "quiet_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4710, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Quiet mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "eco_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4727, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Eco mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "turbo_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4711, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Turbo mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "sleep_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4728, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Sleep mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.enumLookup({
                name: "smart_sleep_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4736, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    disabled: 0,
                    ordinary: 1,
                    for_old: 2,
                    for_young: 3,
                    for_kids: 4,
                },
                description: "Smart sleep mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "ionization",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4720, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Ionization",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.enumLookup({
                name: "smart_eye",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4735, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    disabled: 0,
                    to_person: 1,
                    from_person: 2,
                },
                description: "Smart eye",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "screen_light",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4731, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Screen light",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "beeper",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4730, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Beeper",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "current_compressor_power",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4721, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                description: "Current compressor power",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "target_compressor_power",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4722, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                description: "Target compressor power",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "indoor_heat_exchanger_temperature",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4740, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                unit: "°C",
                description: "Indoor heat exchanger temperature",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "outdoor_heat_exchanger_temperature",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4741, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                unit: "°C",
                description: "Outdoor heat exchanger temperature",
                zigbeeCommandOptions: { manufacturerCode },
            }),
        ],
        fromZigbee: [],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["hvacThermostat", "hvacFanCtrl", "genOnOff"]);
            await reporting.thermostatTemperature(endpoint);
            await reporting.onOff(endpoint);
        },
    },
    {
        zigbeeModel: ["HT-1-ZB-S"],
        model: "HT-1-ZB-S",
        vendor: "ONOKOM",
        description: "AIR HT-1-MB-B (Adapter for household Hitachi systems)",
        ota: true,
        extend: [
            m.enumLookup({
                name: "ac_connected",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4734, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    disconnected: 0,
                    invalid_data_recieved: 1,
                    connected_with_issues: 2,
                    connected: 3,
                },
                description: "AC connected",
                access: "STATE",
            }),
            m.onOff({
                powerOnBehavior: false,
                description: "On/off state",
            }),
            m.numeric({
                name: "current_temperature",
                cluster: "hvacThermostat",
                attribute: "localTemp",
                scale: 100,
                unit: "°C",
                description: "Current temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "target_temperature",
                cluster: "hvacThermostat",
                attribute: "occupiedCoolingSetpoint",
                valueMin: 16,
                valueMax: 32,
                valueStep: 1,
                scale: 100,
                unit: "°C",
                description: "Target temperature",
            }),
            m.enumLookup({
                name: "system_mode",
                cluster: "hvacThermostat",
                attribute: "systemMode",
                lookup: {
                    off: 0,
                    auto: 1,
                    cool: 3,
                    heat: 4,
                    fan_only: 7,
                    dry: 8,
                },
                description: "Active mode",
            }),
            m.enumLookup({
                name: "mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4703, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    heat: 1,
                    cool: 2,
                    auto: 3,
                    dry: 4,
                    fan_only: 5,
                },
                description: "Modes",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "zb_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: "fanMode",
                valueMin: 1,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed modes: Auto(5), Low(1), Medium(2), Maximum(3)",
            }),
            m.numeric({
                name: "fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 3,
                valueStep: 1,
                description: "Fan speed: Auto(0), First(1) - Maximum(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "smart_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 4,
                valueStep: 1,
                description: "Smart fan speed: Auto (0), Low (1) ... Maximum (3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.enumLookup({
                name: "status_led",
                cluster: "genOnOff",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    normal_mode: 0,
                    disabled_if_no_errors: 1,
                    disabled_untill_reboot: 2,
                    always_disabled: 3,
                    green_untill_reboot: 8,
                    red_untill_reboot: 9,
                },
                description: "Status LED",
                zigbeeCommandOptions: { manufacturerCode },
            }),
        ],
        fromZigbee: [],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["hvacThermostat", "hvacFanCtrl", "genOnOff"]);
            await reporting.thermostatTemperature(endpoint);
            await reporting.onOff(endpoint);
        },
    },
    {
        zigbeeModel: ["MD-1-ZB-S"],
        model: "MD-1-ZB-S",
        vendor: "ONOKOM",
        description: "AIR MD-1-MB-B (Adapter for household MDV systems)",
        ota: true,
        extend: [
            m.enumLookup({
                name: "ac_connected",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4734, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    disconnected: 0,
                    invalid_data_recieved: 1,
                    connected_with_issues: 2,
                    connected: 3,
                },
                description: "AC connected",
                access: "STATE",
            }),
            m.onOff({
                powerOnBehavior: false,
                description: "On/off state",
            }),
            m.numeric({
                name: "current_temperature",
                cluster: "hvacThermostat",
                attribute: "localTemp",
                scale: 100,
                unit: "°C",
                description: "Current temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "target_temperature",
                cluster: "hvacThermostat",
                attribute: "occupiedCoolingSetpoint",
                valueMin: 16,
                valueMax: 30,
                valueStep: 0.5,
                scale: 100,
                unit: "°C",
                description: "Target temperature",
            }),
            m.enumLookup({
                name: "system_mode",
                cluster: "hvacThermostat",
                attribute: "systemMode",
                lookup: {
                    off: 0,
                    auto: 1,
                    cool: 3,
                    heat: 4,
                    fan_only: 7,
                    dry: 8,
                },
                description: "Active mode",
            }),
            m.enumLookup({
                name: "mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4703, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    heat: 1,
                    cool: 2,
                    auto: 3,
                    dry: 4,
                    fan_only: 5,
                },
                description: "Modes",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "zb_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: "fanMode",
                valueMin: 1,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed modes: Auto(5), Low(1), Medium(2), Maximum(3)",
            }),
            m.numeric({
                name: "vertical_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 1,
                valueStep: 1,
                description: "Vertical vanes: Stopped(0), Swing(1)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "horizontal_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 1,
                valueStep: 1,
                description: "Horizontal vanes: Stopped(0), Swing(1)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed: Auto(0), First(1) - Maximum(5)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "smart_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 7,
                valueStep: 1,
                description: "Smart fan speed: Auto (0), Quiet mode (1), First (2) ... Maximum (6), Turbo(7)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "vanes_swing",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4702, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 3,
                valueStep: 1,
                description: "Vanes swing: Stopped(0), Horizontal and vertical swing(1), Horizontal swing(2), Vertical swing(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.enumLookup({
                name: "status_led",
                cluster: "genOnOff",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    normal_mode: 0,
                    disabled_if_no_errors: 1,
                    disabled_untill_reboot: 2,
                    always_disabled: 3,
                    green_untill_reboot: 8,
                    red_untill_reboot: 9,
                },
                description: "Status LED",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "quiet_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4710, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Quiet mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "turbo_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4711, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Turbo mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "target_fan_rpm",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4723, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                description: "Target fan rpm",
                zigbeeCommandOptions: { manufacturerCode },
            }),
        ],
        fromZigbee: [],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["hvacThermostat", "hvacFanCtrl", "genOnOff"]);
            await reporting.thermostatTemperature(endpoint);
            await reporting.onOff(endpoint);
        },
    },
    {
        zigbeeModel: ["MD-3-ZB-S"],
        model: "MD-3-ZB-S",
        vendor: "ONOKOM",
        description: "AIR MD-3-MB-B (Adapter for semi-industrial MDV systems)",
        ota: true,
        extend: [
            m.enumLookup({
                name: "ac_connected",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4734, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    disconnected: 0,
                    invalid_data_recieved: 1,
                    connected_with_issues: 2,
                    connected: 3,
                },
                description: "AC connected",
                access: "STATE",
            }),
            m.onOff({
                powerOnBehavior: false,
                description: "On/off state",
            }),
            m.numeric({
                name: "current_temperature",
                cluster: "hvacThermostat",
                attribute: "localTemp",
                scale: 100,
                unit: "°C",
                description: "Current temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "target_temperature",
                cluster: "hvacThermostat",
                attribute: "occupiedCoolingSetpoint",
                valueMin: 16,
                valueMax: 30,
                valueStep: 1,
                scale: 100,
                unit: "°C",
                description: "Target temperature",
            }),
            m.enumLookup({
                name: "system_mode",
                cluster: "hvacThermostat",
                attribute: "systemMode",
                lookup: {
                    off: 0,
                    auto: 1,
                    cool: 3,
                    heat: 4,
                    fan_only: 7,
                    dry: 8,
                },
                description: "Active mode",
            }),
            m.enumLookup({
                name: "mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4703, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    heat: 1,
                    cool: 2,
                    auto: 3,
                    dry: 4,
                    fan_only: 5,
                },
                description: "Modes",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "zb_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: "fanMode",
                valueMin: 1,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed modes: Auto(5), Low(1), Medium(2), Maximum(3)",
            }),
            m.numeric({
                name: "horizontal_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 8,
                valueStep: 1,
                description: "Horizontal vanes: Stopped(0), Swing(1), Lowest postion(2), Highest position(8)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 3,
                valueStep: 1,
                description: "Fan speed: Auto(0), First(1) - Maximum(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "smart_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 4,
                valueStep: 1,
                description: "Smart fan speed: Auto (0), Low (1) ... Maximum (3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "vanes_swing",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4702, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 2,
                valueStep: 2,
                description: "Vanes swing: Stopped(0), Horizontal and vertical swing(1), Horizontal swing(2), Vertical swing(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.enumLookup({
                name: "status_led",
                cluster: "genOnOff",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    normal_mode: 0,
                    disabled_if_no_errors: 1,
                    disabled_untill_reboot: 2,
                    always_disabled: 3,
                    green_untill_reboot: 8,
                    red_untill_reboot: 9,
                },
                description: "Status LED",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "eco_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4727, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Eco mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "indoor_heat_exchanger_temperature",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4740, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                unit: "°C",
                description: "Indoor heat exchanger temperature",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "outdoor_heat_exchanger_temperature",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4741, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                unit: "°C",
                description: "Outdoor heat exchanger temperature",
                zigbeeCommandOptions: { manufacturerCode },
            }),
        ],
        fromZigbee: [],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["hvacThermostat", "hvacFanCtrl", "genOnOff"]);
            await reporting.thermostatTemperature(endpoint);
            await reporting.onOff(endpoint);
        },
    },
    {
        zigbeeModel: ["ME-1-ZB-S"],
        model: "ME-1-ZB-S",
        vendor: "ONOKOM",
        description: "ONOKOM-AIR-ME-1-MB-B (Adapter for household and semi-industrial Mitsubishi Electric systems)",
        ota: true,
        extend: [
            m.enumLookup({
                name: "ac_connected",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4734, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    disconnected: 0,
                    invalid_data_recieved: 1,
                    connected_with_issues: 2,
                    connected: 3,
                },
                description: "AC connected",
                access: "STATE",
            }),
            m.onOff({
                powerOnBehavior: false,
                description: "On/off state",
            }),
            m.numeric({
                name: "current_temperature",
                cluster: "hvacThermostat",
                attribute: "localTemp",
                scale: 100,
                unit: "°C",
                description: "Current temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "target_temperature",
                cluster: "hvacThermostat",
                attribute: "occupiedCoolingSetpoint",
                valueMin: 16,
                valueMax: 31,
                valueStep: 0.5,
                scale: 100,
                unit: "°C",
                description: "Target temperature",
            }),
            m.enumLookup({
                name: "system_mode",
                cluster: "hvacThermostat",
                attribute: "systemMode",
                lookup: {
                    off: 0,
                    auto: 1,
                    cool: 3,
                    heat: 4,
                    fan_only: 7,
                    dry: 8,
                },
                description: "Active mode",
            }),
            m.enumLookup({
                name: "mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4703, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    heat: 1,
                    cool: 2,
                    auto: 3,
                    dry: 4,
                    fan_only: 5,
                },
                description: "Modes",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "zb_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: "fanMode",
                valueMin: 1,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed modes: Auto(5), Low(1), Medium(2), Maximum(3)",
            }),
            m.numeric({
                name: "vertical_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 6,
                valueStep: 1,
                description: "Vertical vanes: Stopped(0), Swing(1), Leftmost position(2), Rightmost position(6)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "horizontal_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 6,
                valueStep: 1,
                description: "Horizontal vanes: Stopped(0), Swing(1), Lowest postion(2), Highest position(6)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 4,
                valueStep: 1,
                description: "Fan speed: Auto(0), First(1) - Maximum(4)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "smart_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 5,
                valueStep: 1,
                description: "Smart fan speed: Auto (0), Quiet mode (1), First (2) ... Maximum (4)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "vanes_swing",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4702, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 3,
                valueStep: 1,
                description: "Vanes swing: Stopped(0), Horizontal and vertical swing(1), Horizontal swing(2), Vertical swing(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.enumLookup({
                name: "status_led",
                cluster: "genOnOff",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    normal_mode: 0,
                    disabled_if_no_errors: 1,
                    disabled_untill_reboot: 2,
                    always_disabled: 3,
                    green_untill_reboot: 8,
                    red_untill_reboot: 9,
                },
                description: "Status LED",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "quiet_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4710, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Quiet mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
        ],
        fromZigbee: [],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["hvacThermostat", "hvacFanCtrl", "genOnOff"]);
            await reporting.thermostatTemperature(endpoint);
            await reporting.onOff(endpoint);
        },
    },
    {
        zigbeeModel: ["TCL-1-ZB-S"],
        model: "TCL-1-ZB-S",
        vendor: "ONOKOM",
        description: "ONOKOM-AIR-TCL-1-MB-B (Adapter for household TCL systems )",
        ota: true,
        extend: [
            m.enumLookup({
                name: "ac_connected",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4734, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    disconnected: 0,
                    invalid_data_recieved: 1,
                    connected_with_issues: 2,
                    connected: 3,
                },
                description: "AC connected",
                access: "STATE",
            }),
            m.onOff({
                powerOnBehavior: false,
                description: "On/off state",
            }),
            m.numeric({
                name: "current_temperature",
                cluster: "hvacThermostat",
                attribute: "localTemp",
                scale: 100,
                unit: "°C",
                description: "Current temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "target_temperature",
                cluster: "hvacThermostat",
                attribute: "occupiedCoolingSetpoint",
                valueMin: 16,
                valueMax: 31,
                valueStep: 1,
                scale: 100,
                unit: "°C",
                description: "Target temperature",
            }),
            m.enumLookup({
                name: "system_mode",
                cluster: "hvacThermostat",
                attribute: "systemMode",
                lookup: {
                    off: 0,
                    auto: 1,
                    cool: 3,
                    heat: 4,
                    fan_only: 7,
                    dry: 8,
                },
                description: "Active mode",
            }),
            m.enumLookup({
                name: "mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4703, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    heat: 1,
                    cool: 2,
                    auto: 3,
                    dry: 4,
                    fan_only: 5,
                },
                description: "Modes",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "outdoor_air_temperature",
                cluster: "hvacThermostat",
                attribute: "outdoorTemp",
                scale: 100,
                unit: "°C",
                description: "Outdoor air temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "zb_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: "fanMode",
                valueMin: 1,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed modes: Auto(5), Low(1), Medium(2), Maximum(3)",
            }),
            m.numeric({
                name: "vertical_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 7,
                valueStep: 1,
                description: "Vertical vanes: Stopped(0), Swing(1), Leftmost position(2), Rightmost position(6)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "horizontal_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 6,
                valueStep: 1,
                description: "Horizontal vanes: Stopped(0), Swing(1), Lowest postion(2), Highest position(6)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed: Auto(0), First(1) - Maximum(5)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "smart_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 7,
                valueStep: 1,
                description: "Smart fan speed: Auto (0), Quiet mode (1), First (2) ... Maximum (6), Turbo(7)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "vanes_swing",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4702, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 3,
                valueStep: 1,
                description: "Vanes swing: Stopped(0), Horizontal and vertical swing(1), Horizontal swing(2), Vertical swing(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.enumLookup({
                name: "status_led",
                cluster: "genOnOff",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    normal_mode: 0,
                    disabled_if_no_errors: 1,
                    disabled_untill_reboot: 2,
                    always_disabled: 3,
                    green_untill_reboot: 8,
                    red_untill_reboot: 9,
                },
                description: "Status LED",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "quiet_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4710, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Quiet mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "eco_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4727, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Eco mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "turbo_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4711, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Turbo mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "sleep_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4728, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Sleep mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "ionization",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4720, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Ionization",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "self_cleaning",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4721, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Self cleaning",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "mold_protection",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4722, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Mold protection",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "heating_8_deg",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4724, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Heating 8 deg",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "gentle_wind",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4725, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Gentle wind",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "screen_light",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4731, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Screen light",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "beeper",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4730, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Beeper",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "current_fan_rpm",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4724, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                description: "Current fan RPM",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "indoor_heat_exchanger_temperature",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4740, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                unit: "°C",
                description: "Indoor heat exchanger temperature",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "outdoor_heat_exchanger_temperature",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4741, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                unit: "°C",
                description: "Outdoor heat exchanger temperature",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "compressor_power_limit",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4720, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                description: "Compressor power limit",
                zigbeeCommandOptions: { manufacturerCode },
            }),
        ],
        fromZigbee: [],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["hvacThermostat", "hvacFanCtrl", "genOnOff"]);
            await reporting.thermostatTemperature(endpoint);
            await reporting.onOff(endpoint);
        },
    },
    {
        zigbeeModel: ["TCL-3-ZB-S"],
        model: "TCL-3-ZB-S",
        vendor: "ONOKOM",
        description: "AIR TCL-3-MB-B (Adapter for semi industrial TCL systems)",
        ota: true,
        extend: [
            m.enumLookup({
                name: "ac_connected",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4734, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    disconnected: 0,
                    invalid_data_recieved: 1,
                    connected_with_issues: 2,
                    connected: 3,
                },
                description: "AC connected",
                access: "STATE",
            }),
            m.onOff({
                powerOnBehavior: false,
                description: "On/off state",
            }),
            m.numeric({
                name: "current_temperature",
                cluster: "hvacThermostat",
                attribute: "localTemp",
                scale: 100,
                unit: "°C",
                description: "Current temperature",
                access: "STATE",
            }),
            m.numeric({
                name: "target_temperature",
                cluster: "hvacThermostat",
                attribute: "occupiedCoolingSetpoint",
                valueMin: 16,
                valueMax: 31,
                valueStep: 0.5,
                scale: 100,
                unit: "°C",
                description: "Target temperature",
            }),
            m.enumLookup({
                name: "system_mode",
                cluster: "hvacThermostat",
                attribute: "systemMode",
                lookup: {
                    off: 0,
                    auto: 1,
                    cool: 3,
                    heat: 4,
                    fan_only: 7,
                    dry: 8,
                },
                description: "Active mode",
            }),
            m.enumLookup({
                name: "mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4703, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    heat: 1,
                    cool: 2,
                    auto: 3,
                    dry: 4,
                    fan_only: 5,
                },
                description: "Modes",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "zb_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: "fanMode",
                valueMin: 1,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed modes: Auto(5), Low(1), Medium(2), Maximum(3)",
            }),
            m.numeric({
                name: "vertical_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 1,
                valueStep: 1,
                description: "Vertical vanes: Stopped(0), Swing(1)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "horizontal_vanes",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 1,
                valueStep: 1,
                description: "Horizontal vanes: Stopped(0), Swing(1)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 5,
                valueStep: 1,
                description: "Fan speed: Auto(0), First(1) - Maximum(5)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "smart_fan_speed",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4701, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 7,
                valueStep: 1,
                description: "Smart fan speed: Auto (0), Quiet mode (1), First (2) ... Maximum (6), Turbo(7)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "vanes_swing",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4702, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                valueMin: 0,
                valueMax: 3,
                valueStep: 1,
                description: "Vanes swing: Stopped(0), Horizontal and vertical swing(1), Horizontal swing(2), Vertical swing(3)",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.enumLookup({
                name: "status_led",
                cluster: "genOnOff",
                attribute: { ID: 0x4700, type: zigbee_herdsman_1.Zcl.DataType.ENUM8 },
                lookup: {
                    normal_mode: 0,
                    disabled_if_no_errors: 1,
                    disabled_untill_reboot: 2,
                    always_disabled: 3,
                    green_untill_reboot: 8,
                    red_untill_reboot: 9,
                },
                description: "Status LED",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "quiet_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4710, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Quiet mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "eco_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4727, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Eco mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "turbo_mode",
                cluster: "hvacFanCtrl",
                attribute: { ID: 0x4711, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Turbo mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "sleep_mode",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4728, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Sleep mode",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.binary({
                name: "screen_light",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4731, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN },
                valueOn: ["ON", 1],
                valueOff: ["OFF", 0],
                description: "Screen light",
                zigbeeCommandOptions: { manufacturerCode },
            }),
            m.numeric({
                name: "indoor_heat_exchanger_temperature",
                cluster: "hvacThermostat",
                attribute: { ID: 0x4740, type: zigbee_herdsman_1.Zcl.DataType.UINT16 },
                access: "STATE",
                valueMin: 0,
                valueMax: 100,
                valueStep: 1,
                unit: "°C",
                description: "Indoor heat exchanger temperature",
                zigbeeCommandOptions: { manufacturerCode },
            }),
        ],
        fromZigbee: [],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["hvacThermostat", "hvacFanCtrl", "genOnOff"]);
            await reporting.thermostatTemperature(endpoint);
            await reporting.onOff(endpoint);
        },
    },
];
//# sourceMappingURL=onokom.js.map