/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.completer;

import java.util.ArrayList;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.impl.util.FileLister;
import org.aesh.io.filter.AllResourceFilter;
import org.aesh.io.filter.ResourceFilter;

public class FileOptionCompleter
implements OptionCompleter<CompleterInvocation> {
    private final ResourceFilter filter;

    public FileOptionCompleter() {
        this(new AllResourceFilter());
    }

    public FileOptionCompleter(ResourceFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("A valid filter must be informed");
        }
        this.filter = filter;
    }

    @Override
    public void complete(CompleterInvocation completerInvocation) {
        ArrayList<String> candidates = new ArrayList<String>();
        int cursor = new FileLister(completerInvocation.getGivenCompleteValue(), completerInvocation.getAeshContext().getCurrentWorkingDirectory()).findMatchingDirectories(candidates);
        boolean appendSpace = false;
        if (candidates.size() == 1 && completerInvocation.getGivenCompleteValue().endsWith((String)candidates.get(0))) {
            appendSpace = true;
        }
        completerInvocation.addAllCompleterValues(candidates);
        completerInvocation.setOffset(completerInvocation.getGivenCompleteValue().length() - cursor);
        completerInvocation.setAppendSpace(appendSpace);
    }

    public ResourceFilter getFilter() {
        return this.filter;
    }
}

