/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionManager;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.Service;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Vector;

public class ActionStatusService
implements Service {
    private static RecoveryStore _recoveryStore = null;

    public ActionStatusService() {
        if (_recoveryStore == null) {
            _recoveryStore = StoreManager.getRecoveryStore();
        }
    }

    public int getTransactionStatus(String transactionType, String strUid) {
        int action_status = 9;
        if (strUid != null) {
            Uid tranUid = new Uid(strUid);
            action_status = transactionType == null || transactionType.equals("") ? this.getTranStatus(tranUid) : this.getActionStatus(tranUid, transactionType);
        }
        return action_status;
    }

    @Override
    public void doWork(InputStream is, OutputStream os) throws IOException {
        block7: {
            BufferedReader in = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            PrintWriter out = new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
            try {
                out.println(Utility.intToHexString(Utility.getpid()));
                out.flush();
                String rmStatus = in.readLine();
                if (!rmStatus.equals("OK")) break block7;
                while (true) {
                    String transactionType = null;
                    String strUid = null;
                    try {
                        transactionType = in.readLine();
                        strUid = in.readLine();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (transactionType == null && strUid == null) {
                        return;
                    }
                    int status = this.getTransactionStatus(transactionType, strUid);
                    String strStatus = Integer.toString(status);
                    out.println(strStatus);
                    out.flush();
                    tsLogger.i18NLogger.info_recovery_ActionStatusService_1(transactionType, strUid, strStatus);
                }
            }
            catch (IOException ex) {
                tsLogger.i18NLogger.warn_recovery_ActionStatusService_7();
            }
            catch (Exception ex) {
                tsLogger.i18NLogger.warn_recovery_ActionStatusService_2(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getActionStatus(Uid tranUid, String transactionType) {
        int action_status = 9;
        try {
            BasicAction basic_action = null;
            ActionManager actionManager = ActionManager.manager();
            synchronized (actionManager) {
                basic_action = ActionManager.manager().get(tranUid);
            }
            action_status = basic_action != null ? basic_action.status() : this.getObjectStoreStatus(tranUid, transactionType);
        }
        catch (Exception ex) {
            tsLogger.i18NLogger.warn_recovery_ActionStatusService_3(ex);
        }
        return action_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTranStatus(Uid tranUid) {
        int action_status = 9;
        try {
            BasicAction basic_action = null;
            ActionManager actionManager = ActionManager.manager();
            synchronized (actionManager) {
                basic_action = ActionManager.manager().get(tranUid);
            }
            action_status = basic_action != null ? basic_action.status() : this.getOsStatus(tranUid);
        }
        catch (Exception ex) {
            tsLogger.i18NLogger.warn_recovery_ActionStatusService_3(ex);
        }
        return action_status;
    }

    private int getOsStatus(Uid tranUid) {
        Vector<String> matchingUidTypeVector;
        Vector<Uid> matchingUidVector;
        int action_status;
        block14: {
            action_status = 9;
            matchingUidVector = new Vector<Uid>();
            matchingUidTypeVector = new Vector<String>();
            try {
                InputObjectState types = new InputObjectState();
                if (_recoveryStore.allTypes(types)) {
                    String theTypeName = null;
                    boolean endOfList = false;
                    while (!endOfList) {
                        theTypeName = types.unpackString();
                        if (theTypeName.compareTo("") == 0) {
                            endOfList = true;
                            continue;
                        }
                        InputObjectState uids = new InputObjectState();
                        boolean endOfUids = false;
                        if (_recoveryStore.allObjUids(theTypeName, uids)) {
                            Uid theUid = null;
                            while (!endOfUids) {
                                theUid = UidHelper.unpackFrom(uids);
                                if (theUid.equals(Uid.nullUid())) {
                                    endOfUids = true;
                                    continue;
                                }
                                if (!theUid.equals(tranUid)) continue;
                                matchingUidVector.addElement(tranUid);
                                matchingUidTypeVector.addElement(theTypeName);
                                tsLogger.i18NLogger.info_recovery_ActionStatusService_4(tranUid);
                            }
                            continue;
                        }
                        return action_status;
                    }
                    break block14;
                }
                return action_status;
            }
            catch (Exception ex) {
                tsLogger.i18NLogger.warn_recovery_ActionStatusService_5(tranUid, ex);
                return action_status;
            }
        }
        int uidVectorSize = matchingUidVector.size();
        int first_index = 0;
        if (uidVectorSize == 0) {
            action_status = 4;
        } else if (uidVectorSize == 1) {
            Uid uid = (Uid)matchingUidVector.get(first_index);
            String typeName = (String)matchingUidTypeVector.get(first_index);
            action_status = this.getObjectStoreStatus(uid, typeName);
        } else if (uidVectorSize > 1) {
            Uid rootUid = (Uid)matchingUidVector.get(first_index);
            String rootTypeName = (String)matchingUidTypeVector.get(first_index);
            for (int index = first_index + 1; index < uidVectorSize; ++index) {
                String typeName = (String)matchingUidTypeVector.get(index);
                if (typeName.length() >= rootTypeName.length()) continue;
                rootTypeName = typeName;
                rootUid = (Uid)matchingUidVector.get(index);
            }
            action_status = this.getObjectStoreStatus(rootUid, rootTypeName);
        }
        return action_status;
    }

    private int getObjectStoreStatus(Uid tranUid, String transactionType) {
        int action_status = 9;
        try {
            int osState = _recoveryStore.currentState(tranUid, transactionType);
            switch (osState) {
                case 1: {
                    action_status = 7;
                    break;
                }
                case -1: {
                    action_status = 4;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    action_status = 5;
                }
            }
        }
        catch (Exception ex) {
            tsLogger.i18NLogger.warn_recovery_ActionStatusService_6(ex);
        }
        return action_status;
    }
}

