/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.CounterMetric;
import co.elastic.logstash.api.Event;
import co.elastic.logstash.api.Metric;
import co.elastic.logstash.api.NamespacedMetric;
import co.elastic.logstash.api.PluginConfigSpec;
import co.elastic.logstash.api.TimerMetric;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.logstash.instrument.metrics.MetricKeys;

public class JavaCodecDelegator
implements Codec {
    private final Codec codec;
    protected final CounterMetric encodeMetricIn;
    protected final TimerMetric encodeMetricTime;
    protected final CounterMetric decodeMetricIn;
    protected final CounterMetric decodeMetricOut;
    protected final TimerMetric decodeMetricTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaCodecDelegator(Context context, Codec codec) {
        this.codec = codec;
        NamespacedMetric metric = context.getMetric(codec);
        Metric metric2 = metric.root();
        synchronized (metric2) {
            metric.gauge(MetricKeys.NAME_KEY.asJavaString(), codec.getName());
            NamespacedMetric encodeMetric = metric.namespace(MetricKeys.ENCODE_KEY.asJavaString());
            this.encodeMetricIn = encodeMetric.counter(MetricKeys.WRITES_IN_KEY.asJavaString());
            this.encodeMetricTime = encodeMetric.timer(MetricKeys.DURATION_IN_MILLIS_KEY.asJavaString());
            NamespacedMetric decodeMetric = metric.namespace(MetricKeys.DECODE_KEY.asJavaString());
            this.decodeMetricIn = decodeMetric.counter(MetricKeys.WRITES_IN_KEY.asJavaString());
            this.decodeMetricOut = decodeMetric.counter(MetricKeys.OUT_KEY.asJavaString());
            this.decodeMetricTime = decodeMetric.timer(MetricKeys.DURATION_IN_MILLIS_KEY.asJavaString());
        }
    }

    @Override
    public void decode(ByteBuffer buffer, Consumer<Map<String, Object>> eventConsumer) {
        this.decodeMetricIn.increment();
        this.decodeMetricTime.time(() -> this.codec.decode(buffer, event -> {
            this.decodeMetricOut.increment();
            eventConsumer.accept((Map<String, Object>)event);
        }));
    }

    @Override
    public void flush(ByteBuffer buffer, Consumer<Map<String, Object>> eventConsumer) {
        this.decodeMetricIn.increment();
        this.decodeMetricTime.time(() -> this.codec.flush(buffer, event -> {
            this.decodeMetricOut.increment();
            eventConsumer.accept((Map<String, Object>)event);
        }));
    }

    @Override
    public void encode(Event event, OutputStream out) throws IOException {
        this.encodeMetricIn.increment();
        this.encodeMetricTime.time(() -> this.codec.encode(event, out));
    }

    @Override
    public Codec cloneCodec() {
        return this.codec.cloneCodec();
    }

    @Override
    public Collection<PluginConfigSpec<?>> configSchema() {
        return this.codec.configSchema();
    }

    @Override
    public String getName() {
        return this.codec.getName();
    }

    @Override
    public String getId() {
        return this.codec.getId();
    }
}

