/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import java.util.List;
import java.util.Objects;
import org.logstash.settings.BaseSetting;
import org.logstash.settings.Setting;

abstract class SettingDelegator<T>
implements Setting<T> {
    private BaseSetting<T> delegate;

    SettingDelegator(BaseSetting<T> delegate) {
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
    }

    BaseSetting<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public T value() {
        return this.delegate.value();
    }

    @Override
    public boolean isSet() {
        return this.delegate.isSet();
    }

    @Override
    public boolean isStrict() {
        return this.delegate.isStrict();
    }

    @Override
    public void setSafely(T newValue) {
        this.delegate.setSafely(newValue);
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public void validateValue() {
        this.delegate.validateValue();
    }

    @Override
    public T getDefault() {
        return this.delegate.getDefault();
    }

    @Override
    public void format(List<String> output) {
        this.delegate.format(output);
    }

    @Override
    public void validate(T input) {
        this.delegate.validate(input);
    }
}

