/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.html;

import com.opensymphony.module.sitemesh.html.BasicRule;
import com.opensymphony.module.sitemesh.html.Tag;
import com.opensymphony.module.sitemesh.html.util.CharArray;

public abstract class BlockExtractingRule
extends BasicRule {
    private boolean includeEnclosingTags;
    private boolean seenOpeningTag;

    protected BlockExtractingRule(boolean includeEnclosingTags, String acceptableTagName) {
        super(acceptableTagName);
        this.includeEnclosingTags = includeEnclosingTags;
    }

    protected BlockExtractingRule(boolean includeEnclosingTags) {
        this.includeEnclosingTags = includeEnclosingTags;
    }

    public void process(Tag tag) {
        if (tag.getType() == 1) {
            if (this.includeEnclosingTags) {
                tag.writeTo(this.context.currentBuffer());
            }
            this.context.pushBuffer(this.createBuffer());
            this.start(tag);
            this.seenOpeningTag = true;
        } else if (tag.getType() == 2 && this.seenOpeningTag) {
            this.end(tag);
            this.context.popBuffer();
            if (this.includeEnclosingTags) {
                tag.writeTo(this.context.currentBuffer());
            }
        }
    }

    protected void start(Tag tag) {
    }

    protected void end(Tag tag) {
    }

    protected CharArray createBuffer() {
        return new CharArray(512);
    }
}

