/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import jakarta.servlet.ServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LazySet;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.MessageException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.common.messaging.context.navigate.SAMLEntityIDFunction;
import org.opensaml.saml.common.messaging.context.navigate.SAMLMessageInfoContextIDFunction;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.profile.impl.ValidateAssertions;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.messaging.ServletRequestX509CredentialAdapter;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.signature.support.SignatureValidationParametersCriterion;
import org.slf4j.Logger;

public class DefaultAssertionValidationContextBuilder
implements Function<ValidateAssertions.AssertionValidationInput, ValidationContext> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultAssertionValidationContextBuilder.class);
    @Nullable
    private Function<ProfileRequestContext, Duration> clockSkew;
    @Nullable
    private Function<ProfileRequestContext, Duration> lifetime;
    @Nullable
    private Function<Pair<ProfileRequestContext, Assertion>, CriteriaSet> signatureCriteriaSetFunction;
    @Nonnull
    private Predicate<ProfileRequestContext> signatureRequired = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> checkAddress;
    @Nullable
    private Function<ProfileRequestContext, Duration> maximumTimeSinceAuthn;
    @Nonnull
    private Predicate<ProfileRequestContext> includeSelfEntityIDAsRecipient = PredicateSupport.alwaysFalse();
    @Nullable
    private Function<ProfileRequestContext, Set<String>> additionalAudiences;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> validIssuers;
    @Nullable
    private Function<ProfileRequestContext, String> inResponseTo;
    @Nonnull
    private Predicate<ProfileRequestContext> inResponseToRequired;
    @Nonnull
    private Predicate<ProfileRequestContext> recipientRequired;
    @Nonnull
    private Predicate<ProfileRequestContext> notBeforeRequired;
    @Nonnull
    private Predicate<ProfileRequestContext> notOnOrAfterRequired;
    @Nonnull
    private Predicate<ProfileRequestContext> addressRequired;
    @Nonnull
    private Set<QName> requiredConditions;
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersLookupStrategy;

    public DefaultAssertionValidationContextBuilder() {
        this.checkAddress = PredicateSupport.alwaysTrue();
        this.inResponseTo = new DefaultValidInResponseToLookupFunction();
        this.inResponseToRequired = PredicateSupport.alwaysFalse();
        this.recipientRequired = PredicateSupport.alwaysFalse();
        this.notOnOrAfterRequired = PredicateSupport.alwaysFalse();
        this.notBeforeRequired = PredicateSupport.alwaysFalse();
        this.addressRequired = PredicateSupport.alwaysFalse();
        this.requiredConditions = CollectionSupport.emptySet();
        this.validIssuers = new DefaultValidIssuersLookupFunction();
        this.securityParametersLookupStrategy = new ChildContextLookup(SecurityParametersContext.class).compose(new InboundMessageContextLookup());
    }

    @Nullable
    public Function<ProfileRequestContext, Duration> getClockSkew() {
        return this.clockSkew;
    }

    public void setClockSkew(@Nullable Duration skew) {
        this.clockSkew = FunctionSupport.constant(skew);
    }

    public void setClockSkewLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.clockSkew = strategy;
    }

    @Nullable
    public Function<ProfileRequestContext, Duration> getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(@Nullable Duration duration) {
        this.lifetime = FunctionSupport.constant(duration);
    }

    public void setLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.lifetime = strategy;
    }

    @Nonnull
    public Function<ProfileRequestContext, SecurityParametersContext> getSecurityParametersLookupStrategy() {
        return this.securityParametersLookupStrategy;
    }

    public void setSecurityParametersLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.securityParametersLookupStrategy = Constraint.isNotNull(strategy, "SecurityParametersContext lookup strategy was null");
    }

    @Nonnull
    public Set<QName> getRequiredConditions() {
        return this.requiredConditions;
    }

    public void setRequiredConditions(@Nullable Set<QName> conditions) {
        this.requiredConditions = conditions != null ? conditions.stream().filter(Objects::nonNull).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet())).get() : CollectionSupport.emptySet();
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getIncludeSelfEntityIDAsRecipient() {
        return this.includeSelfEntityIDAsRecipient;
    }

    public void setIncludeSelfEntityIDAsRecipient(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.includeSelfEntityIDAsRecipient = Constraint.isNotNull(predicate, "Signature required predicate was null");
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getSignatureRequired() {
        return this.signatureRequired;
    }

    public void setSignatureRequired(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signatureRequired = Constraint.isNotNull(predicate, "Signature required predicate was null");
    }

    public void setInResponseTo(@Nullable Function<ProfileRequestContext, String> function) {
        this.inResponseTo = function;
    }

    @Nullable
    public Function<ProfileRequestContext, String> getInResponseTo() {
        return this.inResponseTo;
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getInResponseToRequired() {
        return this.inResponseToRequired;
    }

    public void setInResponseToRequired(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.inResponseToRequired = Constraint.isNotNull(predicate, "InResponseTo required predicate was null");
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getRecipientRequired() {
        return this.recipientRequired;
    }

    public void setRecipientRequired(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.recipientRequired = Constraint.isNotNull(predicate, "Recipient required predicate was null");
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getNotBeforeRequired() {
        return this.notBeforeRequired;
    }

    public void setNotBeforeRequired(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.notBeforeRequired = Constraint.isNotNull(predicate, "NotBefore required predicate was null");
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getNotOnOrAfterRequired() {
        return this.notOnOrAfterRequired;
    }

    public void setNotOnOrAfterRequired(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.notOnOrAfterRequired = Constraint.isNotNull(predicate, "NotOnOrAfter required predicate was null");
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getAddressRequired() {
        return this.addressRequired;
    }

    public void setAddressRequired(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.addressRequired = Constraint.isNotNull(predicate, "Address required predicate was null");
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getCheckAddress() {
        return this.checkAddress;
    }

    public void setCheckAddress(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.checkAddress = Constraint.isNotNull(predicate, "Check address predicate was null");
    }

    @Nullable
    public Function<ProfileRequestContext, Set<String>> getAdditionalAudiences() {
        return this.additionalAudiences;
    }

    public void setAdditionalAudiences(@Nullable Function<ProfileRequestContext, Set<String>> function) {
        this.additionalAudiences = function;
    }

    @Nonnull
    public Function<ProfileRequestContext, Set<String>> getValidIssuers() {
        return this.validIssuers;
    }

    public void setValidIssuers(@Nonnull Function<ProfileRequestContext, Set<String>> function) {
        this.validIssuers = Constraint.isNotNull(function, "Valied Issuers function was null");
    }

    @Nullable
    public Function<ProfileRequestContext, Duration> getMaximumTimeSinceAuthn() {
        return this.maximumTimeSinceAuthn;
    }

    public void setMaximumTimeSinceAuthn(@Nullable Function<ProfileRequestContext, Duration> function) {
        this.maximumTimeSinceAuthn = function;
    }

    @Nullable
    public Function<Pair<ProfileRequestContext, Assertion>, CriteriaSet> getSignatureCriteriaSetFunction() {
        return this.signatureCriteriaSetFunction;
    }

    public void setSignatureCriteriaSetFunction(@Nullable Function<Pair<ProfileRequestContext, Assertion>, CriteriaSet> function) {
        this.signatureCriteriaSetFunction = function;
    }

    @Override
    @Nullable
    public ValidationContext apply(@Nullable ValidateAssertions.AssertionValidationInput input) {
        if (input == null) {
            return null;
        }
        return new ValidationContext(this.buildStaticParameters(input));
    }

    @Nonnull
    protected Map<String, Object> buildStaticParameters(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        Function<ProfileRequestContext, Duration> lifetimeFunc;
        TreeMap<String, Object> staticParams = new TreeMap<String, Object>();
        Function<ProfileRequestContext, Duration> skewFunc = this.getClockSkew();
        if (skewFunc != null) {
            staticParams.put("saml2.ClockSkew", skewFunc.apply(input.getProfileRequestContext()));
        }
        if ((lifetimeFunc = this.getLifetime()) != null) {
            staticParams.put("saml2.Lifetime", lifetimeFunc.apply(input.getProfileRequestContext()));
        }
        staticParams.put("saml2.ValidIssuers", this.getValidIssuers().apply(input.getProfileRequestContext()));
        this.populateSignatureParameters(staticParams, input);
        this.populateConditionsParameters(staticParams, input);
        Set<InetAddress> validAddresses = this.getValidAddresses(input);
        Boolean checkAddressEnabled = this.getCheckAddress().test(input.getProfileRequestContext());
        assert (checkAddressEnabled != null);
        this.populateSubjectConfirmationParameters(staticParams, input, validAddresses, checkAddressEnabled);
        this.populateStatementParams(staticParams, input, validAddresses, checkAddressEnabled);
        this.log.trace("Built static parameters map: {}", staticParams);
        return staticParams;
    }

    private void populateSignatureParameters(@Nonnull Map<String, Object> staticParams, @Nonnull ValidateAssertions.AssertionValidationInput input) {
        SignatureValidationParameters valParams;
        staticParams.put("saml2.SignatureRequired", this.getSignatureRequired().test(input.getProfileRequestContext()));
        staticParams.put("saml2.SignatureValidationCriteriaSet", this.getSignatureCriteriaSet(input));
        SecurityParametersContext securityParameters = this.getSecurityParametersLookupStrategy().apply(input.getProfileRequestContext());
        SignatureValidationParameters signatureValidationParameters = valParams = securityParameters != null ? securityParameters.getSignatureValidationParameters() : null;
        if (valParams != null) {
            staticParams.put("saml2.SignatureValidationTrustEngine", valParams.getSignatureTrustEngine());
        }
    }

    private void populateConditionsParameters(@Nonnull Map<String, Object> staticParams, @Nonnull ValidateAssertions.AssertionValidationInput input) {
        staticParams.put("saml2.Conditions.RequiredConditions", this.getRequiredConditions(input));
        staticParams.put("saml2.Conditions.ValidAudiences", this.getValidAudiences(input));
    }

    private void populateSubjectConfirmationParameters(@Nonnull Map<String, Object> staticParams, @Nonnull ValidateAssertions.AssertionValidationInput input, @Nonnull Set<InetAddress> validAddresses, @Nonnull Boolean checkAddressEnabled) {
        PublicKey attesterPublicKey;
        X509Certificate attesterCertificate = this.getAttesterCertificate(input);
        if (attesterCertificate != null) {
            staticParams.put("saml2.SubjectConfirmation.HoK.PresenterCertificate", attesterCertificate);
        }
        if ((attesterPublicKey = this.getAttesterPublicKey(input)) != null) {
            staticParams.put("saml2.SubjectConfirmation.HoK.PresenterKey", attesterPublicKey);
        }
        staticParams.put("saml2.SubjectConfirmation.RecipientRequired", this.getRecipientRequired().test(input.getProfileRequestContext()));
        staticParams.put("saml2.SubjectConfirmation.ValidRecipients", this.getValidRecipients(input));
        staticParams.put("saml2.SubjectConfirmation.AddressRequired", this.getAddressRequired().test(input.getProfileRequestContext()));
        staticParams.put("saml2.SubjectConfirmation.ValidAddresses", validAddresses);
        staticParams.put("saml2.SubjectConfirmation.CheckAddress", checkAddressEnabled);
        staticParams.put("saml2.SubjectConfirmation.InResponseToRequired", this.getInResponseToRequired().test(input.getProfileRequestContext()));
        Function<ProfileRequestContext, String> irtFunc = this.getInResponseTo();
        if (irtFunc != null) {
            staticParams.put("saml2.SubjectConfirmation.ValidInResponseTo", irtFunc.apply(input.getProfileRequestContext()));
        }
        staticParams.put("saml2.SubjectConfirmation.NotBeforeRequired", this.getNotBeforeRequired().test(input.getProfileRequestContext()));
        staticParams.put("saml2.SubjectConfirmation.NoOnOrAfterRequired", this.getNotOnOrAfterRequired().test(input.getProfileRequestContext()));
    }

    private void populateStatementParams(@Nonnull Map<String, Object> staticParams, @Nonnull ValidateAssertions.AssertionValidationInput input, @Nonnull Set<InetAddress> validAddresses, @Nonnull Boolean checkAddressEnabled) {
        staticParams.put("saml2.Statement.Authn.SubjectLocality.ValidAddresses", validAddresses);
        staticParams.put("saml2.Statement.Authn.SubjectLocality.CheckAddress", checkAddressEnabled);
        Function<ProfileRequestContext, Duration> maxTimeFunc = this.getMaximumTimeSinceAuthn();
        if (maxTimeFunc != null) {
            staticParams.put("saml2.Statement.Authn.MaxTimeSinceAuthn", maxTimeFunc.apply(input.getProfileRequestContext()));
        }
    }

    @Nonnull
    protected Set<QName> getRequiredConditions(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        return this.getRequiredConditions();
    }

    @Nonnull
    protected CriteriaSet getSignatureCriteriaSet(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        MessageContext inboundContext;
        String issuer;
        Issuer issuerObj;
        CriteriaSet dynamicCriteria;
        CriteriaSet criteriaSet = new CriteriaSet();
        Function<Pair<ProfileRequestContext, Assertion>, CriteriaSet> sigCritFunc = this.getSignatureCriteriaSetFunction();
        if (sigCritFunc != null && (dynamicCriteria = sigCritFunc.apply(new Pair<ProfileRequestContext, Assertion>(input.getProfileRequestContext(), input.getAssertion()))) != null) {
            criteriaSet.addAll(dynamicCriteria);
        }
        if (!criteriaSet.contains(EntityIdCriterion.class) && (issuerObj = input.getAssertion().getIssuer()) != null && (issuer = StringSupport.trimOrNull(issuerObj.getValue())) != null) {
            this.log.debug("Adding internally-generated EntityIdCriterion with value of: {}", (Object)issuer);
            criteriaSet.add(new EntityIdCriterion(issuer));
        }
        if (!criteriaSet.contains(UsageCriterion.class)) {
            this.log.debug("Adding internally-generated UsageCriterion with value of: {}", (Object)UsageType.SIGNING);
            criteriaSet.add(new UsageCriterion(UsageType.SIGNING));
        }
        if ((inboundContext = input.getProfileRequestContext().getInboundMessageContext()) != null) {
            this.populateSignatureCriteriaFromInboundContext(criteriaSet, inboundContext);
        }
        this.log.debug("Resolved Signature validation CriteriaSet: {}", (Object)criteriaSet);
        return criteriaSet;
    }

    protected void populateSignatureCriteriaFromInboundContext(@Nonnull CriteriaSet criteriaSet, @Nonnull MessageContext inboundContext) {
        SignatureValidationParameters valParams;
        SecurityParametersContext secParamsContext;
        String protocol;
        SAMLPeerEntityContext peerContext = inboundContext.getSubcontext(SAMLPeerEntityContext.class);
        if (peerContext != null) {
            QName role;
            RoleDescriptor role2;
            SAMLMetadataContext metadataContext;
            if (!criteriaSet.contains(RoleDescriptorCriterion.class) && (metadataContext = peerContext.getSubcontext(SAMLMetadataContext.class)) != null && (role2 = metadataContext.getRoleDescriptor()) != null) {
                criteriaSet.add(new RoleDescriptorCriterion(role2));
            }
            if (!criteriaSet.contains(EntityRoleCriterion.class) && (role = peerContext.getRole()) != null) {
                criteriaSet.add(new EntityRoleCriterion(role));
            }
        }
        SAMLProtocolContext protocolContext = inboundContext.getSubcontext(SAMLProtocolContext.class);
        if (!criteriaSet.contains(ProtocolCriterion.class) && protocolContext != null && (protocol = protocolContext.getProtocol()) != null) {
            criteriaSet.add(new ProtocolCriterion(protocol));
        }
        if (!criteriaSet.contains(SignatureValidationParametersCriterion.class) && (secParamsContext = inboundContext.getSubcontext(SecurityParametersContext.class)) != null && (valParams = secParamsContext.getSignatureValidationParameters()) != null) {
            criteriaSet.add(new SignatureValidationParametersCriterion(valParams));
        }
    }

    @Nullable
    protected X509Certificate getAttesterCertificate(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        try {
            ServletRequestX509CredentialAdapter credential = new ServletRequestX509CredentialAdapter((ServletRequest)input.getHttpServletRequest());
            return credential.getEntityCertificate();
        }
        catch (SecurityException e) {
            this.log.debug("Peer TLS X.509 certificate was not present. Holder-of-key proof-of-possession via client TLS cert will not be possible");
            return null;
        }
    }

    @Nullable
    protected PublicKey getAttesterPublicKey(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        return null;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected Set<String> getValidRecipients(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        String selfEntityID;
        LazySet<String> validRecipients = new LazySet<String>();
        try {
            String endpoint = SAMLBindingSupport.getActualReceiverEndpointURI(input.getProfileRequestContext().ensureInboundMessageContext(), input.getHttpServletRequest());
            if (endpoint != null) {
                validRecipients.add(endpoint);
            }
        }
        catch (MessageException e) {
            this.log.warn("Attempt to resolve recipient endpoint failed", (Throwable)e);
        }
        if (this.getIncludeSelfEntityIDAsRecipient().test(input.getProfileRequestContext()) && (selfEntityID = this.getSelfEntityID(input)) != null) {
            validRecipients.add(selfEntityID);
        }
        this.log.debug("Resolved valid subject confirmation recipients set: {}", validRecipients);
        return validRecipients;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected Set<InetAddress> getValidAddresses(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        try {
            LazySet<InetAddress> validAddresses = new LazySet<InetAddress>();
            InetAddress[] addresses = null;
            String attesterIPAddress = this.getAttesterIPAddress(input);
            this.log.debug("Saw attester IP address: {}", (Object)attesterIPAddress);
            if (attesterIPAddress != null) {
                addresses = InetAddress.getAllByName(attesterIPAddress);
                validAddresses.addAll((Collection<InetAddress>)Arrays.asList(addresses));
                this.log.debug("Resolved valid subject confirmation InetAddress set: {}", validAddresses);
                return validAddresses;
            }
            this.log.warn("Could not determine attester IP address. Validation of Assertion may or may not succeed");
            return CollectionSupport.emptySet();
        }
        catch (UnknownHostException e) {
            this.log.warn("Processing of attester IP address failed. Validation of Assertion may or may not succeed", (Throwable)e);
            return CollectionSupport.emptySet();
        }
    }

    @Nullable
    protected String getAttesterIPAddress(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        return HttpServletSupport.getRemoteAddr((ServletRequest)input.getHttpServletRequest());
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected Set<String> getValidAudiences(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        Set<String> additional;
        Function<ProfileRequestContext, Set<String>> audFunc;
        LazySet<String> validAudiences = new LazySet<String>();
        String selfEntityID = this.getSelfEntityID(input);
        if (selfEntityID != null) {
            validAudiences.add(selfEntityID);
        }
        if ((audFunc = this.getAdditionalAudiences()) != null && (additional = audFunc.apply(input.getProfileRequestContext())) != null) {
            validAudiences.addAll((Collection<String>)additional);
        }
        this.log.debug("Resolved valid audiences set: {}", validAudiences);
        return validAudiences;
    }

    @Nullable
    protected String getSelfEntityID(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        SAMLSelfEntityContext selfContext = input.getProfileRequestContext().ensureInboundMessageContext().getSubcontext(SAMLSelfEntityContext.class);
        if (selfContext != null) {
            return selfContext.getEntityId();
        }
        return null;
    }

    public static class DefaultValidInResponseToLookupFunction
    implements Function<ProfileRequestContext, String> {
        @Nonnull
        private Function<MessageContext, String> delegate = new SAMLMessageInfoContextIDFunction().compose(new ChildContextLookup(SAMLMessageInfoContext.class, true).compose(new MessageContextLookup(MessageContextLookup.Direction.OUTBOUND)));

        @Override
        @Nullable
        public String apply(@Nullable ProfileRequestContext prc) {
            if (prc == null || prc.getInboundMessageContext() == null) {
                return null;
            }
            return this.delegate.apply(prc.getInboundMessageContext());
        }
    }

    public static class DefaultValidIssuersLookupFunction
    implements Function<ProfileRequestContext, Set<String>> {
        @Nonnull
        private Function<MessageContext, String> delegate = new SAMLEntityIDFunction().compose(new ChildContextLookup(SAMLPeerEntityContext.class).compose(new MessageContextLookup(MessageContextLookup.Direction.OUTBOUND)));

        @Override
        @Nullable
        @Unmodifiable
        @NotLive
        public Set<String> apply(@Nullable ProfileRequestContext prc) {
            if (prc == null || prc.getInboundMessageContext() == null) {
                return null;
            }
            String entityID = this.delegate.apply(prc.getInboundMessageContext());
            if (entityID != null) {
                return CollectionSupport.singleton(entityID);
            }
            return CollectionSupport.emptySet();
        }
    }
}

