/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.executors;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.SearchHit;
import org.opensearch.searchrelevance.dao.EvaluationResultDao;
import org.opensearch.searchrelevance.dao.ExperimentVariantDao;
import org.opensearch.searchrelevance.executors.ExperimentTaskContext;
import org.opensearch.searchrelevance.metrics.EvaluationMetrics;
import org.opensearch.searchrelevance.model.AsyncStatus;
import org.opensearch.searchrelevance.model.EvaluationResult;
import org.opensearch.searchrelevance.model.ExperimentType;
import org.opensearch.searchrelevance.model.ExperimentVariant;
import org.opensearch.searchrelevance.utils.TimeUtils;

public class SearchResponseProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchResponseProcessor.class);
    private final EvaluationResultDao evaluationResultDao;
    private final ExperimentVariantDao experimentVariantDao;

    public void processSearchResponse(SearchResponse response, ExperimentVariant experimentVariant, String experimentId, String searchConfigId, String queryText, int size, List<String> judgmentIds, Map<String, String> docIdToScores, String evaluationId, ExperimentTaskContext taskContext, String scheduledRunId) {
        if (taskContext.getHasFailure().get()) {
            return;
        }
        try {
            if (response.getHits().getTotalHits().value() == 0L) {
                this.handleNoHits(experimentVariant, experimentId, searchConfigId, evaluationId, taskContext);
                return;
            }
            SearchHit[] hits = response.getHits().getHits();
            List<String> docIds = Arrays.stream(hits).map(SearchHit::getId).collect(Collectors.toList());
            List<Map<String, Object>> metrics = EvaluationMetrics.calculateEvaluationMetrics(docIds, docIdToScores, size);
            String experimentVariantParameters = experimentVariant.getType() == ExperimentType.HYBRID_OPTIMIZER ? experimentVariant.getTextualParameters() : null;
            EvaluationResult evaluationResult = new EvaluationResult(evaluationId, TimeUtils.getTimestamp(), searchConfigId, queryText, judgmentIds, docIds, metrics, experimentId, experimentVariant.getId(), experimentVariantParameters, scheduledRunId);
            this.evaluationResultDao.putEvaluationResultEfficient(evaluationResult, ActionListener.wrap(success -> this.updateExperimentVariant(experimentVariant, experimentId, searchConfigId, evaluationId, taskContext), error -> this.handleTaskFailure(experimentVariant, (Exception)error, taskContext)));
        }
        catch (Exception e) {
            this.handleTaskFailure(experimentVariant, e, taskContext);
        }
    }

    private void handleNoHits(ExperimentVariant experimentVariant, String experimentId, String searchConfigId, String evaluationId, ExperimentTaskContext taskContext) {
        log.warn("No hits found for search config: {} and variant: {}", (Object)searchConfigId, (Object)experimentVariant.getId());
        ExperimentVariant noHitsVariant = new ExperimentVariant(experimentVariant.getId(), TimeUtils.getTimestamp(), experimentVariant.getType(), AsyncStatus.COMPLETED, experimentId, experimentVariant.getParameters(), Map.of("evaluationResultId", evaluationId, "details", "no search hits found"));
        this.experimentVariantDao.putExperimentVariantEfficient(noHitsVariant, ActionListener.wrap(success -> {
            log.debug("Persisted no-hits variant: {}", (Object)experimentVariant.getId());
            taskContext.completeVariantFailure();
        }, error -> this.handleTaskFailure(experimentVariant, (Exception)error, taskContext)));
    }

    private void updateExperimentVariant(ExperimentVariant experimentVariant, String experimentId, String searchConfigId, String evaluationId, ExperimentTaskContext taskContext) {
        ExperimentVariant completedVariant = new ExperimentVariant(experimentVariant.getId(), TimeUtils.getTimestamp(), experimentVariant.getType(), AsyncStatus.COMPLETED, experimentId, experimentVariant.getParameters(), Map.of("evaluationResultId", evaluationId));
        taskContext.scheduleVariantWrite(completedVariant, evaluationId, true);
        log.debug("Scheduled write for completed experiment variant: {}", (Object)experimentVariant.getId());
        taskContext.completeVariantSuccess();
    }

    private void handleTaskFailure(ExperimentVariant experimentVariant, Exception e, ExperimentTaskContext taskContext) {
        log.error("Variant failure for {}: {}", (Object)experimentVariant.getId(), (Object)e.getMessage());
        taskContext.completeVariantFailure();
    }

    public void handleSearchFailure(Exception e, ExperimentVariant experimentVariant, String experimentId, String evaluationId, ExperimentTaskContext taskContext) {
        ExperimentVariant experimentVariantResult = new ExperimentVariant(experimentVariant.getId(), TimeUtils.getTimestamp(), experimentVariant.getType(), AsyncStatus.ERROR, experimentId, experimentVariant.getParameters(), Map.of("evaluationResultId", evaluationId, "error", e.getMessage()));
        this.experimentVariantDao.putExperimentVariantEfficient(experimentVariantResult, ActionListener.wrap(success -> {
            log.error("Error executing variant {}: {}", (Object)experimentVariant.getId(), (Object)e.getMessage());
            taskContext.completeVariantFailure();
        }, error -> {
            log.error("Failed to persist error status for variant {}: {}", (Object)experimentVariant.getId(), (Object)error.getMessage());
            taskContext.completeVariantFailure();
        }));
    }

    @Generated
    public SearchResponseProcessor(EvaluationResultDao evaluationResultDao, ExperimentVariantDao experimentVariantDao) {
        this.evaluationResultDao = evaluationResultDao;
        this.experimentVariantDao = experimentVariantDao;
    }
}

