/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.model.WorkflowEdge;
import org.opensearch.flowframework.model.WorkflowNode;

public class Workflow
implements ToXContentObject {
    public static final String USER_PARAMS_FIELD = "user_params";
    public static final String NODES_FIELD = "nodes";
    public static final String EDGES_FIELD = "edges";
    private final Map<String, String> userParams;
    private final List<WorkflowNode> nodes;
    private final List<WorkflowEdge> edges;

    public Workflow(Map<String, String> userParams, List<WorkflowNode> nodes, List<WorkflowEdge> edges) {
        this.userParams = Map.copyOf(userParams);
        this.nodes = List.copyOf(nodes);
        this.edges = List.copyOf(edges);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder.startObject(USER_PARAMS_FIELD);
        for (Map.Entry<String, String> entry : this.userParams.entrySet()) {
            xContentBuilder.field(entry.getKey(), entry.getValue());
        }
        xContentBuilder.endObject();
        xContentBuilder.startArray(NODES_FIELD);
        for (WorkflowNode workflowNode : this.nodes) {
            xContentBuilder.value((Object)workflowNode);
        }
        xContentBuilder.endArray();
        xContentBuilder.startArray(EDGES_FIELD);
        for (WorkflowEdge workflowEdge : this.edges) {
            xContentBuilder.value((Object)workflowEdge);
        }
        xContentBuilder.endArray();
        return xContentBuilder.endObject();
    }

    public static Workflow parse(XContentParser parser) throws IOException {
        HashMap<String, String> userParams = new HashMap<String, String>();
        ArrayList<WorkflowNode> nodes = new ArrayList<WorkflowNode>();
        ArrayList<WorkflowEdge> edges = new ArrayList<WorkflowEdge>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "user_params": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String userParamFieldName = parser.currentName();
                        parser.nextToken();
                        userParams.put(userParamFieldName, parser.text());
                    }
                    break;
                }
                case "nodes": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        nodes.add(WorkflowNode.parse(parser));
                    }
                    break;
                }
                case "edges": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        edges.add(WorkflowEdge.parse(parser));
                    }
                    break;
                }
            }
        }
        if (nodes.isEmpty()) {
            throw new FlowFrameworkException("A workflow must have at least one node.", RestStatus.BAD_REQUEST);
        }
        List inferredEdges = nodes.stream().flatMap(node -> node.previousNodeInputs().keySet().stream().map(previousNode -> new WorkflowEdge((String)previousNode, node.id()))).distinct().collect(Collectors.toList());
        inferredEdges.removeAll(edges);
        edges.addAll(inferredEdges);
        return new Workflow(userParams, nodes, edges);
    }

    public Map<String, String> userParams() {
        return this.userParams;
    }

    public List<WorkflowNode> nodes() {
        return this.nodes;
    }

    public List<WorkflowEdge> edges() {
        return this.edges;
    }

    public String toString() {
        return "Workflow [userParams=" + String.valueOf(this.userParams) + ", nodes=" + String.valueOf(this.nodes) + ", edges=" + String.valueOf(this.edges) + "]";
    }
}

