/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 0) => i64vec3(-1333333333333333259l, 85l, 94l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 1) => i64vec3(-2666666666666666518l, 170l, 188l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 2) => i64vec3(-5333333333333333036l, 340l, 376l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 5) => i64vec3(-5773178519247561056l, 2720l, 3008l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 25) => i64vec3(-3776561488156688384l, 2852126720l, 3154116608l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << 31) => i64vec3(-1892262283803885568l, 182536110080l, 201863462912l)
 * (i64vec3(167l, 66l, 187l) << 0) => i64vec3(167l, 66l, 187l)
 * (i64vec3(167l, 66l, 187l) << 1) => i64vec3(334l, 132l, 374l)
 * (i64vec3(167l, 66l, 187l) << 2) => i64vec3(668l, 264l, 748l)
 * (i64vec3(167l, 66l, 187l) << 5) => i64vec3(5344l, 2112l, 5984l)
 * (i64vec3(167l, 66l, 187l) << 25) => i64vec3(5603590144l, 2214592512l, 6274678784l)
 * (i64vec3(167l, 66l, 187l) << 31) => i64vec3(358629769216l, 141733920768l, 401579442176l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 0), i64vec3(-1333333333333333259l, 85l, 94l))) ? 1 : -1] array0;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 1), i64vec3(-2666666666666666518l, 170l, 188l))) ? 1 : -1] array1;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 2), i64vec3(-5333333333333333036l, 340l, 376l))) ? 1 : -1] array2;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 5), i64vec3(-5773178519247561056l, 2720l, 3008l))) ? 1 : -1] array3;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 25), i64vec3(-3776561488156688384l, 2852126720l, 3154116608l))) ? 1 : -1] array4;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << 31), i64vec3(-1892262283803885568l, 182536110080l, 201863462912l))) ? 1 : -1] array5;
  float[all(equal((i64vec3(167l, 66l, 187l) << 0), i64vec3(167l, 66l, 187l))) ? 1 : -1] array6;
  float[all(equal((i64vec3(167l, 66l, 187l) << 1), i64vec3(334l, 132l, 374l))) ? 1 : -1] array7;
  float[all(equal((i64vec3(167l, 66l, 187l) << 2), i64vec3(668l, 264l, 748l))) ? 1 : -1] array8;
  float[all(equal((i64vec3(167l, 66l, 187l) << 5), i64vec3(5344l, 2112l, 5984l))) ? 1 : -1] array9;
  float[all(equal((i64vec3(167l, 66l, 187l) << 25), i64vec3(5603590144l, 2214592512l, 6274678784l))) ? 1 : -1] array10;
  float[all(equal((i64vec3(167l, 66l, 187l) << 31), i64vec3(358629769216l, 141733920768l, 401579442176l))) ? 1 : -1] array11;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
