/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.main;

import com.projectlibre1.configuration.Dictionary;
import com.projectlibre1.exchange.MicrosoftImporter;
import com.projectlibre1.graphic.configuration.BarStyles;
import com.projectlibre1.pm.graphic.gantt.Gantt;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCache;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projectlibre1.pm.resource.ResourcePool;
import com.projectlibre1.pm.resource.ResourcePoolFactory;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.session.CreateOptions;
import com.projectlibre1.undo.DataFactoryUndoController;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class GanttTest {
    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> {
            JFrame jFrame = new JFrame("Double Buffered JComponent with ScrollPane");
            jFrame.setDefaultCloseOperation(3);
            jFrame.setSize(800, 600);
            jFrame.setLocationRelativeTo(null);
            try {
                CreateOptions createOptions = new CreateOptions();
                createOptions.setLocal(true);
                createOptions.setName("TestProject");
                createOptions.setAddResources(false);
                DataFactoryUndoController dataFactoryUndoController = new DataFactoryUndoController();
                ResourcePool resourcePool = createOptions.getResourcePool();
                if (resourcePool == null) {
                    resourcePool = ResourcePoolFactory.getInstance().createResourcePool(createOptions.getName(), dataFactoryUndoController);
                    resourcePool.setLocal(createOptions.isLocal());
                }
                Project project = Project.createProject(resourcePool, dataFactoryUndoController);
                dataFactoryUndoController.setDataFactory(project);
                project.setName(createOptions.getName());
                if (createOptions.isLocal()) {
                    project.setMaster(true);
                }
                MicrosoftImporter microsoftImporter = new MicrosoftImporter();
                microsoftImporter.setFileName("/Users/chretien/sample/Sample Project.xml");
                microsoftImporter.importProject(project);
                Gantt gantt = new Gantt(project, "testView");
                NodeModelCache nodeModelCache = NodeModelCacheFactory.getInstance().createDefaultCache(project.getTaskModel(), project, 8, "OfflineProjects", null);
                gantt.setCache(nodeModelCache);
                gantt.setBarStyles((BarStyles)Dictionary.get("BarStylesCategory", "standard"));
                JScrollPane jScrollPane = new JScrollPane(gantt);
                jFrame.add(jScrollPane);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            jFrame.setVisible(true);
        });
    }

    static class CustomCanvas
    extends JComponent
    implements ActionListener {
        private Timer timer;
        private int angle = 0;

        public CustomCanvas() {
            this.setDoubleBuffered(true);
            this.setPreferredSize(new Dimension(1600, 1200));
            this.timer = new Timer(16, this);
            this.timer.start();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int i = 200; i < this.getWidth(); i += 400) {
                for (int j = 150; j < this.getHeight(); j += 300) {
                    graphics2D.translate(i, j);
                    graphics2D.rotate(Math.toRadians(this.angle));
                    graphics2D.setColor(Color.BLUE);
                    graphics2D.fillRect(-50, -30, 100, 60);
                    graphics2D.rotate(-Math.toRadians(this.angle));
                    graphics2D.translate(-i, -j);
                }
            }
            graphics2D.dispose();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.angle += 2;
            if (this.angle >= 360) {
                this.angle = 0;
            }
            this.repaint();
        }
    }
}

