/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.extension.brk.BreakAPI;
import org.zaproxy.zap.extension.brk.BreakPanel;
import org.zaproxy.zap.extension.brk.BreakpointManagementInterface;
import org.zaproxy.zap.extension.brk.BreakpointMessageHandler2;
import org.zaproxy.zap.extension.brk.BreakpointMessageInterface;
import org.zaproxy.zap.extension.brk.BreakpointsOptionsPanel;
import org.zaproxy.zap.extension.brk.BreakpointsPanel;
import org.zaproxy.zap.extension.brk.BreakpointsParam;
import org.zaproxy.zap.extension.brk.BreakpointsTableModel;
import org.zaproxy.zap.extension.brk.BreakpointsUiManagerInterface;
import org.zaproxy.zap.extension.brk.PopupMenuEditBreak;
import org.zaproxy.zap.extension.brk.PopupMenuRemove;
import org.zaproxy.zap.extension.brk.impl.http.HttpBreakpointManagementDaemonImpl;
import org.zaproxy.zap.extension.brk.impl.http.HttpBreakpointMessage;
import org.zaproxy.zap.extension.brk.impl.http.HttpBreakpointsUiManagerInterface;
import org.zaproxy.zap.extension.brk.impl.http.ProxyListenerBreak;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionBreak
extends ExtensionAdaptor
implements SessionChangedListener,
OptionsChangedListener {
    public static final String NAME = "ExtensionBreak";
    private static final Logger logger = LogManager.getLogger(ExtensionBreak.class);
    public static final String BREAK_POINT_HIT_STATS = "stats.break.hit";
    public static final String BREAK_POINT_STEP_STATS = "stats.break.step";
    public static final String BREAK_POINT_DROP_STATS = "stats.break.drop";
    private BreakPanel breakPanel = null;
    private ProxyListenerBreak proxyListener = null;
    private BreakpointsPanel breakpointsPanel = null;
    private PopupMenuEditBreak popupMenuEditBreak = null;
    private PopupMenuRemove popupMenuRemove = null;
    private BreakpointMessageHandler2 breakpointMessageHandler;
    private DialogType currentDialogType = DialogType.NONE;
    private Map<Class<? extends BreakpointMessageInterface>, BreakpointsUiManagerInterface> mapBreakpointUiManager;
    private Map<Class<? extends Message>, BreakpointsUiManagerInterface> mapMessageUiManager;
    private Control.Mode mode = Control.getSingleton().getMode();
    private BreakpointsParam breakpointsParams;
    private BreakpointsOptionsPanel breakpointsOptionsPanel;
    private BreakpointManagementInterface breakpointManagementInterface;
    private HttpBreakpointsUiManagerInterface httpBreakpoints;
    private ZapMenuItem menuBreakOnRequests = null;
    private ZapMenuItem menuBreakOnResponses = null;
    private ZapMenuItem menuStep = null;
    private ZapMenuItem menuContinue = null;
    private ZapMenuItem menuDrop = null;
    private ZapMenuItem menuHttpBreakpoint = null;
    private BreakAPI api = new BreakAPI(this);

    public ExtensionBreak() {
        super(NAME);
        this.setOrder(24);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("brk.name");
    }

    public BreakpointManagementInterface getBreakpointManagementInterface() {
        return this.breakpointManagementInterface;
    }

    @Deprecated
    public BreakPanel getBreakPanel() {
        return this.breakPanel;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getOptionsParam());
        extensionHook.addProxyListener(this.getProxyListenerBreak());
        extensionHook.addSessionListener(this);
        extensionHook.addOptionsChangedListener(this);
        extensionHook.addApiImplementor(this.api);
        if (this.getView() != null) {
            this.breakPanel = new BreakPanel(this, this.getOptionsParam());
            this.breakPanel.setName(Constant.messages.getString("tab.break"));
            this.breakpointMessageHandler = new BreakpointMessageHandler2(this.breakPanel);
            this.breakpointMessageHandler.setEnabledBreakpoints(this.getBreakpointsModel().getBreakpointsEnabledList());
            this.breakpointMessageHandler.setEnabledIgnoreRules(this.breakPanel.getIgnoreRulesEnableList());
            this.breakpointManagementInterface = this.breakPanel;
            ExtensionHookView pv = extensionHook.getHookView();
            pv.addWorkPanel(this.breakPanel);
            pv.addOptionPanel(this.getOptionsPanel());
            extensionHook.getHookView().addStatusPanel(this.getBreakpointsPanel());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuEdit());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuDelete());
            this.mapBreakpointUiManager = new HashMap<Class<? extends BreakpointMessageInterface>, BreakpointsUiManagerInterface>();
            this.mapMessageUiManager = new HashMap<Class<? extends Message>, BreakpointsUiManagerInterface>();
            this.httpBreakpoints = new HttpBreakpointsUiManagerInterface(extensionHook.getHookMenu(), this);
            this.addBreakpointsUiManager(this.httpBreakpoints);
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuToggleBreakOnRequests());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuToggleBreakOnResponses());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuStep());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuContinue());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuDrop());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuAddHttpBreakpoint());
            ExtensionHelp.enableHelpKey(this.breakPanel, "ui.tabs.break");
            ExtensionHelp.enableHelpKey(this.getBreakpointsPanel(), "ui.tabs.breakpoints");
        } else {
            this.breakpointManagementInterface = new HttpBreakpointManagementDaemonImpl();
            this.breakpointMessageHandler = new BreakpointMessageHandler2(this.breakpointManagementInterface);
            this.breakpointMessageHandler.setEnabledBreakpoints(new ArrayList<BreakpointMessageInterface>());
            this.breakpointMessageHandler.setEnabledIgnoreRules(new ArrayList<BreakpointMessageInterface>());
        }
    }

    private BreakpointsParam getOptionsParam() {
        if (this.breakpointsParams == null) {
            this.breakpointsParams = new BreakpointsParam();
        }
        return this.breakpointsParams;
    }

    private BreakpointsOptionsPanel getOptionsPanel() {
        if (this.breakpointsOptionsPanel == null) {
            this.breakpointsOptionsPanel = new BreakpointsOptionsPanel();
        }
        return this.breakpointsOptionsPanel;
    }

    private BreakpointsPanel getBreakpointsPanel() {
        if (this.breakpointsPanel == null) {
            this.breakpointsPanel = new BreakpointsPanel(this);
        }
        return this.breakpointsPanel;
    }

    public void addBreakpoint(BreakpointMessageInterface breakpoint) {
        this.getBreakpointsPanel().addBreakpoint(breakpoint);
        this.getBreakpointsPanel().setTabFocus();
    }

    public void editBreakpoint(BreakpointMessageInterface oldBreakpoint, BreakpointMessageInterface newBreakpoint) {
        this.getBreakpointsPanel().editBreakpoint(oldBreakpoint, newBreakpoint);
    }

    public void removeBreakpoint(BreakpointMessageInterface breakpoint) {
        this.getBreakpointsPanel().removeBreakpoint(breakpoint);
    }

    public List<BreakpointMessageInterface> getBreakpointsList() {
        return this.getBreakpointsModel().getBreakpointsList();
    }

    public BreakpointMessageInterface getUiSelectedBreakpoint() {
        return this.getBreakpointsPanel().getSelectedBreakpoint();
    }

    public void addBreakpointsUiManager(BreakpointsUiManagerInterface uiManager) {
        if (this.getView() == null) {
            return;
        }
        this.mapBreakpointUiManager.put(uiManager.getBreakpointClass(), uiManager);
        this.mapMessageUiManager.put(uiManager.getMessageClass(), uiManager);
    }

    public void removeBreakpointsUiManager(BreakpointsUiManagerInterface uiManager) {
        if (this.getView() == null) {
            return;
        }
        this.mapBreakpointUiManager.remove(uiManager.getBreakpointClass());
        this.mapMessageUiManager.remove(uiManager.getMessageClass());
    }

    public void setBreakAllRequests(boolean brk) {
        this.breakpointManagementInterface.setBreakAllRequests(brk);
    }

    public void setBreakAllResponses(boolean brk) {
        this.breakpointManagementInterface.setBreakAllResponses(brk);
    }

    public void addHttpBreakpoint(String string, String location, String match, boolean inverse, boolean ignoreCase) {
        this.addBreakpoint(new HttpBreakpointMessage(string, ExtensionBreak.getLocationEnum(location), ExtensionBreak.getMatchEnum(match), inverse, ignoreCase));
    }

    private static HttpBreakpointMessage.Location getLocationEnum(String location) {
        try {
            return HttpBreakpointMessage.Location.valueOf(location);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("location must be one of " + Arrays.toString((Object[])HttpBreakpointMessage.Location.values()));
        }
    }

    private static HttpBreakpointMessage.Match getMatchEnum(String match) {
        try {
            return HttpBreakpointMessage.Match.valueOf(match);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("match must be one of " + Arrays.toString((Object[])HttpBreakpointMessage.Match.values()));
        }
    }

    public void removeHttpBreakpoint(String string, String location, String match, boolean inverse, boolean ignoreCase) {
        this.removeBreakpoint(new HttpBreakpointMessage(string, ExtensionBreak.getLocationEnum(location), ExtensionBreak.getMatchEnum(match), inverse, ignoreCase));
    }

    public void addUiBreakpoint(Message aMessage) {
        BreakpointsUiManagerInterface uiManager = this.getBreakpointUiManager(aMessage.getClass());
        if (uiManager != null) {
            uiManager.handleAddBreakpoint(aMessage);
        }
    }

    private BreakpointsUiManagerInterface getBreakpointUiManager(Class<?> clazz) {
        if (!Message.class.isAssignableFrom(clazz)) {
            return null;
        }
        BreakpointsUiManagerInterface uiManager = this.mapMessageUiManager.get(clazz);
        if (uiManager == null) {
            uiManager = this.getBreakpointUiManager(clazz.getSuperclass());
        }
        return uiManager;
    }

    public void editUiSelectedBreakpoint() {
        BreakpointsUiManagerInterface uiManager;
        BreakpointMessageInterface breakpoint = this.getBreakpointsPanel().getSelectedBreakpoint();
        if (breakpoint != null && (uiManager = this.mapBreakpointUiManager.get(breakpoint.getClass())) != null) {
            uiManager.handleEditBreakpoint(breakpoint);
        }
    }

    public void removeUiSelectedBreakpoint() {
        BreakpointsUiManagerInterface uiManager;
        BreakpointMessageInterface breakpoint = this.getBreakpointsPanel().getSelectedBreakpoint();
        if (breakpoint != null && (uiManager = this.mapBreakpointUiManager.get(breakpoint.getClass())) != null) {
            uiManager.handleRemoveBreakpoint(breakpoint);
        }
    }

    private BreakpointsTableModel getBreakpointsModel() {
        return (BreakpointsTableModel)this.getBreakpointsPanel().getBreakpoints().getModel();
    }

    private ProxyListenerBreak getProxyListenerBreak() {
        if (this.proxyListener == null) {
            this.proxyListener = new ProxyListenerBreak(this.getModel(), this);
        }
        return this.proxyListener;
    }

    private PopupMenuEditBreak getPopupMenuEdit() {
        if (this.popupMenuEditBreak == null) {
            this.popupMenuEditBreak = new PopupMenuEditBreak();
            this.popupMenuEditBreak.setExtension(this);
        }
        return this.popupMenuEditBreak;
    }

    private PopupMenuRemove getPopupMenuDelete() {
        if (this.popupMenuRemove == null) {
            this.popupMenuRemove = new PopupMenuRemove();
            this.popupMenuRemove.setExtension(this);
        }
        return this.popupMenuRemove;
    }

    private ZapMenuItem getMenuToggleBreakOnRequests() {
        if (this.menuBreakOnRequests == null) {
            this.menuBreakOnRequests = new ZapMenuItem("menu.tools.brk.req", this.getView().getMenuShortcutKeyStroke(66, 0, false));
            this.menuBreakOnRequests.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExtensionBreak.this.getOptionsParam().getButtonMode() == 1) {
                        ExtensionBreak.this.breakpointManagementInterface.setBreakAll(!ExtensionBreak.this.breakpointManagementInterface.isBreakAll());
                    } else {
                        ExtensionBreak.this.breakpointManagementInterface.setBreakAllRequests(!ExtensionBreak.this.breakpointManagementInterface.isBreakRequest());
                    }
                }
            });
        }
        return this.menuBreakOnRequests;
    }

    private ZapMenuItem getMenuToggleBreakOnResponses() {
        if (this.menuBreakOnResponses == null) {
            this.menuBreakOnResponses = new ZapMenuItem("menu.tools.brk.resp", this.getView().getMenuShortcutKeyStroke(66, 512, false));
            this.menuBreakOnResponses.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExtensionBreak.this.getOptionsParam().getButtonMode() == 1) {
                        ExtensionBreak.this.breakpointManagementInterface.setBreakAll(!ExtensionBreak.this.breakpointManagementInterface.isBreakAll());
                    } else {
                        ExtensionBreak.this.breakpointManagementInterface.setBreakAllResponses(!ExtensionBreak.this.breakpointManagementInterface.isBreakResponse());
                    }
                }
            });
        }
        return this.menuBreakOnResponses;
    }

    private ZapMenuItem getMenuStep() {
        if (this.menuStep == null) {
            this.menuStep = new ZapMenuItem("menu.tools.brk.step", this.getView().getMenuShortcutKeyStroke(83, 0, false));
            this.menuStep.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExtensionBreak.this.breakpointManagementInterface.isHoldMessage(null)) {
                        ExtensionBreak.this.breakpointManagementInterface.step();
                    }
                }
            });
        }
        return this.menuStep;
    }

    private ZapMenuItem getMenuContinue() {
        if (this.menuContinue == null) {
            this.menuContinue = new ZapMenuItem("menu.tools.brk.cont", this.getView().getMenuShortcutKeyStroke(67, 0, false));
            this.menuContinue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExtensionBreak.this.breakpointManagementInterface.isHoldMessage(null)) {
                        ExtensionBreak.this.breakpointManagementInterface.cont();
                    }
                }
            });
        }
        return this.menuContinue;
    }

    private ZapMenuItem getMenuDrop() {
        if (this.menuDrop == null) {
            this.menuDrop = new ZapMenuItem("menu.tools.brk.drop", this.getView().getMenuShortcutKeyStroke(88, 0, false));
            this.menuDrop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExtensionBreak.this.breakpointManagementInterface.isHoldMessage(null)) {
                        ExtensionBreak.this.breakpointManagementInterface.drop();
                    }
                }
            });
        }
        return this.menuDrop;
    }

    private ZapMenuItem getMenuAddHttpBreakpoint() {
        if (this.menuHttpBreakpoint == null) {
            this.menuHttpBreakpoint = new ZapMenuItem("menu.tools.brk.custom", this.getView().getMenuShortcutKeyStroke(65, 0, false));
            this.menuHttpBreakpoint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String url = "";
                    Component c = ExtensionBreak.this.getView().getMainFrame().getFocusOwner();
                    if (c != null) {
                        if (c instanceof JList) {
                            Object sel = ((JList)c).getSelectedValue();
                            try {
                                if (sel != null && sel instanceof HistoryReference && ((HistoryReference)sel).getURI() != null) {
                                    url = ((HistoryReference)sel).getURI().toString();
                                }
                            }
                            catch (Exception exception) {}
                        } else if (c instanceof JTree) {
                            TreePath path = ((JTree)c).getSelectionPath();
                            try {
                                if (path != null && path.getLastPathComponent() instanceof SiteNode) {
                                    url = ((SiteNode)path.getLastPathComponent()).getHistoryReference().getURI().toString();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    ExtensionBreak.this.httpBreakpoints.handleAddBreakpoint(url);
                }
            });
        }
        return this.menuHttpBreakpoint;
    }

    @Deprecated
    public boolean canAddBreakpoint() {
        return this.currentDialogType == DialogType.NONE || this.currentDialogType == DialogType.ADD;
    }

    @Deprecated
    public boolean canEditBreakpoint() {
        return this.currentDialogType == DialogType.NONE || this.currentDialogType == DialogType.EDIT;
    }

    @Deprecated
    public boolean canRemoveBreakpoint() {
        return this.currentDialogType == DialogType.NONE || this.currentDialogType == DialogType.REMOVE;
    }

    @Deprecated
    public void dialogShown(DialogType type) {
        this.currentDialogType = type;
    }

    @Deprecated
    public void dialogClosed() {
        this.currentDialogType = DialogType.NONE;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("brk.desc");
    }

    @Override
    public void sessionAboutToChange(Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionAboutToChange();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionBreak.this.sessionAboutToChange();
                    }
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void sessionChanged(Session session) {
        if (this.getView() == null) {
            return;
        }
        this.breakpointManagementInterface.init();
    }

    private void sessionAboutToChange() {
        if (this.getView() == null) {
            return;
        }
        this.breakpointManagementInterface.reset();
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public void destroy() {
        if (this.breakPanel != null) {
            this.breakPanel.savePanels();
        }
    }

    public boolean messageReceivedFromClient(Message aMessage) {
        if (this.mode.equals((Object)Control.Mode.safe)) {
            return true;
        }
        return this.breakpointMessageHandler.handleMessageReceivedFromClient(aMessage, this.mode.equals((Object)Control.Mode.protect));
    }

    public boolean messageReceivedFromServer(Message aMessage) {
        if (this.mode.equals((Object)Control.Mode.safe)) {
            return true;
        }
        return this.breakpointMessageHandler.handleMessageReceivedFromServer(aMessage, this.mode.equals((Object)Control.Mode.protect));
    }

    public List<BreakpointMessageInterface> getBreakpointsEnabledList() {
        if (this.mode.equals((Object)Control.Mode.safe)) {
            return new ArrayList<BreakpointMessageInterface>();
        }
        return this.getBreakpointsModel().getBreakpointsEnabledList();
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
        this.mode = mode;
        if (this.getView() == null) {
            return;
        }
        this.breakpointManagementInterface.sessionModeChanged(mode);
    }

    public void setBreakOnId(String id, boolean enable) {
        logger.debug("setBreakOnId " + id + " " + enable);
        if (enable) {
            this.breakpointMessageHandler.getEnabledKeyBreakpoints().add(id);
        } else {
            this.breakpointMessageHandler.getEnabledKeyBreakpoints().remove(id);
        }
    }

    @Override
    public void optionsChanged(OptionsParam optionsParam) {
        this.applyViewOptions(optionsParam);
    }

    private void applyViewOptions(OptionsParam options) {
        if (this.getView() == null) {
            return;
        }
        this.breakPanel.setButtonsLocation(options.getViewParam().getBrkPanelViewOption());
        this.breakPanel.setButtonMode(options.getParamSet(BreakpointsParam.class).getButtonMode());
        this.breakPanel.setShowIgnoreFilesButtons(options.getParamSet(BreakpointsParam.class).isShowIgnoreFilesButtons());
        this.breakPanel.updateIgnoreFileTypesRegexs();
    }

    @Override
    public void optionsLoaded() {
        this.applyViewOptions(this.getModel().getOptionsParam());
    }

    public boolean isInScopeOnly() {
        return this.getOptionsParam().isInScopeOnly();
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    @Deprecated
    public static enum DialogType {
        NONE,
        ADD,
        EDIT,
        REMOVE;

    }
}

