/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stdmenus;

import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.view.SessionExcludeFromSpiderPanel;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContainer;

public class PopupExcludeFromSpiderMenu
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 2282358266003940700L;

    public PopupExcludeFromSpiderMenu() {
        super(Constant.messages.getString("sites.exclude.spider.popup"), true);
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("sites.exclude.popup");
    }

    @Override
    public int getParentMenuIndex() {
        return 1;
    }

    @Override
    public void performAction(SiteNode sn) {
        try {
            Session session = Model.getSingleton().getSession();
            session.getExcludeFromSpiderRegexs().add(new StructuralSiteNode(sn).getRegexPattern());
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    @Override
    public void performHistoryReferenceActions(List<HistoryReference> hrefs) {
        super.performHistoryReferenceActions(hrefs);
        View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), SessionExcludeFromSpiderPanel.PANEL_NAME);
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

