/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.query;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.olap4j.OlapException;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Member;
import org.olap4j.query.Query;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryNode;
import org.olap4j.query.QueryNodeImpl;
import org.olap4j.query.Selection;
import org.olap4j.query.SortOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryDimension
extends QueryNodeImpl {
    protected QueryAxis axis;
    protected final List<Selection> inclusions = new SelectionList();
    protected final List<Selection> exclusions = new SelectionList();
    private final Query query;
    protected Dimension dimension;
    private SortOrder sortOrder = null;
    private HierarchizeMode hierarchizeMode = null;

    public QueryDimension(Query query, Dimension dimension) {
        this.query = query;
        this.dimension = dimension;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setAxis(QueryAxis axis) {
        this.axis = axis;
    }

    public QueryAxis getAxis() {
        return this.axis;
    }

    public String getName() {
        return this.dimension.getName();
    }

    @Deprecated
    public void select(String ... nameParts) throws OlapException {
        this.include(nameParts);
    }

    @Deprecated
    public void select(Selection.Operator operator, String ... nameParts) throws OlapException {
        this.include(operator, nameParts);
    }

    @Deprecated
    public void select(Member member) {
        this.include(member);
    }

    @Deprecated
    public void select(Selection.Operator operator, Member member) {
        this.include(operator, member);
    }

    @Deprecated
    public void clearSelection() {
        this.clearInclusions();
    }

    public void include(String ... nameParts) throws OlapException {
        this.include(Selection.Operator.MEMBER, nameParts);
    }

    public void include(Selection.Operator operator, String ... nameParts) throws OlapException {
        Member member = this.getQuery().getCube().lookupMember(nameParts);
        if (member == null) {
            throw new OlapException("Unable to find a member with name " + Olap4jUtil.stringArrayToString(nameParts));
        }
        this.include(operator, member);
    }

    public void include(Member member) {
        this.include(Selection.Operator.MEMBER, member);
    }

    public void include(Selection.Operator operator, Member member) {
        if (member.getDimension().equals(this.dimension)) {
            Selection selection = this.query.getSelectionFactory().createMemberSelection(member, operator);
            this.include(selection);
        }
    }

    private void include(Selection selection) {
        this.getInclusions().add(selection);
        Integer index = this.getInclusions().indexOf(selection);
        this.notifyAdd(selection, index);
    }

    public void clearInclusions() {
        HashMap<Integer, QueryNode> removed = new HashMap<Integer, QueryNode>();
        for (Selection node : this.inclusions) {
            removed.put(this.inclusions.indexOf(node), node);
            ((QueryNodeImpl)((Object)node)).clearListeners();
        }
        this.inclusions.clear();
        this.notifyRemove(removed);
    }

    public void exclude(String ... nameParts) throws OlapException {
        this.exclude(Selection.Operator.MEMBER, nameParts);
    }

    public void exclude(Selection.Operator operator, String ... nameParts) throws OlapException {
        Member rootMember = this.getQuery().getCube().lookupMember(nameParts);
        if (rootMember == null) {
            throw new OlapException("Unable to find a member with name " + Olap4jUtil.stringArrayToString(nameParts));
        }
        this.exclude(operator, rootMember);
    }

    public void exclude(Member member) {
        this.exclude(Selection.Operator.MEMBER, member);
    }

    public void exclude(Selection.Operator operator, Member member) {
        if (member.getDimension().equals(this.dimension)) {
            Selection selection = this.query.getSelectionFactory().createMemberSelection(member, operator);
            this.exclude(selection);
        }
    }

    private void exclude(Selection selection) {
        this.getExclusions().add(selection);
        Integer index = this.getExclusions().indexOf(selection);
        this.notifyAdd(selection, index);
    }

    public void clearExclusions() {
        HashMap<Integer, QueryNode> removed = new HashMap<Integer, QueryNode>();
        for (Selection node : this.exclusions) {
            removed.put(this.exclusions.indexOf(node), node);
            ((QueryNodeImpl)((Object)node)).clearListeners();
        }
        this.exclusions.clear();
        this.notifyRemove(removed);
    }

    public static String[] getNameParts(String sel) {
        List<IdentifierNode.Segment> list = IdentifierNode.parseIdentifier(sel);
        String[] nameParts = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nameParts[i] = list.get(i).getName();
        }
        return nameParts;
    }

    public List<Member> resolve(Selection selection) throws OlapException {
        Member.TreeOp op;
        assert (selection != null);
        Member.TreeOp secondOp = null;
        switch (selection.getOperator()) {
            case CHILDREN: {
                op = Member.TreeOp.CHILDREN;
                break;
            }
            case SIBLINGS: {
                op = Member.TreeOp.SIBLINGS;
                break;
            }
            case INCLUDE_CHILDREN: {
                op = Member.TreeOp.SELF;
                secondOp = Member.TreeOp.CHILDREN;
                break;
            }
            case MEMBER: {
                op = Member.TreeOp.SELF;
                break;
            }
            default: {
                throw new OlapException("Operation not supported: " + (Object)((Object)selection.getOperator()));
            }
        }
        TreeSet<Member.TreeOp> set = new TreeSet<Member.TreeOp>();
        set.add(op);
        if (secondOp != null) {
            set.add(secondOp);
        }
        try {
            return this.query.getCube().lookupMembers(set, QueryDimension.getNameParts(selection.getName()));
        }
        catch (Exception e) {
            throw new OlapException("Error while resolving selection " + selection.toString(), e);
        }
    }

    @Deprecated
    public List<Selection> getSelections() {
        return this.getInclusions();
    }

    public List<Selection> getInclusions() {
        return this.inclusions;
    }

    public List<Selection> getExclusions() {
        return this.exclusions;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public void sort(SortOrder order) {
        this.sortOrder = order;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void clearSort() {
        this.sortOrder = null;
    }

    public HierarchizeMode getHierarchizeMode() {
        return this.hierarchizeMode;
    }

    public void setHierarchizeMode(HierarchizeMode hierarchizeMode) {
        this.hierarchizeMode = hierarchizeMode;
    }

    public void clearHierarchizeMode() {
        this.hierarchizeMode = null;
    }

    @Override
    void tearDown() {
        for (Selection node : this.inclusions) {
            ((QueryNodeImpl)((Object)node)).clearListeners();
        }
        for (Selection node : this.exclusions) {
            ((QueryNodeImpl)((Object)node)).clearListeners();
        }
        this.inclusions.clear();
        this.exclusions.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HierarchizeMode {
        PRE,
        POST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectionList
    extends AbstractList<Selection> {
        private final List<Selection> list = new ArrayList<Selection>();

        private SelectionList() {
        }

        @Override
        public Selection get(int index) {
            return this.list.get(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Selection set(int index, Selection selection) {
            return this.list.set(index, selection);
        }

        @Override
        public void add(int index, Selection selection) {
            if (this.contains(selection)) {
                throw new IllegalStateException("dimension already contains selection");
            }
            this.list.add(index, selection);
        }

        @Override
        public Selection remove(int index) {
            return this.list.remove(index);
        }
    }
}

