/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.FreeColClientHolder;
import net.sf.freecol.client.control.MapTransform;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.DialogHandler;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.LoadingSavegameInfo;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.dialog.FreeColDialog;
import net.sf.freecol.client.gui.dialog.Parameters;
import net.sf.freecol.client.gui.mapviewer.MapAsyncPainter;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.report.LabourData;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.metaserver.ServerInfo;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.resources.ResourceManager;

public class GUI
extends FreeColClientHolder {
    protected static final Logger logger = Logger.getLogger(GUI.class.getName());
    private static final String[] levels = new String[]{"low", "normal", "high"};

    public GUI(FreeColClient freeColClient) {
        super(freeColClient);
    }

    public final boolean confirm(String textKey, String okKey, String cancelKey) {
        return this.confirm(null, StringTemplate.key(textKey), (ImageIcon)null, okKey, cancelKey);
    }

    public final boolean confirm(StringTemplate template, String okKey, String cancelKey) {
        return this.confirm(null, template, (ImageIcon)null, okKey, cancelKey);
    }

    public final boolean confirm(Tile tile, StringTemplate template, GoodsType goodsType, String okKey, String cancelKey) {
        ImageIcon icon = new ImageIcon(this.getFixedImageLibrary().getScaledGoodsTypeImage(goodsType));
        return this.confirm(tile, template, icon, okKey, cancelKey);
    }

    public final boolean confirm(Tile tile, StringTemplate template, Settlement settlement, String okKey, String cancelKey) {
        ImageIcon icon = new ImageIcon(this.getFixedImageLibrary().getScaledSettlementImage(settlement));
        return this.confirm(tile, template, icon, okKey, cancelKey);
    }

    public final boolean confirm(Tile tile, StringTemplate template, Unit unit, String okKey, String cancelKey) {
        ImageIcon icon = new ImageIcon(this.getFixedImageLibrary().getScaledUnitImage(unit));
        return this.confirm(tile, template, icon, okKey, cancelKey);
    }

    public boolean confirmAbandonEducation(Unit unit, boolean leaveColony) {
        boolean student;
        if (!unit.isInColony()) {
            return true;
        }
        boolean teacher = unit.getStudent() != null;
        boolean bl = student = leaveColony && unit.getTeacher() != null;
        if (!teacher && !student) {
            return true;
        }
        Building school = (Building)(teacher ? unit.getLocation() : unit.getTeacher().getLocation());
        StringTemplate label = unit.getLabel(Unit.UnitLabelType.NATIONAL);
        StringTemplate template = leaveColony ? (StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("abandonEducation.text").addStringTemplate("%unit%", label)).addName("%colony%", school.getColony().getName())).addNamed("%building%", school)).addStringTemplate("%action%", teacher ? StringTemplate.key("abandonEducation.action.teaching") : StringTemplate.key("abandonEducation.action.studying")) : (teacher ? (StringTemplate)((StringTemplate)StringTemplate.template("abandonTeaching.text").addStringTemplate("%unit%", label)).addNamed("%building%", school) : null);
        return template == null || this.confirm(unit.getTile(), template, unit, "abandonEducation.yes", "abandonEducation.no");
    }

    public boolean confirmClearTradeRoute(Unit unit) {
        TradeRoute tr = unit.getTradeRoute();
        if (tr == null) {
            return true;
        }
        Object template = ((StringTemplate)StringTemplate.template("clearTradeRoute.text").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL))).addName("%route%", tr.getName());
        return this.confirm(unit.getTile(), (StringTemplate)template, unit, "yes", "no");
    }

    public int confirmEuropeanTribute(Unit attacker, Colony colony, NationSummary ns) {
        int gold;
        int otherStrength;
        Player player = attacker.getOwner();
        Player other = colony.getOwner();
        int strength = player.calculateStrength(false);
        int n = otherStrength = ns == null ? strength : ns.getMilitaryStrength();
        int mil = otherStrength <= 1 || otherStrength * 5 < strength ? 0 : (strength == 0 || strength * 5 < otherStrength ? 2 : 1);
        int n2 = gold = ns == null ? 0 : ns.getGold();
        if (gold == 0) {
            Object t = StringTemplate.template("confirmTribute.broke").addStringTemplate("%nation%", other.getNationLabel());
            this.showInformationPanel((StringTemplate)t);
            return -1;
        }
        int fin = gold <= 100 ? 0 : (gold <= 1000 ? 1 : 2);
        Object t = ((StringTemplate)((StringTemplate)StringTemplate.template("confirmTribute.european").addStringTemplate("%nation%", other.getNationLabel())).addStringTemplate("%danger%", StringTemplate.template("danger." + levels[mil]))).addStringTemplate("%finance%", StringTemplate.template("finance." + levels[fin]));
        return this.showSelectTributeAmountDialog((StringTemplate)t, gold);
    }

    public boolean confirmHostileAction(Unit attacker, Tile target) {
        String messageId;
        Player enemy;
        if (attacker.hasAbility("model.ability.piracy")) {
            return true;
        }
        if (target.hasSettlement()) {
            enemy = target.getSettlement().getOwner();
        } else if (target == attacker.getTile()) {
            enemy = target.getOwner();
            if (enemy == null) {
                return true;
            }
        } else {
            Unit defender = target.getDefendingUnit(attacker);
            if (defender == null) {
                logger.warning("Attacking, but no defender - will try!");
                return true;
            }
            if (defender.hasAbility("model.ability.piracy")) {
                return true;
            }
            enemy = defender.getOwner();
        }
        switch (attacker.getOwner().getStance(enemy)) {
            case WAR: {
                logger.finest("Player at war, no confirmation needed");
                return true;
            }
            case CEASE_FIRE: {
                messageId = "confirmHostile.ceaseFire";
                break;
            }
            case ALLIANCE: {
                messageId = "confirmHostile.alliance";
                break;
            }
            default: {
                messageId = "confirmHostile.peace";
            }
        }
        Object t = StringTemplate.template(messageId).addStringTemplate("%nation%", enemy.getNationLabel());
        return this.confirm(attacker.getTile(), (StringTemplate)t, attacker, "confirmHostile.yes", "cancel");
    }

    public boolean confirmLeaveColony(Unit unit) {
        Colony colony = unit.getColony();
        StringTemplate message = colony.getReducePopulationMessage();
        if (message != null) {
            this.showInformationPanel(message);
            return false;
        }
        return this.confirmAbandonEducation(unit, true);
    }

    public int confirmNativeTribute(Unit attacker, IndianSettlement is) {
        Player player = attacker.getOwner();
        Player other = is.getOwner();
        int strength = player.calculateStrength(false);
        String messageId = other.getSettlementCount() >= strength ? "confirmTribute.unwise" : (other.getStance(player) == Stance.CEASE_FIRE ? "confirmTribute.warLikely" : (is.getAlarm(player).getLevel() == Tension.Level.HAPPY ? "confirmTribute.happy" : "confirmTribute.normal"));
        Object t = ((StringTemplate)StringTemplate.template(messageId).addStringTemplate("%settlement%", is.getLocationLabelFor(player))).addStringTemplate("%nation%", other.getNationLabel());
        return this.confirm(is.getTile(), (StringTemplate)t, attacker, "confirmTribute.yes", "confirmTribute.no") ? 1 : -1;
    }

    public boolean confirmPreCombat(Unit attacker, Tile tile) {
        if (this.getClientOptions().getBoolean("model.option.guiShowPreCombat")) {
            Settlement settlement = tile.getSettlement();
            Settlement defender = settlement != null ? settlement : tile.getDefendingUnit(attacker);
            return this.showPreCombatDialog(attacker, defender, tile);
        }
        return true;
    }

    public boolean confirmStopGame() {
        return this.confirm("stopCurrentGame.text", "stopCurrentGame.yes", "stopCurrentGame.no");
    }

    public Constants.ArmedUnitSettlementAction getArmedUnitSettlementChoice(Settlement settlement) {
        Player player = this.getMyPlayer();
        ArrayList choices = new ArrayList();
        String msg = Messages.message("armedUnitSettlement.tribute");
        choices.add(new ChoiceItem<Constants.ArmedUnitSettlementAction>(msg, Constants.ArmedUnitSettlementAction.SETTLEMENT_TRIBUTE));
        msg = Messages.message("armedUnitSettlement.attack");
        choices.add(new ChoiceItem<Constants.ArmedUnitSettlementAction>(msg, Constants.ArmedUnitSettlementAction.SETTLEMENT_ATTACK));
        return (Constants.ArmedUnitSettlementAction)((Object)this.getChoice(settlement.getTile(), settlement.getAlarmLevelLabel(player), settlement, "cancel", choices));
    }

    public Constants.BoycottAction getBoycottChoice(Goods goods, Europe europe) {
        int arrears = europe.getOwner().getArrears(goods.getType());
        Object template = ((StringTemplate)((StringTemplate)StringTemplate.template("boycottedGoods.text").addNamed("%goods%", goods)).addNamed("%europe%", europe)).addAmount("%amount%", arrears);
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<Constants.BoycottAction>(Messages.message("payArrears"), Constants.BoycottAction.BOYCOTT_PAY_ARREARS));
        choices.add(new ChoiceItem<Constants.BoycottAction>(Messages.message("boycottedGoods.dumpGoods"), Constants.BoycottAction.BOYCOTT_DUMP_CARGO));
        return (Constants.BoycottAction)((Object)this.getChoice(null, (StringTemplate)template, goods.getType(), "cancel", (List)choices));
    }

    public Constants.TradeBuyAction getBuyChoice(Unit unit, Settlement settlement, Goods goods, int gold, boolean canBuy) {
        int euroPrice = unit.getOwner().getMarket().getBidPrice(goods.getType(), goods.getAmount());
        StringTemplate nation = settlement.getOwner().getNationLabel();
        Object template = ((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("buy.text").addStringTemplate("%nation%", nation)).addStringTemplate("%goods%", goods.getLabel(true))).addAmount("%gold%", gold)).addAmount("%euprice%", euroPrice);
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<Constants.TradeBuyAction>(Messages.message("buy.takeOffer"), Constants.TradeBuyAction.BUY, canBuy));
        choices.add(new ChoiceItem<Constants.TradeBuyAction>(Messages.message("buy.moreGold"), Constants.TradeBuyAction.HAGGLE));
        return (Constants.TradeBuyAction)((Object)this.getChoice(unit.getTile(), (StringTemplate)template, goods.getType(), "cancel", (List)choices));
    }

    public final <T> T getChoice(StringTemplate explain, String cancelKey, List<ChoiceItem<T>> choices) {
        ImageIcon icon = new ImageIcon(this.getFixedImageLibrary().getPlaceholderImage());
        return this.getChoice(null, explain, icon, cancelKey, choices);
    }

    private final <T> T getChoice(Tile tile, StringTemplate template, GoodsType goodsType, String cancelKey, List<ChoiceItem<T>> choices) {
        ImageIcon icon = new ImageIcon(this.getFixedImageLibrary().getScaledGoodsTypeImage(goodsType));
        return this.getChoice(tile, template, icon, cancelKey, choices);
    }

    private final <T> T getChoice(Tile tile, StringTemplate template, Nation nation, String cancelKey, List<ChoiceItem<T>> choices) {
        ImageIcon icon = new ImageIcon(this.getFixedImageLibrary().getScaledNationImage(nation));
        return this.getChoice(tile, template, icon, cancelKey, choices);
    }

    public final <T> T getChoice(Tile tile, StringTemplate template, Settlement settlement, String cancelKey, List<ChoiceItem<T>> choices) {
        ImageIcon icon = new ImageIcon(this.getFixedImageLibrary().getScaledSettlementImage(settlement));
        return this.getChoice(tile, template, icon, cancelKey, choices);
    }

    public final <T> T getChoice(Tile tile, StringTemplate template, Unit unit, String cancelKey, List<ChoiceItem<T>> choices) {
        ImageIcon icon = new ImageIcon(this.getFixedImageLibrary().getScaledUnitImage(unit));
        return this.getChoice(tile, template, icon, cancelKey, choices);
    }

    public Constants.ClaimAction getClaimChoice(Tile tile, Player player, int price, Player owner) {
        StringTemplate template;
        ArrayList choices = new ArrayList();
        if (owner.hasContacted(player)) {
            template = StringTemplate.template("indianLand.text").addStringTemplate("%player%", owner.getNationLabel());
            Object pay = StringTemplate.template("indianLand.pay").addAmount("%amount%", price);
            choices.add(new ChoiceItem<Constants.ClaimAction>(Messages.message(pay), Constants.ClaimAction.CLAIM_ACCEPT, player.checkGold(price)));
        } else {
            template = StringTemplate.template("indianLand.unknown");
        }
        choices.add(new ChoiceItem<Constants.ClaimAction>(Messages.message("indianLand.take"), Constants.ClaimAction.CLAIM_STEAL));
        return (Constants.ClaimAction)((Object)this.getChoice(tile, template, owner.getNation(), "indianLand.cancel", choices));
    }

    public Constants.TradeAction getIndianSettlementTradeChoice(Settlement settlement, StringTemplate template, boolean canBuy, boolean canSell, boolean canGift) {
        String msg;
        ArrayList choices = new ArrayList();
        if (canBuy) {
            msg = Messages.message("tradeProposition.toBuy");
            choices.add(new ChoiceItem<Constants.TradeAction>(msg, Constants.TradeAction.BUY, canBuy));
        }
        if (canSell) {
            msg = Messages.message("tradeProposition.toSell");
            choices.add(new ChoiceItem<Constants.TradeAction>(msg, Constants.TradeAction.SELL, canSell));
        }
        if (canGift) {
            msg = Messages.message("tradeProposition.toGift");
            choices.add(new ChoiceItem<Constants.TradeAction>(msg, Constants.TradeAction.GIFT, canGift));
        }
        if (choices.isEmpty()) {
            return null;
        }
        return (Constants.TradeAction)((Object)this.getChoice(settlement.getTile(), template, settlement, "cancel", choices));
    }

    public Constants.MissionaryAction getMissionaryChoice(Unit unit, IndianSettlement is, boolean canEstablish, boolean canDenounce) {
        String msg;
        StringTemplate template;
        if (is.hasContacted(unit.getOwner())) {
            Object q = StringTemplate.template("missionarySettlement.question").addStringTemplate("%settlement%", is.getLocationLabelFor(unit.getOwner()));
            template = ((StringTemplate)StringTemplate.label("\n\n").addStringTemplate(is.getAlarmLevelLabel(unit.getOwner()))).addStringTemplate((StringTemplate)q);
        } else {
            template = StringTemplate.template("missionarySettlement.questionUncontacted");
        }
        ArrayList choices = new ArrayList();
        if (canEstablish) {
            msg = Messages.message("missionarySettlement.establish");
            choices.add(new ChoiceItem<Constants.MissionaryAction>(msg, Constants.MissionaryAction.MISSIONARY_ESTABLISH_MISSION, canEstablish));
        }
        if (canDenounce) {
            msg = Messages.message("missionarySettlement.heresy");
            choices.add(new ChoiceItem<Constants.MissionaryAction>(msg, Constants.MissionaryAction.MISSIONARY_DENOUNCE_HERESY, canDenounce));
        }
        msg = Messages.message("missionarySettlement.incite");
        choices.add(new ChoiceItem<Constants.MissionaryAction>(msg, Constants.MissionaryAction.MISSIONARY_INCITE_INDIANS));
        return (Constants.MissionaryAction)((Object)this.getChoice(unit.getTile(), template, is, "cancel", choices));
    }

    public String getNewColonyName(Player player, Tile tile) {
        String suggested = player.getSettlementName(null);
        StringTemplate t = StringTemplate.template("nameColony.text");
        String name = this.getInput(tile, t, suggested, "accept", "cancel");
        if (name != null) {
            if (name.isEmpty()) {
                this.showInformationPanel("enterSomeText");
            } else if (player.getSettlementByName(name) != null) {
                this.showInformationPanel((FreeColObject)tile, (StringTemplate)StringTemplate.template("nameColony.notUnique").addName("%name%", name));
            } else {
                return name;
            }
        }
        player.putSettlementName(suggested);
        return null;
    }

    public Constants.ScoutColonyAction getScoutForeignColonyChoice(Colony colony, Unit unit, boolean neg) {
        StringTemplate u = unit.getLabel(Unit.UnitLabelType.NATIONAL);
        Object template = ((StringTemplate)StringTemplate.template("scoutColony.text").addStringTemplate("%unit%", u)).addName("%colony%", colony.getName());
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<Constants.ScoutColonyAction>(Messages.message("scoutColony.negotiate"), Constants.ScoutColonyAction.SCOUT_COLONY_NEGOTIATE, neg));
        choices.add(new ChoiceItem<Constants.ScoutColonyAction>(Messages.message("scoutColony.spy"), Constants.ScoutColonyAction.SCOUT_COLONY_SPY));
        choices.add(new ChoiceItem<Constants.ScoutColonyAction>(Messages.message("scoutColony.attack"), Constants.ScoutColonyAction.SCOUT_COLONY_ATTACK));
        return (Constants.ScoutColonyAction)((Object)this.getChoice(unit.getTile(), (StringTemplate)template, colony, "cancel", (List)choices));
    }

    public Constants.ScoutIndianSettlementAction getScoutIndianSettlementChoice(IndianSettlement is, String numberString) {
        Object template;
        Player player = this.getMyPlayer();
        Player owner = is.getOwner();
        if (is.hasContacted(player)) {
            StringTemplate goodsPart;
            StringTemplate skillPart = is.getLearnableSkill() != null ? StringTemplate.template("scoutSettlement.skill").addNamed("%skill%", is.getLearnableSkill()) : StringTemplate.name(" ");
            int present = is.getWantedGoodsCount();
            if (present > 0) {
                goodsPart = StringTemplate.template("scoutSettlement.trade." + Integer.toString(present));
                for (int i = 0; i < present; ++i) {
                    String tradeKey = "%goods" + Integer.toString(i + 1) + "%";
                    goodsPart.addNamed(tradeKey, is.getWantedGoods(i));
                }
            } else {
                goodsPart = StringTemplate.name(" ");
            }
            IndianNationType nt = (IndianNationType)owner.getNationType();
            StringTemplate l = is.getLocationLabelFor(player);
            template = ((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("scoutSettlement.greetings").addStringTemplate("%alarmPart%", is.getAlarmLevelLabel(player))).addStringTemplate("%nation%", owner.getNationLabel())).addStringTemplate("%settlement%", l)).addName("%number%", numberString)).add("%settlementType%", nt.getSettlementTypeKey(true))).addStringTemplate("%skillPart%", skillPart)).addStringTemplate("%goodsPart%", goodsPart);
        } else {
            template = StringTemplate.template("scoutSettlement.greetUncontacted").addStringTemplate("%nation%", owner.getNationLabel());
        }
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<Constants.ScoutIndianSettlementAction>(Messages.message("scoutSettlement.speak"), Constants.ScoutIndianSettlementAction.SCOUT_SETTLEMENT_SPEAK));
        choices.add(new ChoiceItem<Constants.ScoutIndianSettlementAction>(Messages.message("scoutSettlement.tribute"), Constants.ScoutIndianSettlementAction.SCOUT_SETTLEMENT_TRIBUTE));
        choices.add(new ChoiceItem<Constants.ScoutIndianSettlementAction>(Messages.message("scoutSettlement.attack"), Constants.ScoutIndianSettlementAction.SCOUT_SETTLEMENT_ATTACK));
        return (Constants.ScoutIndianSettlementAction)((Object)this.getChoice(is.getTile(), (StringTemplate)template, is, "cancel", (List)choices));
    }

    public Constants.TradeSellAction getSellChoice(Unit unit, Settlement settlement, Goods goods, int gold) {
        int euroPrice = unit.getOwner().getMarket().getSalePrice(goods.getType(), goods.getAmount());
        StringTemplate goodsTemplate = goods.getLabel(true);
        StringTemplate nation = settlement.getOwner().getNationLabel();
        Object template = ((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("sell.text").addStringTemplate("%nation%", nation)).addStringTemplate("%goods%", goodsTemplate)).addAmount("%gold%", gold)).addAmount("%euprice%", euroPrice);
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<Constants.TradeSellAction>(Messages.message("sell.takeOffer"), Constants.TradeSellAction.SELL));
        choices.add(new ChoiceItem<Constants.TradeSellAction>(Messages.message("sell.moreGold"), Constants.TradeSellAction.HAGGLE));
        choices.add(new ChoiceItem<Constants.TradeSellAction>(Messages.message(StringTemplate.template("sell.gift").addStringTemplate("%goods%", goodsTemplate)), Constants.TradeSellAction.GIFT));
        return (Constants.TradeSellAction)((Object)this.getChoice(unit.getTile(), (StringTemplate)template, goods.getType(), "cancel", (List)choices));
    }

    public final void showDifficultyDialog() {
        Specification spec = this.getSpecification();
        this.showDifficultyDialog(spec, spec.getDifficultyOptionGroup(), false, null);
    }

    public final FreeColPanel showErrorPanel(StringTemplate template) {
        return this.showErrorPanel(template, null);
    }

    public final FreeColPanel showErrorPanel(StringTemplate template, String message) {
        return this.showErrorPanel(template, message, null);
    }

    public final FreeColPanel showErrorPanel(StringTemplate template, String message, Runnable callback) {
        Object display = Messages.message(template);
        if (message != null && FreeColDebugger.isInDebugMode()) {
            display = (String)display + "/" + message + "/";
        }
        return this.showErrorPanel((String)display, callback);
    }

    public final void showErrorPanel(Exception ex, StringTemplate template) {
        StringTemplate t = ex == null ? template : FreeCol.errorFromException(ex, template);
        this.invokeNowOrLater(() -> this.showErrorPanel(t, null, () -> {
            this.closeMenus();
            this.showMainPanel(null);
        }));
    }

    public final FreeColPanel showInformationPanel(String messageId) {
        return this.showInformationPanel(StringTemplate.key(messageId));
    }

    public final FreeColPanel showInformationPanel(StringTemplate template) {
        return this.showInformationPanel(null, template);
    }

    public final FreeColPanel showInformationPanel(FreeColObject displayObject, String messageId) {
        return this.showInformationPanel(displayObject, StringTemplate.key(messageId));
    }

    public final File showLoadSaveFileDialog(File root, String ... extension) {
        File file = this.showLoadDialog(root, extension);
        if (file != null && !file.isFile()) {
            this.showErrorPanel(FreeCol.badFile("error.noSuchFile", file));
            file = null;
        }
        return file;
    }

    public final void showNewPanel() {
        this.showNewPanel(null);
    }

    public void playSound(String sound) {
        if (sound != null && ResourceManager.getString(sound + ".type", "").equals("music")) {
            this.getFreeColClient().getSoundController().playMusic(sound);
        } else {
            this.getFreeColClient().getSoundController().playSound(sound);
        }
    }

    public String getSoundMixerLabelText() {
        return this.getFreeColClient().getSoundController().getSoundMixerLabelText();
    }

    public ImageLibrary getFixedImageLibrary() {
        return null;
    }

    public ImageLibrary getScaledImageLibrary() {
        return null;
    }

    public boolean isWindowed() {
        return true;
    }

    public void invokeNowOrLater(Runnable runnable) {
    }

    public void invokeNowOrWait(Runnable runnable) {
    }

    public void changeWindowedMode() {
    }

    public void installLookAndFeel(String fontName) throws FreeColException {
    }

    public void quitGUI() {
    }

    public void reconnectGUI(Unit active, Tile tile) {
    }

    public void removeInGameComponents() {
    }

    public void showOpeningVideo(String userMsg, Runnable callback) {
    }

    public void startGUI(Dimension desiredWindowSize) {
        logger.info("It seems that the GraphicsEnvironment is headless!");
    }

    public Dimension getMapViewDimension() {
        return null;
    }

    public void startMapEditorGUI() {
    }

    public void enableEditorToolboxPanel(boolean shouldDisplayPanel) {
    }

    public boolean isShowingMapEditorToolboxPanel() {
        return false;
    }

    public void enableEditorTransformPanel(boolean shouldDisplayPanel) {
    }

    public boolean isShowingMapEditorTransformPanel() {
        return false;
    }

    public void animateUnitAttack(Unit attacker, Unit defender, Tile attackerTile, Tile defenderTile, boolean success) {
    }

    public void animateUnitMove(Unit unit, Tile srcTile, Tile dstTile) {
    }

    public boolean confirm(Tile tile, StringTemplate template, ImageIcon icon, String okKey, String cancelKey) {
        return false;
    }

    protected <T> T getChoice(Tile tile, StringTemplate template, ImageIcon icon, String cancelKey, List<ChoiceItem<T>> choices) {
        return null;
    }

    public String getInput(Tile tile, StringTemplate template, String defaultValue, String okKey, String cancelKey) {
        return null;
    }

    public Tile getFocus() {
        return null;
    }

    public Point getFocusMapPoint() {
        return null;
    }

    public void setFocus(Tile tile) {
    }

    public void setFocusMapPoint(Point pointToFocus) {
    }

    public void setUnitPath(PathNode path) {
    }

    public void activateGotoPath() {
    }

    public void clearGotoPath() {
    }

    public boolean isGotoStarted() {
        return false;
    }

    public void performGoto(Tile tile) {
    }

    public void performGoto(int x, int y) {
    }

    public void traverseGotoPath() {
    }

    public void updateGoto(int x, int y, boolean start) {
    }

    public void prepareDrag(int x, int y) {
    }

    public boolean canZoomInMapControls() {
        return false;
    }

    public boolean canZoomOutMapControls() {
        return false;
    }

    public void enableMapControls(boolean enable) {
    }

    public void miniMapToggleFogOfWarControls() {
    }

    public void miniMapToggleViewControls() {
    }

    public void updateMapControls() {
    }

    public void zoomInMapControls() {
    }

    public void zoomOutMapControls() {
    }

    public void closeMenus() {
    }

    public void resetMapControls() {
    }

    public void resetMenuBar() {
    }

    public void updateMenuBar() {
    }

    public void showPopupMenu(JPopupMenu menu, int x, int y) {
    }

    public Direction getScrollDirection(int x, int y, int scrollSpace, boolean ignoreTop) {
        return null;
    }

    public boolean scrollMap(Direction direction, boolean performRepaints) {
        return false;
    }

    public void resetScrollSpeed() {
    }

    public void paintImmediately() {
    }

    public MapAsyncPainter useMapAsyncPainter() {
        return null;
    }

    public void stopMapAsyncPainter() {
    }

    public BufferedImage createTileImageWithBeachBorderAndItems(Tile tile) {
        return null;
    }

    public BufferedImage createTileImage(Tile tile, Player player) {
        return null;
    }

    public BufferedImage createColonyTileImage(Tile tile, Colony colony) {
        return null;
    }

    public void displayColonyTiles(Graphics2D g2d, Tile[][] tiles, Colony colony) {
    }

    public ViewMode getViewMode() {
        return ViewMode.END_TURN;
    }

    public Unit getActiveUnit() {
        return null;
    }

    public Tile getSelectedTile() {
        return null;
    }

    public void changeView(Tile tile) {
    }

    public void changeView(Unit unit, boolean force) {
    }

    public void changeView(MapTransform transform) {
    }

    public void changeView() {
    }

    public void setRangedAttackMode(boolean rangedAttackMode) {
    }

    public void toggleRangedAttackMode() {
    }

    public boolean canZoomInMap() {
        return false;
    }

    public boolean canZoomOutMap() {
        return false;
    }

    public void zoomInMap() {
    }

    public void zoomOutMap() {
    }

    public void clickAt(int count, int x, int y) {
    }

    public void closePanel(String panel) {
    }

    public void closeMainPanel() {
    }

    public void closeStatusPanel() {
    }

    public void displayChat(String sender, String message, Color color, boolean privateChat) {
    }

    public void displayObject(FreeColObject fco) {
    }

    public void displayStartChat(String sender, String message, boolean privateChat) {
    }

    public boolean isClientOptionsDialogShowing() {
        return false;
    }

    public boolean isPanelShowing() {
        return false;
    }

    public void refresh() {
    }

    public void repaint() {
    }

    public void refreshTile(Tile tile) {
    }

    public void refreshPlayersTable() {
    }

    public void removeComponent(Component component) {
    }

    public void removeDialog(FreeColDialog<?> fcd) {
    }

    public void removeTradeRoutePanel(FreeColPanel panel) {
    }

    public void restoreSavedSize(Component comp, Dimension d) {
    }

    public void showTilePopup(Tile tile) {
    }

    public Tile tileAt(int x, int y) {
        return null;
    }

    public void updateEuropeanSubpanels() {
    }

    public FreeColPanel showAboutPanel() {
        return null;
    }

    public FreeColPanel showBuildQueuePanel(Colony colony) {
        return null;
    }

    public void showCaptureGoodsDialog(Unit unit, List<Goods> gl, DialogHandler<List<Goods>> handler) {
    }

    public FreeColPanel showChatPanel() {
        return null;
    }

    public void showChooseFoundingFatherDialog(List<FoundingFather> ffs, DialogHandler<FoundingFather> handler) {
    }

    public void showClientOptionsDialog() {
    }

    public void refreshGuiUsingClientOptions() {
    }

    public FreeColPanel showColonyPanel(Colony colony, Unit unit) {
        return null;
    }

    public void showFreeColPanel(FreeColPanel panel, boolean toolBox, SwingGUI.PopupPosition popupPosition, boolean resizable) {
    }

    public FreeColPanel showColopediaPanel(String nodeId) {
        return null;
    }

    public FreeColPanel showColorChooserPanel(ActionListener al) {
        return null;
    }

    public FreeColPanel showCompactLabourReport() {
        return null;
    }

    public FreeColPanel showCompactLabourReport(LabourData.UnitData unitData) {
        return null;
    }

    public List<String> showConfirmDeclarationDialog() {
        return Collections.emptyList();
    }

    public void showDeclarationPanel(Runnable afterClosing) {
    }

    public void showDifficultyDialog(Specification spec, OptionGroup group, boolean editable, DialogHandler<OptionGroup> dialogHandler) {
    }

    public void showDumpCargoDialog(Unit unit, DialogHandler<List<Goods>> handler) {
    }

    public boolean showEditOptionDialog(Option option) {
        return false;
    }

    public IndianSettlement showEditSettlementDialog(IndianSettlement is) {
        return null;
    }

    public void showEmigrationDialog(Player player, boolean fountainOfYouth, DialogHandler<Integer> handler) {
    }

    public void showEndTurnDialog(List<Unit> units, DialogHandler<Boolean> handler) {
    }

    public FreeColPanel showErrorPanel(String message, Runnable callback) {
        return null;
    }

    public FreeColPanel showEuropePanel() {
        return null;
    }

    public FreeColPanel showEventPanel(String header, String image, String footer) {
        return null;
    }

    public FreeColPanel showFindSettlementPanel() {
        return null;
    }

    public void showFirstContactDialog(Player player, Player other, Tile tile, int settlementCount, DialogHandler<Boolean> handler) {
    }

    public void showGameOptionsDialog(boolean editable, DialogHandler<OptionGroup> dialogHandler) {
    }

    public FreeColPanel showHighScoresPanel(String messageId, List<HighScore> scores) {
        return null;
    }

    public FreeColPanel showIndianSettlementPanel(IndianSettlement is) {
        return null;
    }

    public FreeColPanel showInformationPanel(FreeColObject displayObject, StringTemplate template) {
        return null;
    }

    public File showLoadDialog(File directory, String ... extension) {
        return null;
    }

    public LoadingSavegameInfo showLoadingSavegameDialog(boolean publicServer, boolean singlePlayer) {
        return null;
    }

    public FreeColPanel showLogFilePanel() {
        return null;
    }

    public FreeColPanel showMainPanel(String userMsg) {
        return null;
    }

    public void showMainTitle() {
    }

    public void showMapGeneratorOptionsDialog(boolean editable, DialogHandler<OptionGroup> dialogHandler) {
    }

    public Dimension showMapSizeDialog() {
        return null;
    }

    public FreeColPanel showModelMessages(List<ModelMessage> modelMessages) {
        return null;
    }

    public void showMonarchDialog(Monarch.MonarchAction action, StringTemplate template, String monarchKey, DialogHandler<Boolean> handler) {
    }

    public void showNamingDialog(StringTemplate template, String defaultName, Unit unit, DialogHandler<String> handler) {
    }

    public void showNativeDemandDialog(Unit unit, Colony colony, GoodsType type, int amount, DialogHandler<Boolean> handler) {
    }

    public DiplomaticTrade showNegotiationDialog(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement, StringTemplate comment) {
        return null;
    }

    public FreeColPanel showNewPanel(Specification spec) {
        return null;
    }

    public Parameters showParametersDialog() {
        return null;
    }

    public boolean showPreCombatDialog(Unit attacker, FreeColGameObject defender, Tile tile) {
        return false;
    }

    public FreeColPanel showPurchasePanel() {
        return null;
    }

    public FreeColPanel showRecruitPanel() {
        return null;
    }

    public FreeColPanel showReportCargoPanel() {
        return null;
    }

    public FreeColPanel showReportColonyPanel() {
        return null;
    }

    public FreeColPanel showReportContinentalCongressPanel() {
        return null;
    }

    public FreeColPanel showReportEducationPanel() {
        return null;
    }

    public FreeColPanel showReportExplorationPanel() {
        return null;
    }

    public FreeColPanel showReportForeignAffairPanel() {
        return null;
    }

    public FreeColPanel showReportHistoryPanel() {
        return null;
    }

    public FreeColPanel showReportIndianPanel() {
        return null;
    }

    public FreeColPanel showReportLabourPanel() {
        return null;
    }

    public FreeColPanel showReportLabourDetailPanel(UnitType unitType, Map<UnitType, Map<Location, Integer>> data, TypeCountMap<UnitType> unitCount, List<Colony> colonies) {
        return null;
    }

    public FreeColPanel showReportMilitaryPanel() {
        return null;
    }

    public FreeColPanel showReportNavalPanel() {
        return null;
    }

    public FreeColPanel showReportProductionPanel() {
        return null;
    }

    public FreeColPanel showReportReligiousPanel() {
        return null;
    }

    public FreeColPanel showReportRequirementsPanel() {
        return null;
    }

    public FreeColPanel showReportTradePanel() {
        return null;
    }

    public FreeColPanel showReportTurnPanel(List<ModelMessage> messages) {
        return null;
    }

    public String showRiverStyleDialog(List<String> styles) {
        return null;
    }

    public File showSaveDialog(File directory, String defaultName) {
        return null;
    }

    public Dimension showScaleMapSizeDialog() {
        return null;
    }

    public int showSelectAmountDialog(GoodsType goodsType, int available, int defaultAmount, boolean needToPay) {
        return -1;
    }

    public Location showSelectDestinationDialog(Unit unit) {
        return null;
    }

    public int showSelectTributeAmountDialog(StringTemplate question, int maximum) {
        return -1;
    }

    public FreeColPanel showServerListPanel(List<ServerInfo> serverList) {
        return null;
    }

    public FreeColPanel showStartGamePanel(Game game, Player player, boolean singlePlayerMode) {
        return null;
    }

    public FreeColPanel showStatisticsPanel(Map<String, String> serverStats, Map<String, String> clientStats) {
        return null;
    }

    public FreeColPanel showStatusPanel(String message) {
        return null;
    }

    public FreeColPanel showTilePanel(Tile tile) {
        return null;
    }

    public FreeColPanel showTradeRouteInputPanel(TradeRoute tr) {
        return null;
    }

    public FreeColPanel showTradeRoutePanel(Unit unit) {
        return null;
    }

    public FreeColPanel showTrainPanel() {
        return null;
    }

    public void showVictoryDialog(DialogHandler<Boolean> handler) {
    }

    public void showWarehouseDialog(Colony colony, DialogHandler<Boolean> dialogHandler) {
    }

    public FreeColPanel showWorkProductionPanel(Unit unit) {
        return null;
    }

    public void reloadResources() {
    }

    public void prepareShowingMainMenu() {
    }

    public boolean canGameChangingModsBeAdded() {
        return true;
    }

    public void emergencyPurge() {
    }

    public void refreshScaleFactorIfNecessary() {
    }

    public static enum ViewMode {
        MOVE_UNITS,
        TERRAIN,
        MAP_TRANSFORM,
        END_TURN;

    }
}

