/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.rrd4j;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import net.i2p.rrd4j.SimpleSVGGraphics2D;
import org.rrd4j.graph.ImageWorker;

public class SimpleSVGImageWorker
extends ImageWorker {
    private SimpleSVGGraphics2D g2d;
    private AffineTransform initialAffineTransform;
    private int imgWidth;
    private int imgHeight;

    public SimpleSVGImageWorker(int width, int height) {
        this.resize(width, height);
    }

    @Override
    protected void resize(int width, int height) {
        this.imgWidth = width;
        this.imgHeight = height;
        this.g2d = new SimpleSVGGraphics2D(this.imgWidth, this.imgHeight);
        this.initialAffineTransform = this.g2d.getTransform();
        this.setG2d(this.g2d);
    }

    @Override
    protected void reset(Graphics2D g2d) {
        g2d.setTransform(this.initialAffineTransform);
        g2d.setClip(0, 0, this.imgWidth, this.imgHeight);
    }

    @Override
    protected void makeImage(OutputStream os) throws IOException {
        os.write(this.g2d.getSVG().getBytes("UTF-8"));
    }

    @Override
    protected void drawString(String text, int x, int y, Font font, Paint paint) {
        super.drawString(text.trim(), x, y, font, paint);
    }

    @Override
    protected double getStringWidth(String text, Font font) {
        return super.getStringWidth(text.trim(), font);
    }
}

