/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Ser;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.zone.ZoneRules;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ZoneOffset
extends ZoneId
implements TemporalAccessor,
TemporalAdjuster,
Comparable<ZoneOffset>,
Serializable {
    private static final ConcurrentMap<Integer, ZoneOffset> SECONDS_CACHE = new ConcurrentHashMap<Integer, ZoneOffset>(16, 0.75f, 4);
    private static final ConcurrentMap<String, ZoneOffset> ID_CACHE = new ConcurrentHashMap<String, ZoneOffset>(16, 0.75f, 4);
    private static final int MAX_SECONDS = 64800;
    private static final long serialVersionUID = 2357656521762053153L;
    public static final ZoneOffset UTC = ZoneOffset.ofTotalSeconds(0);
    public static final ZoneOffset MIN = ZoneOffset.ofTotalSeconds(-64800);
    public static final ZoneOffset MAX = ZoneOffset.ofTotalSeconds(64800);
    private final int totalSeconds;
    private final transient String id;

    public static ZoneOffset of(String string) {
        int n;
        int n2;
        int n3;
        Objects.requireNonNull(string, "offsetId");
        ZoneOffset zoneOffset = (ZoneOffset)ID_CACHE.get(string);
        if (zoneOffset != null) {
            return zoneOffset;
        }
        switch (string.length()) {
            case 2: {
                string = string.charAt(0) + "0" + string.charAt(1);
            }
            case 3: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = 0;
                n = 0;
                break;
            }
            case 5: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = ZoneOffset.parseNumber(string, 3, false);
                n = 0;
                break;
            }
            case 6: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = ZoneOffset.parseNumber(string, 4, true);
                n = 0;
                break;
            }
            case 7: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = ZoneOffset.parseNumber(string, 3, false);
                n = ZoneOffset.parseNumber(string, 5, false);
                break;
            }
            case 9: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = ZoneOffset.parseNumber(string, 4, true);
                n = ZoneOffset.parseNumber(string, 7, true);
                break;
            }
            default: {
                throw new DateTimeException("Invalid ID for ZoneOffset, invalid format: " + string);
            }
        }
        char c = string.charAt(0);
        if (c != '+' && c != '-') {
            throw new DateTimeException("Invalid ID for ZoneOffset, plus/minus not found when expected: " + string);
        }
        if (c == '-') {
            return ZoneOffset.ofHoursMinutesSeconds(-n3, -n2, -n);
        }
        return ZoneOffset.ofHoursMinutesSeconds(n3, n2, n);
    }

    private static int parseNumber(CharSequence charSequence, int n, boolean bl) {
        if (bl && charSequence.charAt(n - 1) != ':') {
            throw new DateTimeException("Invalid ID for ZoneOffset, colon not found when expected: " + charSequence);
        }
        char c = charSequence.charAt(n);
        char c2 = charSequence.charAt(n + 1);
        if (c < '0' || c > '9' || c2 < '0' || c2 > '9') {
            throw new DateTimeException("Invalid ID for ZoneOffset, non numeric characters found: " + charSequence);
        }
        return (c - 48) * 10 + (c2 - 48);
    }

    public static ZoneOffset ofHours(int n) {
        return ZoneOffset.ofHoursMinutesSeconds(n, 0, 0);
    }

    public static ZoneOffset ofHoursMinutes(int n, int n2) {
        return ZoneOffset.ofHoursMinutesSeconds(n, n2, 0);
    }

    public static ZoneOffset ofHoursMinutesSeconds(int n, int n2, int n3) {
        ZoneOffset.validate(n, n2, n3);
        int n4 = ZoneOffset.totalSeconds(n, n2, n3);
        return ZoneOffset.ofTotalSeconds(n4);
    }

    public static ZoneOffset from(TemporalAccessor temporalAccessor) {
        Objects.requireNonNull(temporalAccessor, "temporal");
        ZoneOffset zoneOffset = temporalAccessor.query(TemporalQueries.offset());
        if (zoneOffset == null) {
            throw new DateTimeException("Unable to obtain ZoneOffset from TemporalAccessor: " + temporalAccessor + " of type " + temporalAccessor.getClass().getName());
        }
        return zoneOffset;
    }

    private static void validate(int n, int n2, int n3) {
        if (n < -18 || n > 18) {
            throw new DateTimeException("Zone offset hours not in valid range: value " + n + " is not in the range -18 to 18");
        }
        if (n > 0) {
            if (n2 < 0 || n3 < 0) {
                throw new DateTimeException("Zone offset minutes and seconds must be positive because hours is positive");
            }
        } else if (n < 0) {
            if (n2 > 0 || n3 > 0) {
                throw new DateTimeException("Zone offset minutes and seconds must be negative because hours is negative");
            }
        } else if (n2 > 0 && n3 < 0 || n2 < 0 && n3 > 0) {
            throw new DateTimeException("Zone offset minutes and seconds must have the same sign");
        }
        if (n2 < -59 || n2 > 59) {
            throw new DateTimeException("Zone offset minutes not in valid range: value " + n2 + " is not in the range -59 to 59");
        }
        if (n3 < -59 || n3 > 59) {
            throw new DateTimeException("Zone offset seconds not in valid range: value " + n3 + " is not in the range -59 to 59");
        }
        if (Math.abs(n) == 18 && (n2 | n3) != 0) {
            throw new DateTimeException("Zone offset not in valid range: -18:00 to +18:00");
        }
    }

    private static int totalSeconds(int n, int n2, int n3) {
        return n * 3600 + n2 * 60 + n3;
    }

    public static ZoneOffset ofTotalSeconds(int n) {
        if (n < -64800 || n > 64800) {
            throw new DateTimeException("Zone offset not in valid range: -18:00 to +18:00");
        }
        if (n % 900 == 0) {
            Integer n2 = n;
            ZoneOffset zoneOffset = (ZoneOffset)SECONDS_CACHE.get(n2);
            if (zoneOffset == null) {
                zoneOffset = new ZoneOffset(n);
                SECONDS_CACHE.putIfAbsent(n2, zoneOffset);
                zoneOffset = (ZoneOffset)SECONDS_CACHE.get(n2);
                ID_CACHE.putIfAbsent(zoneOffset.getId(), zoneOffset);
            }
            return zoneOffset;
        }
        return new ZoneOffset(n);
    }

    private ZoneOffset(int n) {
        this.totalSeconds = n;
        this.id = ZoneOffset.buildId(n);
    }

    private static String buildId(int n) {
        if (n == 0) {
            return "Z";
        }
        int n2 = Math.abs(n);
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n2 / 3600;
        int n4 = n2 / 60 % 60;
        stringBuilder.append(n < 0 ? "-" : "+").append(n3 < 10 ? "0" : "").append(n3).append(n4 < 10 ? ":0" : ":").append(n4);
        int n5 = n2 % 60;
        if (n5 != 0) {
            stringBuilder.append(n5 < 10 ? ":0" : ":").append(n5);
        }
        return stringBuilder.toString();
    }

    public int getTotalSeconds() {
        return this.totalSeconds;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ZoneRules getRules() {
        return ZoneRules.of(this);
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField == ChronoField.OFFSET_SECONDS;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        return TemporalAccessor.super.range(temporalField);
    }

    @Override
    public int get(TemporalField temporalField) {
        if (temporalField == ChronoField.OFFSET_SECONDS) {
            return this.totalSeconds;
        }
        if (temporalField instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return this.range(temporalField).checkValidIntValue(this.getLong(temporalField), temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField == ChronoField.OFFSET_SECONDS) {
            return this.totalSeconds;
        }
        if (temporalField instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.getFrom(this);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.zone()) {
            return (R)this;
        }
        return TemporalAccessor.super.query(temporalQuery);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.OFFSET_SECONDS, this.totalSeconds);
    }

    @Override
    public int compareTo(ZoneOffset zoneOffset) {
        return zoneOffset.totalSeconds - this.totalSeconds;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZoneOffset) {
            return this.totalSeconds == ((ZoneOffset)object).totalSeconds;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.totalSeconds;
    }

    @Override
    public String toString() {
        return this.id;
    }

    private Object writeReplace() {
        return new Ser(8, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    @Override
    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(8);
        this.writeExternal(dataOutput);
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        int n = this.totalSeconds;
        int n2 = n % 900 == 0 ? n / 900 : 127;
        dataOutput.writeByte(n2);
        if (n2 == 127) {
            dataOutput.writeInt(n);
        }
    }

    static ZoneOffset readExternal(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        return by == 127 ? ZoneOffset.ofTotalSeconds(dataInput.readInt()) : ZoneOffset.ofTotalSeconds(by * 900);
    }
}

