/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.innate.http;

import jakarta.ws.rs.core.UriBuilder;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.innate.http.SniConfigurator;

public final class SSLParamConfigurator {
    private final URI uri;
    private final Map<String, List<Object>> httpHeaders;
    private final Optional<SniConfigurator> sniConfigurator;

    private SSLParamConfigurator(Builder builder2) {
        this.uri = builder2.clientRequest != null ? builder2.clientRequest.getUri() : builder2.uri;
        this.httpHeaders = builder2.clientRequest != null ? builder2.clientRequest.getHeaders() : builder2.httpHeaders;
        this.sniConfigurator = SniConfigurator.createWhenHostHeader(this.uri, this.httpHeaders, builder2.setAlways);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSNIHostName() {
        return this.sniConfigurator.isPresent() ? this.sniConfigurator.get().getHostName() : this.uri.getHost();
    }

    public URI toIPRequestUri() {
        String host = this.uri.getHost();
        try {
            InetAddress ip = InetAddress.getByName(host);
            return UriBuilder.fromUri(this.uri).host(ip.getHostAddress()).build(new Object[0]);
        }
        catch (UnknownHostException e) {
            return this.uri;
        }
    }

    public boolean isSNIRequired() {
        return this.sniConfigurator.isPresent();
    }

    public URI getSNIUri() {
        return this.sniConfigurator.isPresent() ? UriBuilder.fromUri(this.uri).host(this.getSNIHostName()).build(new Object[0]) : this.uri;
    }

    public void setSNIServerName(SSLEngine sslEngine) {
        this.sniConfigurator.ifPresent(sni -> sni.setServerNames(sslEngine));
    }

    public void setSNIServerName(SSLSocket sslSocket) {
        this.sniConfigurator.ifPresent(sni -> sni.setServerNames(sslSocket));
    }

    public void setEndpointIdentificationAlgorithm(SSLEngine sslEngine) {
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        sslEngine.setSSLParameters(sslParameters);
    }

    public static final class Builder {
        private ClientRequest clientRequest;
        private URI uri;
        private Map<String, List<Object>> httpHeaders;
        private boolean setAlways = false;

        public Builder request(ClientRequest clientRequest) {
            this.clientRequest = clientRequest;
            this.httpHeaders = null;
            this.uri = null;
            return this;
        }

        public Builder uri(URI uri) {
            this.clientRequest = null;
            this.uri = uri;
            return this;
        }

        public Builder headers(Map<String, List<Object>> httpHeaders) {
            this.clientRequest = null;
            this.httpHeaders = httpHeaders;
            return this;
        }

        public Builder setSNIAlways(boolean setAlways) {
            this.setAlways = setAlways;
            return this;
        }

        public SSLParamConfigurator build() {
            return new SSLParamConfigurator(this);
        }
    }
}

