/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc;

import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.ParsedVideoPacket;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.cc.AdaptiveSourceProjectionContext;
import org.jitsi.videobridge.cc.RtpState;
import org.json.simple.JSONObject;

class GenericAdaptiveSourceProjectionContext
implements AdaptiveSourceProjectionContext {
    private final Logger logger;
    private final long ssrc;
    private boolean needsKeyframe = true;
    private final int payloadType;
    private int maxDestinationSequenceNumber;
    private long timestampDelta;
    private boolean timestampDeltaInitialized = false;
    private long maxDestinationTimestamp;
    private int sequenceNumberDelta;

    GenericAdaptiveSourceProjectionContext(int payloadType, @NotNull RtpState rtpState, @NotNull Logger parentLogger) {
        this.payloadType = payloadType;
        this.ssrc = rtpState.ssrc;
        this.maxDestinationSequenceNumber = rtpState.maxSequenceNumber;
        this.maxDestinationTimestamp = rtpState.maxTimestamp;
        this.logger = parentLogger.createChildLogger(GenericAdaptiveSourceProjectionContext.class.getName());
    }

    @Override
    public synchronized boolean accept(@NotNull PacketInfo packetInfo, int targetIndex) {
        int destinationSequenceNumber;
        boolean accept;
        VideoRtpPacket rtpPacket = (VideoRtpPacket)packetInfo.packetAs();
        if (targetIndex == -1) {
            this.needsKeyframe = true;
            return false;
        }
        int sourceSequenceNumber = rtpPacket.getSequenceNumber();
        if (this.needsKeyframe) {
            if (!(rtpPacket instanceof ParsedVideoPacket)) {
                this.needsKeyframe = false;
                accept = true;
            } else if (((ParsedVideoPacket)rtpPacket).isKeyframe()) {
                this.needsKeyframe = false;
                destinationSequenceNumber = this.maxDestinationSequenceNumber + 1;
                this.sequenceNumberDelta = RtpUtils.getSequenceNumberDelta(destinationSequenceNumber, sourceSequenceNumber);
                this.logger.trace(() -> "delta ssrc=" + rtpPacket.getSsrc() + ",src_sequence=" + sourceSequenceNumber + ",dst_sequence=" + destinationSequenceNumber + ",max_sequence=" + this.maxDestinationSequenceNumber + ",delta=" + this.sequenceNumberDelta);
                accept = true;
            } else {
                accept = false;
            }
        } else {
            accept = true;
        }
        if (accept) {
            this.maybeInitializeTimestampDelta(rtpPacket.getTimestamp());
            destinationSequenceNumber = RtpUtils.applySequenceNumberDelta(sourceSequenceNumber, this.sequenceNumberDelta);
            long destinationTimestamp = RtpUtils.applyTimestampDelta(rtpPacket.getTimestamp(), this.timestampDelta);
            if (RtpUtils.isOlderSequenceNumberThan(this.maxDestinationSequenceNumber, destinationSequenceNumber)) {
                this.maxDestinationSequenceNumber = destinationSequenceNumber;
            }
            if (RtpUtils.isNewerTimestampThan(destinationTimestamp, this.maxDestinationTimestamp)) {
                this.maxDestinationTimestamp = destinationTimestamp;
            }
            this.logger.trace(() -> "accept ssrc=" + rtpPacket.getSsrc() + ",src_sequence=" + sourceSequenceNumber + ",dst_sequence=" + destinationSequenceNumber + ",max_sequence=" + this.maxDestinationSequenceNumber);
        } else {
            this.logger.trace(() -> "reject ssrc=" + rtpPacket.getSsrc() + ",src_sequence=" + sourceSequenceNumber);
        }
        return accept;
    }

    private synchronized void maybeInitializeTimestampDelta(long sourceTimestamp) {
        if (this.timestampDeltaInitialized) {
            return;
        }
        if (RtpUtils.isNewerTimestampThan(this.maxDestinationTimestamp, sourceTimestamp)) {
            long destinationTimestamp = RtpUtils.applyTimestampDelta(this.maxDestinationTimestamp, 3000L);
            this.timestampDelta = RtpUtils.getTimestampDiff(destinationTimestamp, sourceTimestamp);
        }
        this.timestampDeltaInitialized = true;
    }

    @Override
    public boolean needsKeyframe() {
        return this.needsKeyframe;
    }

    @Override
    public void rewriteRtp(@NotNull PacketInfo packetInfo) {
        long destinationTimestamp;
        long sourceTimestamp;
        int destinationSequenceNumber;
        VideoRtpPacket rtpPacket = (VideoRtpPacket)packetInfo.packetAs();
        int sourceSequenceNumber = rtpPacket.getSequenceNumber();
        if (sourceSequenceNumber != (destinationSequenceNumber = RtpUtils.applySequenceNumberDelta(sourceSequenceNumber, this.sequenceNumberDelta))) {
            rtpPacket.setSequenceNumber(destinationSequenceNumber);
        }
        if ((sourceTimestamp = rtpPacket.getTimestamp()) != (destinationTimestamp = RtpUtils.applyTimestampDelta(sourceTimestamp, this.timestampDelta))) {
            rtpPacket.setTimestamp(destinationTimestamp);
        }
        this.logger.debug(() -> "rewrite ssrc=" + rtpPacket.getSsrc() + ",src_sequence=" + sourceSequenceNumber + ",dst_sequence=" + destinationSequenceNumber + ",max_sequence=" + this.maxDestinationSequenceNumber);
    }

    @Override
    public boolean rewriteRtcp(@NotNull RtcpSrPacket rtcpSrPacket) {
        return true;
    }

    @Override
    public RtpState getRtpState() {
        return new RtpState(this.ssrc, this.maxDestinationSequenceNumber, this.maxDestinationTimestamp);
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    @Override
    public JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        debugState.put("class", GenericAdaptiveSourceProjectionContext.class.getSimpleName());
        debugState.put("TODO", "export more state (or refactor)");
        return debugState;
    }
}

