/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.Objects;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.PathException;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.spi.NavigablePath;

public class SqmIndexedCollectionAccessPath<T>
extends AbstractSqmPath<T>
implements SqmPath<T> {
    private final SqmExpression<?> selectorExpression;

    public SqmIndexedCollectionAccessPath(NavigablePath navigablePath, SqmPath<?> pluralDomainPath, SqmExpression<?> selectorExpression) {
        super(navigablePath, ((SqmPluralPersistentAttribute)pluralDomainPath.getReferencedPathSource()).getElementPathSource(), pluralDomainPath, pluralDomainPath.nodeBuilder());
        this.selectorExpression = selectorExpression;
    }

    @Override
    public SqmIndexedCollectionAccessPath<T> copy(SqmCopyContext context) {
        SqmIndexedCollectionAccessPath existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmExpression lhsCopy = this.getLhs().copy(context);
        SqmIndexedCollectionAccessPath<T> path = context.registerCopy(this, new SqmIndexedCollectionAccessPath<T>(this.getNavigablePathCopy((SqmPath<?>)lhsCopy), (SqmPath<?>)lhsCopy, (SqmExpression<?>)this.selectorExpression.copy(context)));
        this.copyTo(path, context);
        return path;
    }

    public SqmExpression<?> getSelectorExpression() {
        return this.selectorExpression;
    }

    public PluralPersistentAttribute<?, ?, T> getPluralAttribute() {
        return (PluralPersistentAttribute)((Object)this.getLhs().getReferencedPathSource());
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        SqmPath sqmPath = this.get(name, true);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register(sqmPath);
        return sqmPath;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitIndexedPluralAccessPath(this);
    }

    @Override
    public <S extends T> SqmTreatedPath<T, S> treatAs(Class<S> treatJavaType) throws PathException {
        return this.treatAs((EntityDomainType)this.nodeBuilder().getDomainModel().entity(treatJavaType));
    }

    @Override
    public <S extends T> SqmTreatedPath<T, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        if (this.getReferencedPathSource().getPathType() instanceof EntityDomainType) {
            return this.getTreatedPath(treatTarget);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.getLhs().appendHqlString(hql, context);
        hql.append('[');
        this.selectorExpression.appendHqlString(hql, context);
        hql.append(']');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SqmIndexedCollectionAccessPath)) return false;
        SqmIndexedCollectionAccessPath that = (SqmIndexedCollectionAccessPath)object;
        if (!Objects.equals(this.getExplicitAlias(), that.getExplicitAlias())) return false;
        if (!Objects.equals(this.getLhs(), that.getLhs())) return false;
        if (!Objects.equals(this.selectorExpression, that.selectorExpression)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getLhs(), this.selectorExpression);
    }
}

