/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.bin2json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.igormaznitsa.jbbp.JBBPParser;
import com.igormaznitsa.jbbp.exceptions.JBBPException;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayBit;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayBoolean;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayInt;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayLong;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayShort;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayStruct;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUShort;
import com.igormaznitsa.jbbp.model.JBBPFieldBit;
import com.igormaznitsa.jbbp.model.JBBPFieldBoolean;
import com.igormaznitsa.jbbp.model.JBBPFieldByte;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.model.JBBPFieldLong;
import com.igormaznitsa.jbbp.model.JBBPFieldShort;
import com.igormaznitsa.jbbp.model.JBBPFieldStruct;
import com.igormaznitsa.jbbp.model.JBBPFieldUByte;
import com.igormaznitsa.jbbp.model.JBBPFieldUShort;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.LocalDateTime;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.bin2json.ConversionException;
import org.openhab.core.util.HexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class Bin2Json {
    private final Logger logger = LoggerFactory.getLogger(Bin2Json.class);
    private final JBBPParser parser;

    public Bin2Json(String parserRule) throws ConversionException {
        try {
            this.parser = JBBPParser.prepare((String)parserRule);
        }
        catch (JBBPException e) {
            throw new ConversionException(String.format("Illegal parser rule, reason: %s", e.getMessage()), e);
        }
    }

    public JsonObject convert(String hexString) throws ConversionException {
        try {
            return this.convert(HexUtils.hexToBytes((String)hexString));
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException(String.format("Illegal hexstring , reason: %s", e.getMessage()), e);
        }
    }

    public JsonObject convert(byte[] data) throws ConversionException {
        try {
            return this.convert(this.parser.parse(data));
        }
        catch (JBBPException | IOException e) {
            throw new ConversionException(String.format("Unexpected error, reason: %s", e.getMessage()), e);
        }
    }

    public JsonObject convert(InputStream inputStream) throws ConversionException {
        try {
            return this.convert(this.parser.parse(inputStream));
        }
        catch (JBBPException | IOException e) {
            throw new ConversionException(String.format("Unexpected error, reason: %s", e.getMessage()), e);
        }
    }

    private JsonObject convert(JBBPFieldStruct data) throws ConversionException {
        try {
            LocalDateTime start = LocalDateTime.now();
            JsonObject json = this.convertToJSon((JBBPAbstractField)data);
            if (this.logger.isTraceEnabled()) {
                Duration duration = Duration.between(start, LocalDateTime.now());
                this.logger.trace("Conversion time={}, json={}", (Object)duration, (Object)json);
            }
            return json;
        }
        catch (JBBPException e) {
            throw new ConversionException(String.format("Unexpected error, reason: %s", e.getMessage()), e);
        }
    }

    private JsonObject convertToJSon(JBBPAbstractField field) throws ConversionException {
        return this.convertToJSon(null, field);
    }

    /*
     * WARNING - void declaration
     */
    private JsonObject convertToJSon(@Nullable JsonObject json, JBBPAbstractField field) throws ConversionException {
        String fieldName;
        JsonObject jsn = json == null ? new JsonObject() : json;
        String string = fieldName = field.getFieldName() == null ? "nonamed" : field.getFieldName();
        if (field instanceof JBBPAbstractArrayField) {
            JsonArray jsonArray = new JsonArray();
            JBBPAbstractField jBBPAbstractField = field;
            if (jBBPAbstractField instanceof JBBPFieldArrayBit) {
                void bit;
                JBBPFieldArrayBit jBBPFieldArrayBit = (JBBPFieldArrayBit)jBBPAbstractField;
                JBBPFieldArrayBit cfr_ignored_0 = (JBBPFieldArrayBit)jBBPAbstractField;
                byte[] byArray = bit.getArray();
                int n = byArray.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    jsonArray.add((JsonElement)new JsonPrimitive((Number)b));
                    ++n2;
                }
            } else {
                JBBPAbstractField jBBPAbstractField2 = field;
                if (jBBPAbstractField2 instanceof JBBPFieldArrayBoolean) {
                    void boolean1;
                    JBBPFieldArrayBoolean b = (JBBPFieldArrayBoolean)jBBPAbstractField2;
                    JBBPFieldArrayBoolean cfr_ignored_1 = (JBBPFieldArrayBoolean)jBBPAbstractField2;
                    boolean[] blArray = boolean1.getArray();
                    int n = blArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        boolean b2 = blArray[n3];
                        jsonArray.add((JsonElement)new JsonPrimitive(Boolean.valueOf(b2)));
                        ++n3;
                    }
                } else {
                    JBBPAbstractField jBBPAbstractField3 = field;
                    if (jBBPAbstractField3 instanceof JBBPFieldArrayByte) {
                        void byte1;
                        JBBPFieldArrayByte b2 = (JBBPFieldArrayByte)jBBPAbstractField3;
                        JBBPFieldArrayByte cfr_ignored_2 = (JBBPFieldArrayByte)jBBPAbstractField3;
                        byte[] byArray = byte1.getArray();
                        int n = byArray.length;
                        int n4 = 0;
                        while (n4 < n) {
                            byte b = byArray[n4];
                            jsonArray.add((JsonElement)new JsonPrimitive((Number)b));
                            ++n4;
                        }
                    } else {
                        JBBPAbstractField jBBPAbstractField4 = field;
                        if (jBBPAbstractField4 instanceof JBBPFieldArrayInt) {
                            void int1;
                            JBBPFieldArrayInt b = (JBBPFieldArrayInt)jBBPAbstractField4;
                            JBBPFieldArrayInt cfr_ignored_3 = (JBBPFieldArrayInt)jBBPAbstractField4;
                            int[] nArray = int1.getArray();
                            int n = nArray.length;
                            int n5 = 0;
                            while (n5 < n) {
                                int b3 = nArray[n5];
                                jsonArray.add((JsonElement)new JsonPrimitive((Number)b3));
                                ++n5;
                            }
                        } else {
                            JBBPAbstractField jBBPAbstractField5 = field;
                            if (jBBPAbstractField5 instanceof JBBPFieldArrayLong) {
                                void long1;
                                JBBPFieldArrayLong b3 = (JBBPFieldArrayLong)jBBPAbstractField5;
                                JBBPFieldArrayLong cfr_ignored_4 = (JBBPFieldArrayLong)jBBPAbstractField5;
                                long[] lArray = long1.getArray();
                                int n = lArray.length;
                                int n6 = 0;
                                while (n6 < n) {
                                    long b = lArray[n6];
                                    jsonArray.add((JsonElement)new JsonPrimitive((Number)b));
                                    ++n6;
                                }
                            } else {
                                JBBPAbstractField jBBPAbstractField6 = field;
                                if (jBBPAbstractField6 instanceof JBBPFieldArrayShort) {
                                    void short1;
                                    JBBPFieldArrayShort b = (JBBPFieldArrayShort)jBBPAbstractField6;
                                    JBBPFieldArrayShort cfr_ignored_5 = (JBBPFieldArrayShort)jBBPAbstractField6;
                                    short[] sArray = short1.getArray();
                                    int n = sArray.length;
                                    int n7 = 0;
                                    while (n7 < n) {
                                        short b4 = sArray[n7];
                                        jsonArray.add((JsonElement)new JsonPrimitive((Number)b4));
                                        ++n7;
                                    }
                                } else {
                                    JBBPAbstractField jBBPAbstractField7 = field;
                                    if (jBBPAbstractField7 instanceof JBBPFieldArrayStruct) {
                                        void array;
                                        JBBPFieldArrayStruct b4 = (JBBPFieldArrayStruct)jBBPAbstractField7;
                                        JBBPFieldArrayStruct cfr_ignored_6 = (JBBPFieldArrayStruct)jBBPAbstractField7;
                                        int i = 0;
                                        while (i < array.size()) {
                                            jsonArray.add((JsonElement)this.convertToJSon(new JsonObject(), (JBBPAbstractField)array.getElementAt(i)));
                                            ++i;
                                        }
                                    } else {
                                        JBBPAbstractField jBBPAbstractField8 = field;
                                        if (jBBPAbstractField8 instanceof JBBPFieldArrayUByte) {
                                            void byte1;
                                            JBBPFieldArrayUByte i = (JBBPFieldArrayUByte)jBBPAbstractField8;
                                            JBBPFieldArrayUByte cfr_ignored_7 = (JBBPFieldArrayUByte)jBBPAbstractField8;
                                            byte[] byArray = byte1.getArray();
                                            int n = byArray.length;
                                            int n8 = 0;
                                            while (n8 < n) {
                                                byte b = byArray[n8];
                                                jsonArray.add((JsonElement)new JsonPrimitive((Number)(b & 0xFF)));
                                                ++n8;
                                            }
                                        } else {
                                            JBBPAbstractField jBBPAbstractField9 = field;
                                            if (jBBPAbstractField9 instanceof JBBPFieldArrayUShort) {
                                                void short1;
                                                JBBPFieldArrayUShort b = (JBBPFieldArrayUShort)jBBPAbstractField9;
                                                JBBPFieldArrayUShort cfr_ignored_8 = (JBBPFieldArrayUShort)jBBPAbstractField9;
                                                short[] sArray = short1.getArray();
                                                int n = sArray.length;
                                                int n9 = 0;
                                                while (n9 < n) {
                                                    short b5 = sArray[n9];
                                                    jsonArray.add((JsonElement)new JsonPrimitive((Number)(b5 & 0xFFFF)));
                                                    ++n9;
                                                }
                                            } else {
                                                throw new ConversionException(String.format("Unexpected field type '%s'", field));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            jsn.add(fieldName, (JsonElement)jsonArray);
        } else {
            JBBPAbstractField jBBPAbstractField = field;
            if (jBBPAbstractField instanceof JBBPFieldBit) {
                void bit;
                JBBPFieldBit jsonArray = (JBBPFieldBit)jBBPAbstractField;
                JBBPFieldBit cfr_ignored_9 = (JBBPFieldBit)jBBPAbstractField;
                jsn.addProperty(fieldName, (Number)bit.getAsInt());
            } else {
                JBBPAbstractField jBBPAbstractField10 = field;
                if (jBBPAbstractField10 instanceof JBBPFieldBoolean) {
                    void boolean1;
                    JBBPFieldBoolean jBBPFieldBoolean = (JBBPFieldBoolean)jBBPAbstractField10;
                    JBBPFieldBoolean cfr_ignored_10 = (JBBPFieldBoolean)jBBPAbstractField10;
                    jsn.addProperty(fieldName, Boolean.valueOf(boolean1.getAsBool()));
                } else {
                    JBBPAbstractField jBBPAbstractField11 = field;
                    if (jBBPAbstractField11 instanceof JBBPFieldByte) {
                        void byte1;
                        JBBPFieldByte jBBPFieldByte = (JBBPFieldByte)jBBPAbstractField11;
                        JBBPFieldByte cfr_ignored_11 = (JBBPFieldByte)jBBPAbstractField11;
                        jsn.addProperty(fieldName, (Number)byte1.getAsInt());
                    } else {
                        JBBPAbstractField jBBPAbstractField12 = field;
                        if (jBBPAbstractField12 instanceof JBBPFieldInt) {
                            void int1;
                            JBBPFieldInt jBBPFieldInt = (JBBPFieldInt)jBBPAbstractField12;
                            JBBPFieldInt cfr_ignored_12 = (JBBPFieldInt)jBBPAbstractField12;
                            jsn.addProperty(fieldName, (Number)int1.getAsInt());
                        } else {
                            JBBPAbstractField jBBPAbstractField13 = field;
                            if (jBBPAbstractField13 instanceof JBBPFieldLong) {
                                void long1;
                                JBBPFieldLong jBBPFieldLong = (JBBPFieldLong)jBBPAbstractField13;
                                JBBPFieldLong cfr_ignored_13 = (JBBPFieldLong)jBBPAbstractField13;
                                jsn.addProperty(fieldName, (Number)long1.getAsLong());
                            } else {
                                JBBPAbstractField jBBPAbstractField14 = field;
                                if (jBBPAbstractField14 instanceof JBBPFieldShort) {
                                    void short1;
                                    JBBPFieldShort jBBPFieldShort = (JBBPFieldShort)jBBPAbstractField14;
                                    JBBPFieldShort cfr_ignored_14 = (JBBPFieldShort)jBBPAbstractField14;
                                    jsn.addProperty(fieldName, (Number)short1.getAsInt());
                                } else {
                                    JBBPAbstractField jBBPAbstractField15 = field;
                                    if (jBBPAbstractField15 instanceof JBBPFieldStruct) {
                                        void struct;
                                        JBBPFieldStruct jBBPFieldStruct = (JBBPFieldStruct)jBBPAbstractField15;
                                        JBBPFieldStruct cfr_ignored_15 = (JBBPFieldStruct)jBBPAbstractField15;
                                        JsonObject obj = new JsonObject();
                                        JBBPAbstractField[] jBBPAbstractFieldArray = struct.getArray();
                                        int n = jBBPAbstractFieldArray.length;
                                        int n10 = 0;
                                        while (n10 < n) {
                                            JBBPAbstractField f = jBBPAbstractFieldArray[n10];
                                            this.convertToJSon(obj, f);
                                            ++n10;
                                        }
                                        if (json == null) {
                                            return obj;
                                        }
                                        jsn.add(fieldName, (JsonElement)obj);
                                    } else {
                                        JBBPAbstractField jBBPAbstractField16 = field;
                                        if (jBBPAbstractField16 instanceof JBBPFieldUByte) {
                                            void byte1;
                                            JBBPFieldUByte obj = (JBBPFieldUByte)jBBPAbstractField16;
                                            JBBPFieldUByte cfr_ignored_16 = (JBBPFieldUByte)jBBPAbstractField16;
                                            jsn.addProperty(fieldName, (Number)byte1.getAsInt());
                                        } else {
                                            JBBPAbstractField jBBPAbstractField17 = field;
                                            if (jBBPAbstractField17 instanceof JBBPFieldUShort) {
                                                void short1;
                                                JBBPFieldUShort jBBPFieldUShort = (JBBPFieldUShort)jBBPAbstractField17;
                                                JBBPFieldUShort cfr_ignored_17 = (JBBPFieldUShort)jBBPAbstractField17;
                                                jsn.addProperty(fieldName, (Number)short1.getAsInt());
                                            } else {
                                                throw new ConversionException(String.format("Unexpected field '%s'", field));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return jsn;
    }
}

