"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visNLQSavedObjectType = void 0;
var _vis_type_nlq = require("../../common/constants/vis_type_nlq");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const visNLQSavedObjectType = exports.visNLQSavedObjectType = {
  name: _vis_type_nlq.VIS_NLQ_SAVED_OBJECT,
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'title',
    importableAndExportable: true,
    getTitle: ({
      attributes: {
        title
      }
    }) => title,
    getInAppUrl({
      id
    }) {
      return {
        path: `/app/text2viz/edit/${encodeURIComponent(id)}`,
        uiCapabilitiesPath: `${_vis_type_nlq.VIS_NLQ_SAVED_OBJECT}.show`
      };
    }
  },
  migrations: {},
  mappings: {
    properties: {
      title: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      visualizationState: {
        type: 'text',
        index: false
      },
      uiState: {
        type: 'text',
        index: false
      },
      version: {
        type: 'integer'
      },
      kibanaSavedObjectMeta: {
        properties: {
          searchSourceJSON: {
            type: 'text',
            index: false
          }
        }
      }
    }
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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