"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MDSEnabledClientService = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class MDSEnabledClientService {
  constructor(osDriver, dataSourceEnabled) {
    this.osDriver = osDriver;
    this.dataSourceEnabled = dataSourceEnabled;
  }
  getClient(request, context) {
    const dataSourceId = request.query.dataSourceId;
    return this.dataSourceEnabled && dataSourceId ? context.dataSource.opensearch.legacy.getClient(dataSourceId.toString()).callAPI : this.osDriver.asScoped(request).callAsCurrentUser;
  }
}
exports.MDSEnabledClientService = MDSEnabledClientService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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