"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.corePlugin = corePlugin;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function corePlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.coreClient = components.clientAction.namespaceFactory();
  const coreClient = Client.prototype.coreClient.prototype;
  coreClient.getSearchPipeline = ca({
    url: {
      fmt: `${_common.SEARCH_PIPELINE_ROUTE}/<%=pipeline_id%>`,
      req: {
        pipeline_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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