/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u + uvec2(38u, 35u)) => uvec2(38u, 35u)
 * (0u + uvec2(64u, 9u)) => uvec2(64u, 9u)
 * (6u + uvec2(38u, 35u)) => uvec2(44u, 41u)
 * (6u + uvec2(64u, 9u)) => uvec2(70u, 15u)
 * (12u + uvec2(38u, 35u)) => uvec2(50u, 47u)
 * (12u + uvec2(64u, 9u)) => uvec2(76u, 21u)
 * (32u + uvec2(38u, 35u)) => uvec2(70u, 67u)
 * (32u + uvec2(64u, 9u)) => uvec2(96u, 41u)
 * (74u + uvec2(38u, 35u)) => uvec2(112u, 109u)
 * (74u + uvec2(64u, 9u)) => uvec2(138u, 83u)
 */
#version 150

void main()
{
  float[all(equal((0u + uvec2(38u, 35u)), uvec2(38u, 35u))) ? 1 : -1] array0;
  float[all(equal((0u + uvec2(64u, 9u)), uvec2(64u, 9u))) ? 1 : -1] array1;
  float[all(equal((6u + uvec2(38u, 35u)), uvec2(44u, 41u))) ? 1 : -1] array2;
  float[all(equal((6u + uvec2(64u, 9u)), uvec2(70u, 15u))) ? 1 : -1] array3;
  float[all(equal((12u + uvec2(38u, 35u)), uvec2(50u, 47u))) ? 1 : -1] array4;
  float[all(equal((12u + uvec2(64u, 9u)), uvec2(76u, 21u))) ? 1 : -1] array5;
  float[all(equal((32u + uvec2(38u, 35u)), uvec2(70u, 67u))) ? 1 : -1] array6;
  float[all(equal((32u + uvec2(64u, 9u)), uvec2(96u, 41u))) ? 1 : -1] array7;
  float[all(equal((74u + uvec2(38u, 35u)), uvec2(112u, 109u))) ? 1 : -1] array8;
  float[all(equal((74u + uvec2(64u, 9u)), uvec2(138u, 83u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
