/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * smoothstep(vec2(-1.9, -1.9), vec2(-0.6333333, -0.6333333), vec2(-2.0, -0.6666667)) => vec2(0.0, 0.9979589)
 * smoothstep(vec2(-1.9, -1.9), vec2(-0.6333333, -0.6333333), vec2(0.6666667, 2.0)) => vec2(1.0, 1.0)
 * smoothstep(vec2(-1.9, -1.9), vec2(0.6333333, 0.6333333), vec2(-2.0, -0.6666667)) => vec2(0.0, 0.4802677)
 * smoothstep(vec2(-1.9, -1.9), vec2(0.6333333, 0.6333333), vec2(0.6666667, 2.0)) => vec2(1.0, 1.0)
 * smoothstep(vec2(-1.9, -1.9), vec2(1.9, 1.9), vec2(-2.0, -0.6666667)) => vec2(0.0, 0.24764164)
 * smoothstep(vec2(-1.9, -1.9), vec2(1.9, 1.9), vec2(0.6666667, 2.0)) => vec2(0.7523584, 1.0)
 * smoothstep(vec2(-0.6333333, -0.6333333), vec2(0.6333333, 0.6333333), vec2(-2.0, -0.6666667)) => vec2(0.0, 0.0)
 * smoothstep(vec2(-0.6333333, -0.6333333), vec2(0.6333333, 0.6333333), vec2(0.6666667, 2.0)) => vec2(1.0, 1.0)
 * smoothstep(vec2(-0.6333333, -0.6333333), vec2(1.9, 1.9), vec2(-2.0, -0.6666667)) => vec2(0.0, 0.0)
 * smoothstep(vec2(-0.6333333, -0.6333333), vec2(1.9, 1.9), vec2(0.6666667, 2.0)) => vec2(0.5197323, 1.0)
 * smoothstep(vec2(0.6333333, 0.6333333), vec2(1.9, 1.9), vec2(-2.0, -0.6666667)) => vec2(0.0, 0.0)
 * smoothstep(vec2(0.6333333, 0.6333333), vec2(1.9, 1.9), vec2(0.6666667, 2.0)) => vec2(0.0020411173, 1.0)
 */
#version 120

void main()
{
  float[distance(smoothstep(vec2(-1.9, -1.9), vec2(-0.6333333, -0.6333333), vec2(-2.0, -0.6666667)), vec2(0.0, 0.9979589)) <= 9.979589e-06 ? 1 : -1] array0;
  float[distance(smoothstep(vec2(-1.9, -1.9), vec2(-0.6333333, -0.6333333), vec2(0.6666667, 2.0)), vec2(1.0, 1.0)) <= 1.4142135e-05 ? 1 : -1] array1;
  float[distance(smoothstep(vec2(-1.9, -1.9), vec2(0.6333333, 0.6333333), vec2(-2.0, -0.6666667)), vec2(0.0, 0.4802677)) <= 4.802677e-06 ? 1 : -1] array2;
  float[distance(smoothstep(vec2(-1.9, -1.9), vec2(0.6333333, 0.6333333), vec2(0.6666667, 2.0)), vec2(1.0, 1.0)) <= 1.4142135e-05 ? 1 : -1] array3;
  float[distance(smoothstep(vec2(-1.9, -1.9), vec2(1.9, 1.9), vec2(-2.0, -0.6666667)), vec2(0.0, 0.24764164)) <= 2.4764163e-06 ? 1 : -1] array4;
  float[distance(smoothstep(vec2(-1.9, -1.9), vec2(1.9, 1.9), vec2(0.6666667, 2.0)), vec2(0.7523584, 1.0)) <= 1.2514164e-05 ? 1 : -1] array5;
  float[distance(smoothstep(vec2(-0.6333333, -0.6333333), vec2(0.6333333, 0.6333333), vec2(-2.0, -0.6666667)), vec2(0.0, 0.0)) <= 0.0 ? 1 : -1] array6;
  float[distance(smoothstep(vec2(-0.6333333, -0.6333333), vec2(0.6333333, 0.6333333), vec2(0.6666667, 2.0)), vec2(1.0, 1.0)) <= 1.4142135e-05 ? 1 : -1] array7;
  float[distance(smoothstep(vec2(-0.6333333, -0.6333333), vec2(1.9, 1.9), vec2(-2.0, -0.6666667)), vec2(0.0, 0.0)) <= 0.0 ? 1 : -1] array8;
  float[distance(smoothstep(vec2(-0.6333333, -0.6333333), vec2(1.9, 1.9), vec2(0.6666667, 2.0)), vec2(0.5197323, 1.0)) <= 1.1269967e-05 ? 1 : -1] array9;
  float[distance(smoothstep(vec2(0.6333333, 0.6333333), vec2(1.9, 1.9), vec2(-2.0, -0.6666667)), vec2(0.0, 0.0)) <= 0.0 ? 1 : -1] array10;
  float[distance(smoothstep(vec2(0.6333333, 0.6333333), vec2(1.9, 1.9), vec2(0.6666667, 2.0)), vec2(0.0020411173, 1.0)) <= 1.0000021e-05 ? 1 : -1] array11;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
