/*
 * Decompiled with CFR 0.152.
 */
package tr.data;

import java.awt.Frame;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;
import tr.data.DAOProvider;
import tr.data.DAOProviderLookup;
import tr.data.FileFilterImpl;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.datastore.xstream.XStreamDataStore;
import tr.model.Data;
import tr.util.Utils;
import tr.util.UtilsFile;
import tr.view.WindowUtils;

public final class NewAction
extends CallableSystemAction {
    private static final Logger LOG = Logger.getLogger("tr.data");

    protected String iconResource() {
        return "au/com/thinkingrock/tr/resource/icons/DataNew.png";
    }

    public void performAction() {
        File newfile;
        String path;
        String extn;
        Frame p;
        int returnVal;
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds == null) {
            LOG.severe("Datastore was not found.");
            return;
        }
        JFileChooser chooser = new JFileChooser();
        String[] extns = XStreamDataStore.FILE_EXTENSIONS;
        FileFilterImpl filter = new FileFilterImpl(NbBundle.getMessage(NewAction.class, (String)"tr.xstream.datafiles"), extns, true);
        chooser.setFileFilter(filter);
        File defaultFile = new File(ds.getPath());
        if (defaultFile.exists()) {
            chooser.setSelectedFile(defaultFile);
        }
        if ((returnVal = chooser.showDialog(p = WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(NewAction.class, (String)"new.file"))) != 0) {
            return;
        }
        WindowUtils.closeWindows();
        try {
            ds.store();
        }
        catch (Exception ex) {
            // empty catch block
        }
        DAOProvider screensDAOProvider = (DAOProvider)DAOProviderLookup.instance().lookup(DAOProvider.class);
        if (screensDAOProvider != null) {
            try {
                LOG.info("Saving actions screens.");
                if (screensDAOProvider.isInitialised()) {
                    screensDAOProvider.provide().persist();
                    screensDAOProvider.provide().reset();
                    screensDAOProvider.reset();
                }
            }
            catch (Exception ex) {
                LOG.severe("Review Actions screens could not be saved. " + ex.getMessage());
            }
        }
        if (!Utils.in((String)(extn = UtilsFile.getExtension((String)(path = chooser.getSelectedFile().getPath()))), (String[])extns)) {
            path = UtilsFile.setExtension((String)path, (String)"trx");
        }
        if ((newfile = new File(path)).exists()) {
            String t = NbBundle.getMessage(NewAction.class, (String)"new.file");
            String m = NbBundle.getMessage(NewAction.class, (String)"confirm.replace.file");
            int r = JOptionPane.showConfirmDialog(p, m, t, 0);
            if (r == 0) {
                newfile.delete();
            } else {
                return;
            }
        }
        LOG.info("New file: " + path);
        try {
            newfile.createNewFile();
            ds.setPath(path);
            ds.setData(new Data());
            ds.setChanged(true);
            ds.store();
            WindowManager.getDefault().getMainWindow().setTitle("ThinkingRock " + path);
            WindowUtils.closeWindows();
            WindowUtils.openInitialWindow();
        }
        catch (Exception ex) {
            String t = NbBundle.getMessage(NewAction.class, (String)"new.file.error.title");
            String m = NbBundle.getMessage(NewAction.class, (String)"new.file.error.message") + "\n" + ex.getMessage();
            JOptionPane.showMessageDialog(p, m, t, 0);
        }
    }

    public String getName() {
        return NbBundle.getMessage(NewAction.class, (String)"CTL_NewAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

