/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.FailFastAssertionException;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaException;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.regex.RegularExpression;
import com.networknt.schema.utils.JsonType;
import com.networknt.schema.utils.TypeFactory;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternValidator
extends BaseKeywordValidator {
    private static final Logger logger = LoggerFactory.getLogger(PatternValidator.class);
    private final String pattern;
    private final RegularExpression compiledPattern;

    public PatternValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.PATTERN, schemaNode, schemaLocation, parentSchema, schemaContext);
        this.pattern = Optional.ofNullable(schemaNode).filter(JsonNode::isTextual).map(JsonNode::textValue).orElse(null);
        try {
            this.compiledPattern = RegularExpression.compile(this.pattern, schemaContext);
        }
        catch (RuntimeException e) {
            e.setStackTrace(new StackTraceElement[0]);
            logger.error("Failed to compile pattern '{}': {}", (Object)this.pattern, (Object)e.getMessage());
            throw e;
        }
    }

    private boolean matches(String value) {
        return this.compiledPattern.matches(value);
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.schemaContext.getSchemaRegistryConfig());
        if (nodeType != JsonType.STRING) {
            return;
        }
        try {
            if (!this.matches(node.asText())) {
                executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).arguments(this.pattern)).build());
                return;
            }
        }
        catch (FailFastAssertionException | SchemaException e) {
            throw e;
        }
        catch (RuntimeException e) {
            logger.error("Failed to apply pattern '{}' at {}: {}", new Object[]{this.pattern, instanceLocation, e.getMessage()});
            throw e;
        }
    }
}

