/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.InvalidSchemaRefException;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaException;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaRef;
import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.SpecificationVersion;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.utils.ThreadSafeCachingSupplier;
import java.util.Iterator;
import java.util.function.Supplier;

public class RefValidator
extends BaseKeywordValidator {
    protected final SchemaRef schema;
    private static final String REF_CURRENT = "#";

    public RefValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.REF, schemaNode, schemaLocation, parentSchema, schemaContext);
        String refValue = schemaNode.asText();
        this.schema = RefValidator.getRefSchema(parentSchema, schemaContext, refValue);
    }

    static SchemaRef getRefSchema(Schema parentSchema, SchemaContext schemaContext, String refValue) {
        String refValueOriginal = refValue;
        if (!refValue.startsWith(REF_CURRENT)) {
            int index = refValue.indexOf(REF_CURRENT);
            String refUri = index > 0 ? refValue.substring(0, index) : refValue;
            String schemaUriFinal = RefValidator.resolve(parentSchema, refUri);
            SchemaLocation schemaLocation = SchemaLocation.of(schemaUriFinal);
            return new SchemaRef(RefValidator.getSupplier(() -> {
                Schema schemaResource = (Schema)schemaContext.getSchemaResources().get(schemaUriFinal);
                if (schemaResource == null && (schemaResource = schemaContext.getSchemaRegistry().loadSchema(schemaLocation)) != null) {
                    RefValidator.copySchemaResources(schemaContext, schemaResource);
                }
                if (index < 0) {
                    if (schemaResource == null) {
                        return null;
                    }
                    return schemaResource;
                }
                String newRefValue = refValue.substring(index);
                String find = schemaLocation.getAbsoluteIri() + newRefValue;
                Schema findSchemaResource = (Schema)schemaContext.getSchemaResources().get(find);
                if (findSchemaResource == null) {
                    findSchemaResource = (Schema)schemaContext.getDynamicAnchors().get(find);
                }
                if ((schemaResource = findSchemaResource != null ? findSchemaResource : RefValidator.getSchema(schemaResource, schemaContext, newRefValue, refValueOriginal)) == null) {
                    return null;
                }
                return schemaResource;
            }, schemaContext.getSchemaRegistryConfig().isCacheRefs()));
        }
        if (SchemaLocation.Fragment.isAnchorFragment(refValue)) {
            String absoluteIri = RefValidator.resolve(parentSchema, refValue);
            return new SchemaRef(RefValidator.getSupplier(() -> {
                Schema schemaResource = (Schema)schemaContext.getSchemaResources().get(absoluteIri);
                if (schemaResource == null) {
                    schemaResource = (Schema)schemaContext.getDynamicAnchors().get(absoluteIri);
                }
                if (schemaResource == null) {
                    schemaResource = RefValidator.getSchema(parentSchema, schemaContext, refValue, refValueOriginal);
                }
                if (schemaResource == null) {
                    return null;
                }
                return schemaResource;
            }, schemaContext.getSchemaRegistryConfig().isCacheRefs()));
        }
        if (refValue.equals(REF_CURRENT)) {
            return new SchemaRef(RefValidator.getSupplier(() -> parentSchema.findSchemaResourceRoot(), schemaContext.getSchemaRegistryConfig().isCacheRefs()));
        }
        return new SchemaRef(RefValidator.getSupplier(() -> RefValidator.getSchema(parentSchema, schemaContext, refValue, refValueOriginal), schemaContext.getSchemaRegistryConfig().isCacheRefs()));
    }

    static <T> Supplier<T> getSupplier(Supplier<T> supplier, boolean cache) {
        return cache ? new ThreadSafeCachingSupplier(supplier) : supplier;
    }

    private static void copySchemaResources(SchemaContext schemaContext, Schema schemaResource) {
        if (!schemaResource.getSchemaContext().getSchemaResources().isEmpty()) {
            schemaContext.getSchemaResources().putAll(schemaResource.getSchemaContext().getSchemaResources());
        }
        if (!schemaResource.getSchemaContext().getSchemaReferences().isEmpty()) {
            schemaContext.getSchemaReferences().putAll(schemaResource.getSchemaContext().getSchemaReferences());
        }
        if (!schemaResource.getSchemaContext().getDynamicAnchors().isEmpty()) {
            schemaContext.getDynamicAnchors().putAll(schemaResource.getSchemaContext().getDynamicAnchors());
        }
    }

    private static String resolve(Schema parentSchema, String refValue) {
        Schema base = parentSchema;
        if (parentSchema.getId() != null && parentSchema.getParentSchema() != null && parentSchema.getSchemaContext().getDialect().getSpecificationVersion().getOrder() <= SpecificationVersion.DRAFT_7.getOrder()) {
            base = parentSchema.getParentSchema();
        }
        return SchemaLocation.resolve(base.getSchemaLocation(), refValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schema getSchema(Schema parent, SchemaContext schemaContext, String refValue, String refValueOriginal) {
        String schemaReference = RefValidator.resolve(parent, refValueOriginal);
        Schema result = (Schema)schemaContext.getSchemaReferences().get(schemaReference);
        if (result == null) {
            NodePath fragment = SchemaLocation.Fragment.of(refValue);
            SchemaRegistry schemaRegistry = schemaContext.getSchemaRegistry();
            synchronized (schemaRegistry) {
                result = (Schema)schemaContext.getSchemaReferences().get(schemaReference);
                if (result == null && (result = parent.getSubSchema(fragment)) != null) {
                    schemaContext.getSchemaReferences().put(schemaReference, result);
                }
            }
        }
        return result;
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        Schema refSchema = this.schema.getSchema();
        if (refSchema == null) {
            Error error = ((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().keyword(KeywordType.REF.getValue())).messageKey("internal.unresolvedRef")).message("Reference {0} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).arguments(this.schemaNode.asText())).build();
            throw new InvalidSchemaRefException(error);
        }
        refSchema.validate(executionContext, node, rootNode, instanceLocation);
    }

    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        Schema refSchema = this.schema.getSchema();
        if (refSchema == null) {
            Error error = ((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().keyword(KeywordType.REF.getValue())).messageKey("internal.unresolvedRef")).message("Reference {0} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).arguments(this.schemaNode.asText())).build();
            throw new InvalidSchemaRefException(error);
        }
        if (node == null) {
            boolean circularDependency = false;
            SchemaLocation schemaLocation = refSchema.getSchemaLocation();
            Iterator<Schema> iter = executionContext.getEvaluationSchema().descendingIterator();
            while (iter.hasNext()) {
                Schema check = iter.next();
                if (!check.getSchemaLocation().equals(schemaLocation)) continue;
                circularDependency = true;
                break;
            }
            if (circularDependency) {
                return;
            }
        }
        refSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
    }

    public SchemaRef getSchemaRef() {
        return this.schema;
    }

    @Override
    public void preloadSchema() {
        Schema jsonSchema = null;
        try {
            jsonSchema = this.schema.getSchema();
        }
        catch (SchemaException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new SchemaException(e);
        }
        jsonSchema.initializeValidators();
    }
}

