/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.resource;

import com.networknt.schema.resource.MapResourceLoader;
import com.networknt.schema.resource.ResourceLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class ResourceLoaders
extends ArrayList<ResourceLoader> {
    private static final long serialVersionUID = 1L;

    public ResourceLoaders() {
    }

    public ResourceLoaders(Collection<? extends ResourceLoader> c) {
        super(c);
    }

    public ResourceLoaders(int initialCapacity) {
        super(initialCapacity);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ResourceLoaders values = new ResourceLoaders();

        public Builder() {
        }

        public Builder(Builder copy) {
            this.values.addAll(copy.values);
        }

        public Builder with(Builder builder) {
            if (!builder.values.isEmpty()) {
                this.values.addAll(builder.values);
            }
            return this;
        }

        public Builder values(Consumer<List<ResourceLoader>> customizer) {
            customizer.accept(this.values);
            return this;
        }

        public Builder add(ResourceLoader resourceLoader) {
            this.values.add(resourceLoader);
            return this;
        }

        public Builder resources(Map<String, String> resources) {
            this.values.add(new MapResourceLoader(resources));
            return this;
        }

        public Builder resources(Function<String, String> resources) {
            this.values.add(new MapResourceLoader(resources));
            return this;
        }

        public <T> Builder resources(Function<String, T> mapIriToObject, Function<T, String> mapObjectToData) {
            this.values.add(new MapResourceLoader(mapIriToObject, mapObjectToData));
            return this;
        }

        public ResourceLoaders build() {
            return this.values;
        }
    }
}

